/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.border;

import org.apache.wicket.Component;
import org.apache.wicket.DequeueContext;
import org.apache.wicket.DequeueTagAction;
import org.apache.wicket.IQueueRegion;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupFragment;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.TagUtils;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.MarkupUtil;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.BorderMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public abstract class Border
extends WebMarkupContainer
implements IComponentResolver,
IQueueRegion {
    private static final long serialVersionUID = 1L;
    public static final String BODY = "body";
    public static final String BORDER = "border";
    private final BorderBodyContainer body;

    public Border(String id) {
        this(id, null);
    }

    public Border(String id, IModel<?> model) {
        super(id, model);
        this.body = new BorderBodyContainer(id + "_body");
        this.queueToBorder(this.body);
    }

    public final BorderBodyContainer getBodyContainer() {
        return this.body;
    }

    @Override
    public Border add(Component ... children) {
        for (Component component : children) {
            if (component == this.body || component.isAuto()) {
                this.addToBorder(component);
                continue;
            }
            this.getBodyContainer().add(component);
        }
        return this;
    }

    @Override
    public Border addOrReplace(Component ... children) {
        for (Component component : children) {
            if (component == this.body) {
                super.addOrReplace(component);
                continue;
            }
            this.getBodyContainer().addOrReplace(component);
        }
        return this;
    }

    @Override
    public Border remove(Component component) {
        if (component == this.body) {
            this.removeFromBorder(component);
        } else {
            this.getBodyContainer().remove(component);
        }
        return this;
    }

    @Override
    public Border remove(String id) {
        if (this.body.getId().equals(id)) {
            super.remove(id);
        } else {
            this.getBodyContainer().remove(id);
        }
        return this;
    }

    @Override
    public Border removeAll() {
        this.getBodyContainer().removeAll();
        return this;
    }

    @Override
    public Border replace(Component replacement) {
        if (this.body.getId().equals(replacement.getId())) {
            this.replaceInBorder(replacement);
        } else {
            this.getBodyContainer().replace(replacement);
        }
        return this;
    }

    public Border addToBorder(Component ... children) {
        super.add(children);
        return this;
    }

    @Override
    public Border queue(Component ... components) {
        this.getBodyContainer().queue(components);
        return this;
    }

    @Override
    protected void onConfigure() {
        super.onConfigure();
        this.dequeue();
    }

    public Border queueToBorder(Component ... children) {
        super.queue(children);
        return this;
    }

    public Border removeFromBorder(Component child) {
        super.remove(child);
        return this;
    }

    public Border replaceInBorder(Component component) {
        super.replace(component);
        return this;
    }

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (!this.body.rendering && TagUtils.isWicketBodyTag(tag)) {
            return this.body;
        }
        return null;
    }

    @Override
    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new BorderMarkupSourcingStrategy();
    }

    @Override
    public IMarkupFragment getMarkup(Component child) {
        Markup markup = this.getAssociatedMarkup();
        if (markup == null) {
            throw new MarkupException("Unable to find associated markup file for Border: " + this.toString());
        }
        IMarkupFragment borderMarkup = null;
        for (int i = 0; i < markup.size(); ++i) {
            MarkupElement elem = markup.get(i);
            if (!TagUtils.isWicketBorderTag(elem)) continue;
            borderMarkup = new MarkupFragment(markup, i);
            break;
        }
        if (borderMarkup == null) {
            throw new MarkupException(markup.getMarkupResourceStream(), "Unable to find <wicket:border> tag in associated markup file for Border: " + this.toString());
        }
        if (child == null) {
            return borderMarkup;
        }
        if (child == this.body) {
            return this.body.getMarkup();
        }
        IMarkupFragment childMarkup = borderMarkup.find(child.getId());
        if (childMarkup != null) {
            return childMarkup;
        }
        return ((BorderMarkupSourcingStrategy)this.getMarkupSourcingStrategy()).findMarkupInAssociatedFileHeader(this, child);
    }

    @Override
    protected DequeueTagAction canDequeueTag(ComponentTag tag) {
        if (this.canDequeueBody(tag)) {
            return DequeueTagAction.DEQUEUE;
        }
        return super.canDequeueTag(tag);
    }

    @Override
    public Component findComponentToDequeue(ComponentTag tag) {
        if (this.canDequeueBody(tag)) {
            tag.setId(this.body.getId());
        }
        return super.findComponentToDequeue(tag);
    }

    private boolean canDequeueBody(ComponentTag tag) {
        boolean isBodyTag = tag instanceof WicketTag && ((WicketTag)tag).isBodyTag();
        return isBodyTag;
    }

    @Override
    protected void addDequeuedComponent(Component component, ComponentTag tag) {
        super.add(component);
    }

    @Override
    public IMarkupFragment getRegionMarkup() {
        IMarkupFragment markup = super.getRegionMarkup();
        if (markup == null) {
            return markup;
        }
        IMarkupFragment borderMarkup = MarkupUtil.findStartTag(markup, BORDER);
        return borderMarkup != null ? borderMarkup : markup;
    }

    public class BorderBodyContainer
    extends WebMarkupContainer
    implements IQueueRegion {
        private static final long serialVersionUID = 1L;
        private transient IMarkupFragment markup;
        protected boolean rendering;

        public BorderBodyContainer(String id) {
            super(id);
        }

        @Override
        protected void onComponentTag(ComponentTag tag) {
            if (tag.isOpenClose()) {
                tag.setType(XmlTag.TagType.OPEN);
                tag.setModified(true);
            }
            super.onComponentTag(tag);
        }

        @Override
        public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
            if (markupStream.getPreviousTag().isOpen()) {
                markupStream.skipRawMarkup();
            }
            IMarkupFragment markup = Border.this.getMarkup();
            MarkupStream stream = new MarkupStream(markup);
            ComponentTag tag = stream.getTag();
            stream.next();
            super.onComponentTagBody(stream, tag);
        }

        @Override
        protected void onRender() {
            this.rendering = true;
            try {
                super.onRender();
            }
            finally {
                this.rendering = false;
            }
        }

        @Override
        public IMarkupFragment getMarkup() {
            if (this.markup == null) {
                this.markup = this.findByName(this.getParent().getMarkup(null), Border.BODY);
            }
            return this.markup;
        }

        private IMarkupFragment findByName(IMarkupFragment markup, String name) {
            Args.notEmpty((String)name, (String)"name");
            MarkupStream stream = new MarkupStream(markup);
            stream.skipUntil(ComponentTag.class);
            stream.next();
            while (stream.skipUntil(ComponentTag.class)) {
                ComponentTag tag = stream.getTag();
                if ((tag.isOpen() || tag.isOpenClose()) && TagUtils.isWicketBodyTag(tag)) {
                    return stream.getMarkupFragment();
                }
                stream.next();
            }
            return null;
        }

        @Override
        public IMarkupFragment getMarkup(Component child) {
            IMarkupFragment markup = Border.this.getMarkup();
            if (markup == null) {
                return null;
            }
            if (child == null) {
                return markup;
            }
            return markup.find(child.getId());
        }

        @Override
        public DequeueContext newDequeueContext() {
            Border border = this.findParent(Border.class);
            IMarkupFragment fragment = border.getMarkup();
            if (fragment == null) {
                return null;
            }
            return new DequeueContext(fragment, this, true);
        }

        @Override
        public Component findComponentToDequeue(ComponentTag tag) {
            Component component = super.findComponentToDequeue(tag);
            if (component != null) {
                return component;
            }
            for (MarkupContainer cursor = this.getParent(); cursor != null; cursor = cursor.getParent()) {
                component = cursor.findComponentToDequeue(tag);
                if (component != null) {
                    return component;
                }
                if (cursor instanceof BorderBodyContainer) break;
            }
            return null;
        }
    }
}

