/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import java.lang.ref.WeakReference;
import org.apache.wicket.Page;
import org.apache.wicket.application.DefaultClassResolver;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.feedback.DefaultCleanupFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class ApplicationSettings {
    private WeakReference<Class<? extends Page>> accessDeniedPage;
    private IClassResolver classResolver = new DefaultClassResolver();
    private WeakReference<Class<? extends Page>> internalErrorPage;
    private WeakReference<Class<? extends Page>> pageExpiredErrorPage;
    private Bytes defaultMaximumUploadSize = Bytes.MAX;
    private boolean uploadProgressUpdatesEnabled = false;
    private IFeedbackMessageFilter feedbackMessageCleanupFilter = new DefaultCleanupFeedbackMessageFilter();

    public Class<? extends Page> getAccessDeniedPage() {
        return (Class)this.accessDeniedPage.get();
    }

    public IClassResolver getClassResolver() {
        return this.classResolver;
    }

    public Bytes getDefaultMaximumUploadSize() {
        return this.defaultMaximumUploadSize;
    }

    public Class<? extends Page> getInternalErrorPage() {
        return (Class)this.internalErrorPage.get();
    }

    public Class<? extends Page> getPageExpiredErrorPage() {
        return (Class)this.pageExpiredErrorPage.get();
    }

    public boolean isUploadProgressUpdatesEnabled() {
        return this.uploadProgressUpdatesEnabled;
    }

    public ApplicationSettings setAccessDeniedPage(Class<? extends Page> accessDeniedPage) {
        if (accessDeniedPage == null) {
            throw new IllegalArgumentException("Argument accessDeniedPage may not be null");
        }
        this.checkPageClass(accessDeniedPage);
        this.accessDeniedPage = new WeakReference<Class<? extends Page>>(accessDeniedPage);
        return this;
    }

    public ApplicationSettings setClassResolver(IClassResolver defaultClassResolver) {
        this.classResolver = defaultClassResolver;
        return this;
    }

    public ApplicationSettings setDefaultMaximumUploadSize(Bytes defaultMaximumUploadSize) {
        this.defaultMaximumUploadSize = defaultMaximumUploadSize;
        return this;
    }

    public ApplicationSettings setInternalErrorPage(Class<? extends Page> internalErrorPage) {
        Args.notNull(internalErrorPage, "internalErrorPage");
        this.checkPageClass(internalErrorPage);
        this.internalErrorPage = new WeakReference<Class<? extends Page>>(internalErrorPage);
        return this;
    }

    public ApplicationSettings setPageExpiredErrorPage(Class<? extends Page> pageExpiredErrorPage) {
        Args.notNull(pageExpiredErrorPage, "pageExpiredErrorPage");
        this.checkPageClass(pageExpiredErrorPage);
        this.pageExpiredErrorPage = new WeakReference<Class<? extends Page>>(pageExpiredErrorPage);
        return this;
    }

    public ApplicationSettings setUploadProgressUpdatesEnabled(boolean uploadProgressUpdatesEnabled) {
        this.uploadProgressUpdatesEnabled = uploadProgressUpdatesEnabled;
        return this;
    }

    private <C extends Page> void checkPageClass(Class<C> pageClass) {
        if (!Page.class.isAssignableFrom(pageClass)) {
            throw new IllegalArgumentException("argument " + pageClass + " must be a subclass of Page");
        }
    }

    public ApplicationSettings setFeedbackMessageCleanupFilter(IFeedbackMessageFilter filter) {
        Args.notNull(filter, "filter");
        this.feedbackMessageCleanupFilter = filter;
        return this;
    }

    public IFeedbackMessageFilter getFeedbackMessageCleanupFilter() {
        return this.feedbackMessageCleanupFilter;
    }
}

