/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap;

import org.apache.uniffle.shaded.org.roaringbitmap.PeekableCharIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.RunContainer;

final class ReverseRunContainerCharIterator
implements PeekableCharIterator {
    int pos;
    private int le;
    private RunContainer parent;
    private int maxlength;
    private int base;

    ReverseRunContainerCharIterator() {
    }

    ReverseRunContainerCharIterator(RunContainer p) {
        this.wrap(p);
    }

    @Override
    public PeekableCharIterator clone() {
        try {
            return (PeekableCharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public char next() {
        char ans = (char)(this.base + this.maxlength - this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = this.parent.getLength(this.pos);
                this.base = this.parent.getValue(this.pos);
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.maxlength - this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = this.parent.getLength(this.pos);
                this.base = this.parent.getValue(this.pos);
            }
        }
        return ans;
    }

    @Override
    public void advanceIfNeeded(char maxval) {
        while (this.base > maxval) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = this.parent.getLength(this.pos);
                this.base = this.parent.getValue(this.pos);
                continue;
            }
            return;
        }
        if (this.base + this.maxlength < maxval) {
            return;
        }
        this.le = this.maxlength + this.base - maxval;
    }

    @Override
    public char peekNext() {
        return (char)(this.base + this.maxlength - this.le);
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    void wrap(RunContainer p) {
        this.parent = p;
        this.pos = this.parent.nbrruns - 1;
        this.le = 0;
        if (this.pos >= 0) {
            this.maxlength = this.parent.getLength(this.pos);
            this.base = this.parent.getValue(this.pos);
        }
    }
}

