/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;

public class NettyManagedBuffer
extends ManagedBuffer {
    private ByteBuf buf;

    public NettyManagedBuffer(ByteBuf byteBuf) {
        this.buf = byteBuf;
    }

    @Override
    public int size() {
        return this.buf.readableBytes();
    }

    @Override
    public ByteBuf byteBuf() {
        return Unpooled.wrappedBuffer((ByteBuffer)this.nioByteBuffer());
    }

    @Override
    public ByteBuffer nioByteBuffer() {
        return this.buf.nioBuffer();
    }

    @Override
    public ManagedBuffer release() {
        this.buf.release();
        return this;
    }

    @Override
    public Object convertToNetty() {
        return this.buf.duplicate().retain();
    }
}

