/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.walk.stepdown;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.stepdown.ChildIterable;
import nl.basjes.parse.useragent.parser.UserAgentBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentParser;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class UserAgentGetChildrenVisitor
extends UserAgentBaseVisitor<Iterator<? extends ParseTree>> {
    private final String name;
    private final ChildIterable childIterable;
    private static final Iterator<ParseTree> EMPTY = Collections.emptyListIterator();

    public UserAgentGetChildrenVisitor(String name, int start, int end) {
        this.name = name;
        switch (name) {
            case "keyvalue": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.KeyValueContext || clazz instanceof UserAgentParser.KeyWithoutValueContext || clazz instanceof UserAgentParser.ProductNameKeyValueContext);
                break;
            }
            case "product": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.ProductContext || clazz instanceof UserAgentParser.CommentProductContext || clazz instanceof UserAgentParser.ProductNameNoVersionContext);
                break;
            }
            case "uuid": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.UuIdContext || clazz instanceof UserAgentParser.ProductNameUuidContext);
                break;
            }
            case "base64": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.Base64Context);
                break;
            }
            case "url": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.SiteUrlContext || clazz instanceof UserAgentParser.ProductNameUrlContext);
                break;
            }
            case "email": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.EmailAddressContext || clazz instanceof UserAgentParser.ProductNameEmailContext);
                break;
            }
            case "text": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.MultipleWordsContext || clazz instanceof UserAgentParser.VersionWordsContext || clazz instanceof UserAgentParser.EmptyWordContext || clazz instanceof UserAgentParser.RootTextContext || clazz instanceof UserAgentParser.KeyValueVersionNameContext);
                break;
            }
            case "name": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.ProductNameContext);
                break;
            }
            case "version": {
                this.childIterable = new ChildIterable(true, start, end, clazz -> clazz instanceof UserAgentParser.ProductVersionContext || clazz instanceof UserAgentParser.ProductVersionWithCommasContext || clazz instanceof UserAgentParser.ProductVersionWordsContext || clazz instanceof UserAgentParser.ProductVersionSingleWordContext);
                break;
            }
            case "comments": {
                this.childIterable = new ChildIterable(true, start, end, clazz -> clazz instanceof UserAgentParser.CommentBlockContext);
                break;
            }
            case "key": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.KeyNameContext);
                break;
            }
            case "value": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.UuIdContext || clazz instanceof UserAgentParser.MultipleWordsContext || clazz instanceof UserAgentParser.SiteUrlContext || clazz instanceof UserAgentParser.EmailAddressContext || clazz instanceof UserAgentParser.KeyValueVersionNameContext || clazz instanceof UserAgentParser.KeyValueProductVersionNameContext);
                break;
            }
            case "entry": {
                this.childIterable = new ChildIterable(false, start, end, clazz -> clazz instanceof UserAgentParser.CommentEntryContext);
                break;
            }
            default: {
                this.childIterable = new ChildIterable(false, start, end, clazz -> false);
            }
        }
    }

    @Override
    protected Iterator<? extends ParseTree> defaultResult() {
        return EMPTY;
    }

    Iterator<? extends ParseTree> getChildrenByName(ParserRuleContext ctx) {
        return this.childIterable.iterator(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitUserAgent(UserAgentParser.UserAgentContext ctx) {
        Iterator<? extends ParseTree> children = this.getChildrenByName(ctx);
        if (children.hasNext()) {
            return children;
        }
        return (Iterator)this.visitChildren(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitRootElements(UserAgentParser.RootElementsContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitProduct(UserAgentParser.ProductContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitProductNameNoVersion(UserAgentParser.ProductNameNoVersionContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitCommentProduct(UserAgentParser.CommentProductContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitProductName(UserAgentParser.ProductNameContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitProductNameKeyValue(UserAgentParser.ProductNameKeyValueContext ctx) {
        switch (this.name) {
            case "key": {
                return Collections.singletonList(ctx.key).iterator();
            }
            case "value": {
                List<ParserRuleContext> children = ctx.multipleWords();
                if (!children.isEmpty()) {
                    return children.iterator();
                }
                children = ctx.keyValueProductVersionName();
                if (!children.isEmpty()) {
                    return children.iterator();
                }
                children = ctx.siteUrl();
                if (!children.isEmpty()) {
                    return children.iterator();
                }
                children = ctx.emailAddress();
                if (!children.isEmpty()) {
                    return children.iterator();
                }
                children = ctx.uuId();
                return children.iterator();
            }
        }
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitProductVersion(UserAgentParser.ProductVersionContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitProductVersionWithCommas(UserAgentParser.ProductVersionWithCommasContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitKeyValue(UserAgentParser.KeyValueContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitKeyWithoutValue(UserAgentParser.KeyWithoutValueContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitCommentBlock(UserAgentParser.CommentBlockContext ctx) {
        return this.getChildrenByName(ctx);
    }

    @Override
    public Iterator<? extends ParseTree> visitCommentEntry(UserAgentParser.CommentEntryContext ctx) {
        return this.getChildrenByName(ctx);
    }
}

