/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.torque.Column;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.AbstractPeerImpl;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.schedule.JobEntryTorque;
import org.apache.turbine.services.schedule.JobEntryTorquePeer;
import org.apache.turbine.services.schedule.JobEntryTorqueRecordMapper;

public abstract class BaseJobEntryTorquePeerImpl
extends AbstractPeerImpl<JobEntryTorque> {
    private static final long serialVersionUID = 1750162102041L;

    public BaseJobEntryTorquePeerImpl() {
        this(new JobEntryTorqueRecordMapper(), JobEntryTorquePeer.TABLE, JobEntryTorquePeer.DATABASE_NAME);
    }

    public BaseJobEntryTorquePeerImpl(RecordMapper<JobEntryTorque> recordMapper, TableMap tableMap, String databaseName) {
        super(recordMapper, tableMap, databaseName);
    }

    public JobEntryTorque getDbObjectInstance() {
        return new JobEntryTorque();
    }

    public int doUpdate(ColumnValues columnValues, Connection con) throws TorqueException {
        Criteria selectCriteria = new Criteria(this.getDatabaseName());
        this.correctBooleans(columnValues);
        JdbcTypedValue pkValue = columnValues.remove((Object)JobEntryTorquePeer.JOB_ID);
        if (pkValue == null) {
            throw new TorqueException("The value for the primary key column JobEntryTorquePeer.JOB_ID must be set");
        }
        if (pkValue.getSqlExpression() == null) {
            selectCriteria.where((Object)JobEntryTorquePeer.JOB_ID, pkValue.getValue());
        } else {
            selectCriteria.where((Object)JobEntryTorquePeer.JOB_ID, (Object)pkValue.getSqlExpression());
        }
        int rowCount = this.doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    public int doDelete(JobEntryTorque obj) throws TorqueException {
        int result = this.doDelete(this.buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    public int doDelete(JobEntryTorque obj, Connection con) throws TorqueException {
        int result = this.doDelete(this.buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    public int doDelete(Collection<JobEntryTorque> objects) throws TorqueException {
        int result = this.doDelete(this.buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    public int doDelete(Collection<JobEntryTorque> objects, Connection con) throws TorqueException {
        int result = this.doDelete(this.buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    public Criteria buildCriteria(ObjectKey<?> pk) {
        Criteria criteria = new Criteria();
        criteria.and((Object)JobEntryTorquePeer.JOB_ID, pk);
        return criteria;
    }

    public Criteria buildCriteria(Collection<ObjectKey<?>> pks) {
        Criteria criteria = new Criteria();
        criteria.andIn((Object)JobEntryTorquePeer.JOB_ID, pks);
        return criteria;
    }

    public Criteria buildPkCriteria(Collection<JobEntryTorque> objects) {
        return this.buildCriteria(objects.stream().map(object -> object.getPrimaryKey()).collect(Collectors.toList()));
    }

    public Criteria buildCriteria(JobEntryTorque obj) {
        Criteria criteria = new Criteria(this.getDatabaseName());
        if (!obj.isNew()) {
            criteria.and((Object)JobEntryTorquePeer.JOB_ID, (Object)obj.getJobId());
        }
        criteria.and((Object)JobEntryTorquePeer.SECOND, (Object)obj.getSecond());
        criteria.and((Object)JobEntryTorquePeer.MINUTE, (Object)obj.getMinute());
        criteria.and((Object)JobEntryTorquePeer.HOUR, (Object)obj.getHour());
        criteria.and((Object)JobEntryTorquePeer.WEEK_DAY, (Object)obj.getWeekDay());
        criteria.and((Object)JobEntryTorquePeer.DAY_OF_MONTH, (Object)obj.getDayOfMonth());
        criteria.and((Object)JobEntryTorquePeer.TASK, (Object)obj.getTask());
        criteria.and((Object)JobEntryTorquePeer.EMAIL, (Object)obj.getEmail());
        criteria.and((Object)JobEntryTorquePeer.PROPERTY, (Object)obj.getProperty());
        return criteria;
    }

    public Criteria buildSelectCriteria(JobEntryTorque obj) {
        Criteria criteria = new Criteria(this.getDatabaseName());
        if (!obj.isNew()) {
            criteria.and((Object)JobEntryTorquePeer.JOB_ID, (Object)obj.getJobId());
        }
        criteria.and((Object)JobEntryTorquePeer.SECOND, (Object)obj.getSecond());
        criteria.and((Object)JobEntryTorquePeer.MINUTE, (Object)obj.getMinute());
        criteria.and((Object)JobEntryTorquePeer.HOUR, (Object)obj.getHour());
        criteria.and((Object)JobEntryTorquePeer.WEEK_DAY, (Object)obj.getWeekDay());
        criteria.and((Object)JobEntryTorquePeer.DAY_OF_MONTH, (Object)obj.getDayOfMonth());
        criteria.and((Object)JobEntryTorquePeer.TASK, (Object)obj.getTask());
        criteria.and((Object)JobEntryTorquePeer.EMAIL, (Object)obj.getEmail());
        return criteria;
    }

    public ColumnValues buildColumnValues(JobEntryTorque jobEntryTorque) throws TorqueException {
        ColumnValues columnValues = new ColumnValues();
        if (!jobEntryTorque.isNew() || jobEntryTorque.getJobId() != 0) {
            columnValues.put((Column)JobEntryTorquePeer.JOB_ID, new JdbcTypedValue((Object)jobEntryTorque.getJobId(), 4));
        }
        columnValues.put((Column)JobEntryTorquePeer.SECOND, new JdbcTypedValue((Object)jobEntryTorque.getSecond(), 4));
        columnValues.put((Column)JobEntryTorquePeer.MINUTE, new JdbcTypedValue((Object)jobEntryTorque.getMinute(), 4));
        columnValues.put((Column)JobEntryTorquePeer.HOUR, new JdbcTypedValue((Object)jobEntryTorque.getHour(), 4));
        columnValues.put((Column)JobEntryTorquePeer.WEEK_DAY, new JdbcTypedValue((Object)jobEntryTorque.getWeekDay(), 4));
        columnValues.put((Column)JobEntryTorquePeer.DAY_OF_MONTH, new JdbcTypedValue((Object)jobEntryTorque.getDayOfMonth(), 4));
        columnValues.put((Column)JobEntryTorquePeer.TASK, new JdbcTypedValue((Object)jobEntryTorque.getTask(), 12));
        columnValues.put((Column)JobEntryTorquePeer.EMAIL, new JdbcTypedValue((Object)jobEntryTorque.getEmail(), 12));
        columnValues.put((Column)JobEntryTorquePeer.PROPERTY, new JdbcTypedValue((Object)jobEntryTorque.getProperty(), -3));
        return columnValues;
    }

    public JobEntryTorque retrieveByPK(int pk) throws TorqueException, NoRowsException, TooManyRowsException {
        return this.retrieveByPK((ObjectKey<?>)SimpleKey.keyFor((int)pk));
    }

    public JobEntryTorque retrieveByPK(int pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        return this.retrieveByPK((ObjectKey<?>)SimpleKey.keyFor((int)pk), con);
    }

    public JobEntryTorque retrieveByPK(ObjectKey<?> pk) throws TorqueException, NoRowsException, TooManyRowsException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            JobEntryTorque result = this.retrieveByPK(pk, (Connection)connection);
            Transaction.commit((Connection)connection);
            JobEntryTorque jobEntryTorque = result;
            return jobEntryTorque;
        }
    }

    public JobEntryTorque retrieveByPK(ObjectKey<?> pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        Criteria criteria = this.buildCriteria(pk);
        JobEntryTorque v = (JobEntryTorque)this.doSelectSingleRecord(criteria, con);
        if (v == null) {
            throw new NoRowsException("Failed to select a row.");
        }
        return v;
    }

    public List<JobEntryTorque> retrieveByTypedPKs(Collection<Integer> pks) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            List<JobEntryTorque> result = this.retrieveByTypedPKs(pks, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<JobEntryTorque> list = result;
            return list;
        }
    }

    public List<JobEntryTorque> retrieveByTypedPKs(Collection<Integer> pks, Connection dbcon) throws TorqueException {
        if (pks == null || pks.size() == 0) {
            return new ArrayList<JobEntryTorque>();
        }
        ArrayList objectKeyList = new ArrayList();
        for (Integer pk : pks) {
            objectKeyList.add((ObjectKey<?>)SimpleKey.keyFor((Number)pk));
        }
        Criteria criteria = this.buildCriteria(objectKeyList);
        List result = this.doSelect(criteria, dbcon);
        return result;
    }

    public List<JobEntryTorque> retrieveByObjectKeys(Collection<ObjectKey<?>> pks) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            List<JobEntryTorque> result = this.retrieveByObjectKeys(pks, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<JobEntryTorque> list = result;
            return list;
        }
    }

    public List<JobEntryTorque> retrieveByObjectKeys(Collection<ObjectKey<?>> pks, Connection dbcon) throws TorqueException {
        if (pks == null || pks.size() == 0) {
            return new ArrayList<JobEntryTorque>();
        }
        Criteria criteria = this.buildCriteria(pks);
        List result = this.doSelect(criteria, dbcon);
        return result;
    }
}

