/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.keys;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.microprofile.jwt.JWTLogCategories;

public class HttpLocation
implements Supplier<byte[]> {
    private static final Logger LOG = Logger.getInstance((LogCategory)JWTLogCategories.KEYS.createChild("http"), HttpLocation.class);
    private final URI location;

    public HttpLocation(URI location) {
        if (!location.getScheme().startsWith("http")) {
            throw new IllegalArgumentException("Expected HTTP URI, found " + location);
        }
        this.location = location;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte[] get() {
        byte[] byArray;
        InputStream in;
        String contentType;
        Integer length;
        Integer responseCode;
        long start;
        block20: {
            start = System.nanoTime();
            responseCode = null;
            length = null;
            contentType = null;
            LOG.debug(String.format("Connecting to Key Server: %s", this.location));
            HttpURLConnection httpUrlConnection = (HttpURLConnection)this.location.toURL().openConnection();
            responseCode = httpUrlConnection.getResponseCode();
            contentType = httpUrlConnection.getHeaderField("content-type");
            if (responseCode != 200) {
                String responseMessage = httpUrlConnection.getResponseMessage();
                throw new UnexpectedHttpResponseException(responseCode, responseMessage);
            }
            in = httpUrlConnection.getInputStream();
            byte[] bytes = IO.readBytes((InputStream)in);
            length = bytes.length;
            byArray = bytes;
            if (in == null) break block20;
            in.close();
        }
        long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        if (responseCode == null) {
            String message = String.format("Key Server connection failed: %s, %s ms", this.location, elapsed);
            LOG.error(message);
        } else if (responseCode != 200) {
            String message = String.format("Key Server returned HTTP %s: %s, %s ms", responseCode, this.location, elapsed);
            LOG.error(message);
        } else {
            String message = String.format("Key Server returned HTTP %s: %s, %s, %s bytes, %s ms", responseCode, this.location, contentType, length, elapsed);
            LOG.info(message);
        }
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UnexpectedHttpResponseException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ReadFailureException(e);
                    }
                }
                catch (Throwable throwable3) {
                    long elapsed2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                    if (responseCode == null) {
                        String message = String.format("Key Server connection failed: %s, %s ms", this.location, elapsed2);
                        LOG.error(message);
                    } else if (responseCode != 200) {
                        String message = String.format("Key Server returned HTTP %s: %s, %s ms", responseCode, this.location, elapsed2);
                        LOG.error(message);
                    } else {
                        String message = String.format("Key Server returned HTTP %s: %s, %s, %s bytes, %s ms", responseCode, this.location, contentType, length, elapsed2);
                        LOG.info(message);
                    }
                    throw throwable3;
                }
            }
        }
    }

    public static class UnexpectedHttpResponseException
    extends RuntimeException {
        public UnexpectedHttpResponseException(int responseCode, String responseMessage) {
            super(String.format("Unexpected HTTP response: %s %s", responseCode, responseMessage));
        }
    }

    public static class ReadFailureException
    extends RuntimeException {
        public ReadFailureException(Exception cause) {
            super(String.format("Read failed: %s: %s", cause.getClass().getSimpleName(), cause.getMessage()), cause);
        }
    }
}

