/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.router.Router;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.reflection.Reflections;

public class RoutedDataSource
implements DataSource {
    private static final String OPENEJB_RESOURCE_PREFIX = "openejb:Resource/";
    protected Router delegate;

    public RoutedDataSource() {
    }

    public RoutedDataSource(Router router) {
        this.delegate = router;
    }

    public RoutedDataSource(String router) {
        this.setRouter(router);
    }

    public void setRouter(String router) {
        Object o;
        try {
            o = SystemInstance.get().getComponent(ContainerSystem.class).getJNDIContext().lookup(OPENEJB_RESOURCE_PREFIX + router);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Can't find router [" + router + "]", e);
        }
        if (!Router.class.isInstance(o)) {
            throw new IllegalArgumentException(o + " is not a router");
        }
        this.delegate = (Router)Router.class.cast(o);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        if (this.getTargetDataSource() == null) {
            return null;
        }
        return this.getTargetDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.getTargetDataSource() != null) {
            this.getTargetDataSource().setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.getTargetDataSource() != null) {
            this.getTargetDataSource().setLoginTimeout(seconds);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        if (this.getTargetDataSource() == null) {
            return -1;
        }
        return this.getTargetDataSource().getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.getTargetDataSource() == null) {
            return null;
        }
        return (T)Reflections.invokeByReflection(this.getTargetDataSource(), "unwrap", new Class[]{Class.class}, new Object[]{iface});
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        if (this.getTargetDataSource() == null) {
            return null;
        }
        return (Logger)Reflections.invokeByReflection(this.getTargetDataSource(), "getParentLogger", new Class[0], null);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.getTargetDataSource() == null) {
            return false;
        }
        return (Boolean)Reflections.invokeByReflection(this.getTargetDataSource(), "isWrapperFor", new Class[]{Class.class}, new Object[]{iface});
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getTargetDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getTargetDataSource().getConnection(username, password);
    }

    public Router getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("a router has to be defined");
        }
        return this.delegate;
    }

    private DataSource getTargetDataSource() {
        return this.getDelegate().getDataSource();
    }
}

