/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.cdi.WebsocketSessionManager;

public class WebsocketSessionClusterSerializedRestore
implements Externalizable {
    public static final String WEBSOCKET_SESSION_SERIALIZED_RESTORE = "oam.websocket.SR";
    private String channelToken;
    private boolean deserialized = false;

    public WebsocketSessionClusterSerializedRestore() {
    }

    public WebsocketSessionClusterSerializedRestore(String channelToken) {
        this.channelToken = channelToken;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.channelToken);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.channelToken = in.readUTF();
        this.deserialized = true;
        BeanManager beanManager = CDI.current().getBeanManager();
        WebsocketSessionManager sessionManager = CDIUtils.get(beanManager, WebsocketSessionManager.class);
        sessionManager.getRestoredQueue().add(this.channelToken);
    }

    public String getChannelToken() {
        return this.channelToken;
    }

    public void setChannelToken(String channelToken) {
        this.channelToken = channelToken;
    }

    public boolean isDeserialized() {
        return this.deserialized;
    }
}

