/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class ContainerStoppedEvent
implements HistoryEvent {
    private ContainerId containerId;
    private long stopTime;
    private int exitStatus;
    private ApplicationAttemptId applicationAttemptId;

    public ContainerStoppedEvent() {
    }

    public ContainerStoppedEvent(ContainerId containerId, long stopTime, int exitStatus, ApplicationAttemptId applicationAttemptId) {
        this.containerId = containerId;
        this.stopTime = stopTime;
        this.exitStatus = exitStatus;
        this.applicationAttemptId = applicationAttemptId;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.CONTAINER_STOPPED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.ContainerStoppedProto toProto() {
        return RecoveryProtos.ContainerStoppedProto.newBuilder().setApplicationAttemptId(this.applicationAttemptId.toString()).setContainerId(this.containerId.toString()).setStopTime(this.stopTime).setExitStatus(this.exitStatus).build();
    }

    public void fromProto(RecoveryProtos.ContainerStoppedProto proto) {
        this.containerId = ConverterUtils.toContainerId((String)proto.getContainerId());
        this.stopTime = proto.getStopTime();
        this.exitStatus = proto.getExitStatus();
        this.applicationAttemptId = ConverterUtils.toApplicationAttemptId((String)proto.getApplicationAttemptId());
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.ContainerStoppedProto proto = (RecoveryProtos.ContainerStoppedProto)inputStream.readMessage(RecoveryProtos.ContainerStoppedProto.PARSER, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "containerId=" + this.containerId + ", stoppedTime=" + this.stopTime + ", exitStatus=" + this.exitStatus;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public long getStoppedTime() {
        return this.stopTime;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }
}

