/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.http.BaseHttpConnection;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexDeleteRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(VertexDeleteRunnable.class);
    private final TezVertexID vertex;
    private final JobTokenSecretManager jobTokenSecretManager;
    private final NodeId nodeId;
    private final int shufflePort;
    private final String vertexId;
    private final HttpConnectionParams httpConnectionParams;

    VertexDeleteRunnable(TezVertexID vertex, JobTokenSecretManager jobTokenSecretManager, NodeId nodeId, int shufflePort, String vertexId, HttpConnectionParams httpConnectionParams) {
        this.vertex = vertex;
        this.jobTokenSecretManager = jobTokenSecretManager;
        this.nodeId = nodeId;
        this.shufflePort = shufflePort;
        this.vertexId = vertexId;
        this.httpConnectionParams = httpConnectionParams;
    }

    @Override
    public void run() {
        BaseHttpConnection httpConnection = null;
        try {
            URL baseURL = TezRuntimeUtils.constructBaseURIForShuffleHandlerVertexComplete((String)this.nodeId.getHost(), (int)this.shufflePort, (String)this.vertex.getDAGID().getApplicationId().toString(), (int)this.vertex.getDAGID().getId(), (String)this.vertexId, (boolean)this.httpConnectionParams.isSslShuffle());
            httpConnection = TezRuntimeUtils.getHttpConnection((boolean)true, (URL)baseURL, (HttpConnectionParams)this.httpConnectionParams, (String)"VertexDelete", (JobTokenSecretManager)this.jobTokenSecretManager);
            httpConnection.connect();
            httpConnection.getInputStream();
        }
        catch (Exception e) {
            LOG.warn("Could not setup HTTP Connection to the node %s " + this.nodeId.getHost() + " for vertex shuffle delete. ", (Throwable)e);
        }
        finally {
            try {
                if (httpConnection != null) {
                    httpConnection.cleanup(true);
                }
            }
            catch (IOException e) {
                LOG.warn("Encountered IOException for " + this.nodeId.getHost() + " during close. ", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "VertexDeleteRunnable nodeId=" + this.nodeId + ", shufflePort=" + this.shufflePort + ", vertexId=" + this.vertexId;
    }
}

