/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.util.FSDownload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezLocalCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(TezLocalCacheManager.class);
    private final Map<String, LocalResource> resources;
    private final Configuration conf;
    private final UserGroupInformation ugi;
    private final FileContext fileContext;
    private final java.nio.file.Path tempDir;
    private final Map<LocalResource, ResourceInfo> resourceInfo = new HashMap<LocalResource, ResourceInfo>();

    public TezLocalCacheManager(Map<String, LocalResource> resources, Configuration conf) throws IOException {
        this.ugi = UserGroupInformation.getCurrentUser();
        this.fileContext = FileContext.getLocalFSFileContext();
        this.resources = resources;
        this.conf = conf;
        this.tempDir = Files.createTempDirectory(this.getLocalCacheRoot(), "tez-local-cache", new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localize() throws IOException {
        String absPath = this.getLocalCacheRoot().toAbsolutePath().normalize().toString();
        Path cwd = this.fileContext.makeQualified(new Path(absPath));
        ExecutorService threadPool = null;
        try {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("TezLocalCacheManager Downloader #%d").build();
            threadPool = Executors.newCachedThreadPool(threadFactory);
            for (Map.Entry<String, LocalResource> entry : this.resources.entrySet()) {
                String resourceName = entry.getKey();
                LocalResource resource = entry.getValue();
                if (resource.getType() == LocalResourceType.PATTERN) {
                    throw new IllegalArgumentException("Resource type PATTERN not supported.");
                }
                Path linkPath = new Path(cwd, entry.getKey());
                if (this.resourceInfo.containsKey(resource)) {
                    this.resourceInfo.get(resource).getLinkPaths().add(linkPath);
                    continue;
                }
                java.nio.file.Path fp = Paths.get(resourceName, new String[0]).getFileName();
                String prefix = fp == null ? "" : fp.toString();
                java.nio.file.Path downloadDir = Files.createTempDirectory(this.tempDir, prefix, new FileAttribute[0]);
                Path dest = new Path(downloadDir.toAbsolutePath().toString());
                FSDownload downloader = new FSDownload(this.fileContext, this.ugi, this.conf, dest, resource);
                Future<Path> downloadedPath = threadPool.submit(downloader);
                this.resourceInfo.put(resource, new ResourceInfo(downloadedPath, linkPath));
            }
            for (Map.Entry<String, Object> entry : this.resourceInfo.entrySet()) {
                LocalResource resource = (LocalResource)entry.getKey();
                ResourceInfo resourceMeta = (ResourceInfo)entry.getValue();
                for (Path linkPath : resourceMeta.getLinkPaths()) {
                    Path targetPath;
                    try {
                        targetPath = resourceMeta.getDownloadPath().get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new IOException(e);
                    }
                    if (this.createSymlink(targetPath, linkPath)) {
                        LOG.info("Localized file: {} as {}", (Object)resource, (Object)linkPath);
                        continue;
                    }
                    LOG.warn("Failed to create symlink: {} <- {}", (Object)targetPath, (Object)linkPath);
                }
            }
        }
        finally {
            if (threadPool != null) {
                threadPool.shutdownNow();
            }
        }
    }

    public void cleanup() throws IOException {
        for (ResourceInfo info : this.resourceInfo.values()) {
            for (Path linkPath : info.getLinkPaths()) {
                if (!this.fileContext.util().exists(linkPath)) continue;
                this.fileContext.delete(linkPath, true);
            }
        }
        Path temp = new Path(this.tempDir.toString());
        if (this.fileContext.util().exists(temp)) {
            this.fileContext.delete(temp, true);
        }
    }

    private boolean createSymlink(Path target, Path link) throws IOException {
        LOG.info("Creating symlink: {} <- {}", (Object)target, (Object)link);
        String targetPath = target.toUri().getPath();
        String linkPath = link.toUri().getPath();
        if (this.fileContext.util().exists(link)) {
            LOG.warn("File already exists at symlink path: {}", (Object)link);
            return false;
        }
        try {
            Files.createSymbolicLink(Paths.get(linkPath, new String[0]), Paths.get(targetPath, new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (IOException | UnsupportedOperationException e) {
            LOG.warn("Unable to create symlink {} <- {}: {}", new Object[]{target, link, e});
            return false;
        }
    }

    private java.nio.file.Path getLocalCacheRoot() {
        return Paths.get(this.conf.get("tez.local.cache.root.folder", "."), new String[0]);
    }

    private static class ResourceInfo {
        private final Future<Path> downloadPath;
        private final Set<Path> linkPaths = new HashSet<Path>();

        ResourceInfo(Future<Path> downloadPath, Path linkPath) {
            this.downloadPath = downloadPath;
            this.getLinkPaths().add(linkPath);
        }

        Future<Path> getDownloadPath() {
            return this.downloadPath;
        }

        Set<Path> getLinkPaths() {
            return this.linkPaths;
        }
    }
}

