/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.speculation.legacy.forecast;

import java.util.concurrent.atomic.AtomicReference;

public class SimpleExponentialSmoothing {
    private static final double DEFAULT_FORECAST = -1.0;
    private final int kMinimumReads;
    private final long kStagnatedWindow;
    private final long startTime;
    private long timeConstant;
    private AtomicReference<ForecastRecord> forecastRefEntry;

    public static SimpleExponentialSmoothing createForecast(long timeConstant, int skipCnt, long stagnatedWindow, long timeStamp) {
        return new SimpleExponentialSmoothing(timeConstant, skipCnt, stagnatedWindow, timeStamp);
    }

    SimpleExponentialSmoothing(long ktConstant, int skipCnt, long stagnatedWindow, long timeStamp) {
        this.kMinimumReads = skipCnt;
        this.kStagnatedWindow = stagnatedWindow;
        this.timeConstant = ktConstant;
        this.startTime = timeStamp;
        this.forecastRefEntry = new AtomicReference<Object>(null);
    }

    public boolean isDataStagnated(long timeStamp) {
        ForecastRecord rec = this.forecastRefEntry.get();
        if (rec != null && rec.myIndex > (long)this.kMinimumReads) {
            return rec.timeStamp + this.kStagnatedWindow > timeStamp;
        }
        return false;
    }

    static double processRawData(double oldRawData, long oldTime, double newRawData, long newTime) {
        double rate = (newRawData - oldRawData) / (double)(newTime - oldTime);
        return rate;
    }

    public void incorporateReading(long timeStamp, double currRawData) {
        ForecastRecord oldRec = this.forecastRefEntry.get();
        if (oldRec == null) {
            double oldForecast = SimpleExponentialSmoothing.processRawData(0.0, this.startTime, currRawData, timeStamp);
            this.forecastRefEntry.compareAndSet(null, new ForecastRecord(oldForecast, 0.0, this.startTime));
            this.incorporateReading(timeStamp, currRawData);
            return;
        }
        while (!this.forecastRefEntry.compareAndSet(oldRec, oldRec.append(timeStamp, currRawData))) {
            oldRec = this.forecastRefEntry.get();
        }
    }

    public double getForecast() {
        ForecastRecord rec = this.forecastRefEntry.get();
        if (rec != null && rec.myIndex > (long)this.kMinimumReads) {
            return rec.forecast;
        }
        return -1.0;
    }

    public boolean isDefaultForecast(double value) {
        return value == -1.0;
    }

    public double getSSE() {
        ForecastRecord rec = this.forecastRefEntry.get();
        if (rec != null) {
            return rec.sseError;
        }
        return -1.0;
    }

    public boolean isErrorWithinBound(double bound) {
        double squaredErr = this.getSSE();
        if (squaredErr < 0.0) {
            return false;
        }
        return bound > squaredErr;
    }

    public double getRawData() {
        ForecastRecord rec = this.forecastRefEntry.get();
        if (rec != null) {
            return rec.rawData;
        }
        return -1.0;
    }

    public long getTimeStamp() {
        ForecastRecord rec = this.forecastRefEntry.get();
        if (rec != null) {
            return rec.timeStamp;
        }
        return 0L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public AtomicReference<ForecastRecord> getForecastRefEntry() {
        return this.forecastRefEntry;
    }

    public String toString() {
        String res = "NULL";
        ForecastRecord rec = this.forecastRefEntry.get();
        if (rec != null) {
            StringBuilder strB = new StringBuilder("rec.index = ").append(rec.myIndex).append(", timeStamp t: ").append(rec.timeStamp).append(", forecast: ").append(rec.forecast).append(", sample: ").append(rec.sample).append(", raw: ").append(rec.rawData).append(", error: ").append(rec.sseError).append(", alpha: ").append(rec.alpha);
            res = strB.toString();
        }
        return res;
    }

    private class ForecastRecord {
        private final double alpha;
        private final long timeStamp;
        private final double sample;
        private final double rawData;
        private double forecast;
        private final double sseError;
        private final long myIndex;
        private ForecastRecord prevRec;

        ForecastRecord(double currForecast, double currRawData, long currTimeStamp) {
            this(0.0, currForecast, currRawData, currForecast, currTimeStamp, 0.0, 0L);
        }

        ForecastRecord(double alphaVal, double currSample, double currRawData, double currForecast, long currTimeStamp, double accError, long index) {
            this.timeStamp = currTimeStamp;
            this.alpha = alphaVal;
            this.sample = currSample;
            this.forecast = currForecast;
            this.rawData = currRawData;
            this.sseError = accError;
            this.myIndex = index;
        }

        private ForecastRecord createForecastRecord(double alphaVal, double currSample, double currRawData, double currForecast, long currTimeStamp, double accError, long index, ForecastRecord prev) {
            ForecastRecord forecastRec = new ForecastRecord(alphaVal, currSample, currRawData, currForecast, currTimeStamp, accError, index);
            forecastRec.prevRec = prev;
            return forecastRec;
        }

        private double preProcessRawData(double rData, long newTime) {
            return SimpleExponentialSmoothing.processRawData(this.rawData, this.timeStamp, rData, newTime);
        }

        public ForecastRecord append(long newTimeStamp, double rData) {
            if (this.timeStamp >= newTimeStamp && Double.compare(this.rawData, rData) >= 0) {
                return this;
            }
            ForecastRecord refRecord = this;
            if (newTimeStamp == this.timeStamp && this.prevRec != null) {
                refRecord = this.prevRec;
            }
            double newSample = refRecord.preProcessRawData(rData, newTimeStamp);
            long deltaTime = this.timeStamp - newTimeStamp;
            if (refRecord.myIndex == (long)SimpleExponentialSmoothing.this.kMinimumReads) {
                SimpleExponentialSmoothing.this.timeConstant = Math.max(SimpleExponentialSmoothing.this.timeConstant, newTimeStamp - SimpleExponentialSmoothing.this.startTime);
            }
            double smoothFactor = 1.0 - Math.exp((double)deltaTime / (double)SimpleExponentialSmoothing.this.timeConstant);
            double forecastVal = smoothFactor * newSample + (1.0 - smoothFactor) * refRecord.forecast;
            double newSSEError = refRecord.sseError + Math.pow(newSample - refRecord.forecast, 2.0);
            return refRecord.createForecastRecord(smoothFactor, newSample, rData, forecastVal, newTimeStamp, newSSEError, refRecord.myIndex + 1L, refRecord);
        }
    }
}

