/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.serializer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.tez.runtime.library.common.ConfigUtils;

public class SerializationContext {
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Serialization<?> keySerialization;
    private Serialization<?> valSerialization;

    public SerializationContext(Configuration conf) {
        this.keyClass = ConfigUtils.getIntermediateInputKeyClass(conf);
        this.valueClass = ConfigUtils.getIntermediateInputValueClass(conf);
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        if (this.keyClass != null) {
            this.keySerialization = serializationFactory.getSerialization(this.keyClass);
        }
        if (this.valueClass != null) {
            this.valSerialization = serializationFactory.getSerialization(this.valueClass);
        }
    }

    public SerializationContext(Class<?> keyClass, Class<?> valueClass, Serialization<?> keySerialization, Serialization<?> valSerialization) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.keySerialization = keySerialization;
        this.valSerialization = valSerialization;
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public Serialization<?> getKeySerialization() {
        return this.keySerialization;
    }

    public Serialization<?> getValSerialization() {
        return this.valSerialization;
    }

    public Serializer<?> getKeySerializer() {
        return this.keySerialization.getSerializer(this.keyClass);
    }

    public Serializer<?> getValueSerializer() {
        return this.valSerialization.getSerializer(this.valueClass);
    }

    public void applyToConf(Configuration conf) {
        conf.set("tez.runtime.key.class", this.keyClass.getName());
        conf.set("tez.runtime.value.class", this.valueClass.getName());
    }
}

