/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class SlowTaskIdentifier
extends TezAnalyzerBase
implements Analyzer {
    private static final String[] headers = new String[]{"vertexName", "taskAttemptId", "Node", "taskDuration", "Status", "diagnostics", "NoOfInputs"};
    private final CSVResult csvResult = new CSVResult(headers);
    private static final String NO_OF_TASKS = "tez.slow-task-analyzer.task.count";
    private static final int NO_OF_TASKS_DEFAULT = 100;

    public SlowTaskIdentifier(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        ArrayList taskAttempts = Lists.newArrayList();
        for (VertexInfo vertexInfo : dagInfo.getVertices()) {
            taskAttempts.addAll(vertexInfo.getTaskAttempts());
        }
        Collections.sort(taskAttempts, new Comparator<TaskAttemptInfo>(){

            @Override
            public int compare(TaskAttemptInfo o1, TaskAttemptInfo o2) {
                return o1.getTimeTaken() > o2.getTimeTaken() ? -1 : (o1.getTimeTaken() == o2.getTimeTaken() ? 0 : 1);
            }
        });
        int limit = Math.min(taskAttempts.size(), Math.max(0, this.getConf().getInt(NO_OF_TASKS, 100)));
        if (limit == 0) {
            return;
        }
        for (int i = 0; i < limit - 1; ++i) {
            LinkedList record = Lists.newLinkedList();
            record.add(((TaskAttemptInfo)taskAttempts.get(i)).getTaskInfo().getVertexInfo().getVertexName());
            record.add(((TaskAttemptInfo)taskAttempts.get(i)).getTaskAttemptId());
            record.add(((TaskAttemptInfo)taskAttempts.get(i)).getContainer().getHost());
            record.add(((TaskAttemptInfo)taskAttempts.get(i)).getTimeTaken() + "");
            record.add(((TaskAttemptInfo)taskAttempts.get(i)).getStatus());
            record.add(((TaskAttemptInfo)taskAttempts.get(i)).getDiagnostics());
            record.add(((TaskAttemptInfo)taskAttempts.get(i)).getTaskInfo().getVertexInfo().getInputEdges().size() + "");
            this.csvResult.addRecord(record.toArray(new String[record.size()]));
        }
    }

    @Override
    public CSVResult getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Slow Task Identifier";
    }

    @Override
    public String getDescription() {
        return "Identifies slow tasks in the DAG";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        SlowTaskIdentifier analyzer = new SlowTaskIdentifier(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

