/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.lib.join.CompositeRecordReader;
import org.apache.hadoop.mapreduce.lib.join.ResetableIterator;
import org.apache.hadoop.mapreduce.lib.join.TupleWritable;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class JoinRecordReader<K extends WritableComparable<?>>
extends CompositeRecordReader<K, Writable, TupleWritable> {
    public JoinRecordReader(int id, Configuration conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, capacity, cmpcl);
        this.setConf(conf);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.key == null) {
            this.key = this.createKey();
        }
        if (this.jc.flush((TupleWritable)this.value)) {
            ReflectionUtils.copy((Configuration)this.conf, this.jc.key(), (Object)this.key);
            return true;
        }
        this.jc.clear();
        if (this.value == null) {
            this.value = this.createValue();
        }
        PriorityQueue q = this.getRecordReaderQueue();
        Object iterkey = this.createKey();
        while (q != null && !q.isEmpty()) {
            this.fillJoinCollector(iterkey);
            this.jc.reset(iterkey);
            if (this.jc.flush((TupleWritable)this.value)) {
                ReflectionUtils.copy((Configuration)this.conf, this.jc.key(), (Object)this.key);
                return true;
            }
            this.jc.clear();
        }
        return false;
    }

    @Override
    public TupleWritable createValue() {
        return this.createTupleWritable();
    }

    @Override
    protected ResetableIterator<TupleWritable> getDelegate() {
        return new JoinDelegationIterator();
    }

    protected class JoinDelegationIterator
    implements ResetableIterator<TupleWritable> {
        protected JoinDelegationIterator() {
        }

        @Override
        public boolean hasNext() {
            return JoinRecordReader.this.jc.hasNext();
        }

        @Override
        public boolean next(TupleWritable val) throws IOException {
            return JoinRecordReader.this.jc.flush(val);
        }

        @Override
        public boolean replay(TupleWritable val) throws IOException {
            return JoinRecordReader.this.jc.replay(val);
        }

        @Override
        public void reset() {
            JoinRecordReader.this.jc.reset(JoinRecordReader.this.jc.key());
        }

        @Override
        public void add(TupleWritable item) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            JoinRecordReader.this.jc.close();
        }

        @Override
        public void clear() {
            JoinRecordReader.this.jc.clear();
        }
    }
}

