/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableStat;

@Metrics(about="Metrics for EntityGroupFSTimelineStore", context="yarn")
public class EntityGroupFSTimelineStoreMetrics {
    private static final String DEFAULT_VALUE_WITH_SCALE = "TimeMs";
    @Metric(value={"getEntity calls to summary storage"})
    private MutableCounterLong getEntityToSummaryOps;
    @Metric(value={"getEntity calls to detail storage"})
    private MutableCounterLong getEntityToDetailOps;
    @Metric(value={"summary log read ops and time"}, valueName="TimeMs")
    private MutableStat summaryLogRead;
    @Metric(value={"entities read into the summary storage"})
    private MutableCounterLong entitiesReadToSummary;
    @Metric(value={"cache storage read that does not require a refresh"})
    private MutableCounterLong noRefreshCacheRead;
    @Metric(value={"cache storage refresh due to the cached storage is stale"})
    private MutableCounterLong cacheStaleRefreshes;
    @Metric(value={"cache storage evicts"})
    private MutableCounterLong cacheEvicts;
    @Metric(value={"cache storage refresh ops and time"}, valueName="TimeMs")
    private MutableStat cacheRefresh;
    @Metric(value={"active log scan ops and time"}, valueName="TimeMs")
    private MutableStat activeLogDirScan;
    @Metric(value={"log cleaner purging ops and time"}, valueName="TimeMs")
    private MutableStat logClean;
    @Metric(value={"log cleaner dirs purged"})
    private MutableCounterLong logsDirsCleaned;
    private static EntityGroupFSTimelineStoreMetrics instance = null;

    EntityGroupFSTimelineStoreMetrics() {
    }

    public static synchronized EntityGroupFSTimelineStoreMetrics create() {
        if (instance == null) {
            MetricsSystem ms = DefaultMetricsSystem.instance();
            instance = (EntityGroupFSTimelineStoreMetrics)ms.register((Object)new EntityGroupFSTimelineStoreMetrics());
        }
        return instance;
    }

    public void incrGetEntityToSummaryOps() {
        this.getEntityToSummaryOps.incr();
    }

    public void incrGetEntityToDetailOps() {
        this.getEntityToDetailOps.incr();
    }

    public void addSummaryLogReadTime(long msec) {
        this.summaryLogRead.add(msec);
    }

    public void incrEntitiesReadToSummary(long delta) {
        this.entitiesReadToSummary.incr(delta);
    }

    public void incrNoRefreshCacheRead() {
        this.noRefreshCacheRead.incr();
    }

    public void incrCacheStaleRefreshes() {
        this.cacheStaleRefreshes.incr();
    }

    public void incrCacheEvicts() {
        this.cacheEvicts.incr();
    }

    public void addCacheRefreshTime(long msec) {
        this.cacheRefresh.add(msec);
    }

    public void addActiveLogDirScanTime(long msec) {
        this.activeLogDirScan.add(msec);
    }

    public void addLogCleanTime(long msec) {
        this.logClean.add(msec);
    }

    public void incrLogsDirsCleaned() {
        this.logsDirsCleaned.incr();
    }

    MutableCounterLong getEntitiesReadToSummary() {
        return this.entitiesReadToSummary;
    }

    MutableCounterLong getLogsDirsCleaned() {
        return this.logsDirsCleaned;
    }

    MutableCounterLong getGetEntityToSummaryOps() {
        return this.getEntityToSummaryOps;
    }

    MutableCounterLong getGetEntityToDetailOps() {
        return this.getEntityToDetailOps;
    }

    MutableStat getCacheRefresh() {
        return this.cacheRefresh;
    }
}

