/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.util.StringInterner;

public class GroupInputSpec
implements Writable {
    private String groupName;
    private List<String> groupVertices;
    private InputDescriptor mergedInputDescriptor;

    public GroupInputSpec() {
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<String> getGroupVertices() {
        return this.groupVertices;
    }

    public InputDescriptor getMergedInputDescriptor() {
        return this.mergedInputDescriptor;
    }

    public GroupInputSpec(String groupName, List<String> groupVertices, InputDescriptor inputDescriptor) {
        this.groupName = StringInterner.intern((String)groupName);
        this.groupVertices = groupVertices;
        this.mergedInputDescriptor = inputDescriptor;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.groupName);
        out.writeInt(this.groupVertices.size());
        for (String s : this.groupVertices) {
            Text.writeString((DataOutput)out, (String)s);
        }
        this.mergedInputDescriptor.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.groupName = StringInterner.intern((String)Text.readString((DataInput)in));
        int numMembers = in.readInt();
        this.groupVertices = Lists.newArrayListWithCapacity((int)numMembers);
        for (int i = 0; i < numMembers; ++i) {
            this.groupVertices.add(StringInterner.intern((String)Text.readString((DataInput)in)));
        }
        this.mergedInputDescriptor = new InputDescriptor();
        this.mergedInputDescriptor.readFields(in);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Group: " + this.groupName + " { ");
        for (String s : this.groupVertices) {
            sb.append(s + " ");
        }
        sb.append("} MergedInputDescriptor: " + this.mergedInputDescriptor.getClassName());
        return sb.toString();
    }
}

