/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.util;

import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;

public class ColumnElementsVisitor
implements ColumnVisitor<Void> {
    private final JRVisitor visitor;

    public ColumnElementsVisitor(JRVisitor visitor) {
        this.visitor = visitor;
    }

    @Override
    public Void visitColumn(Column column) {
        this.visitBaseColumn(column);
        this.visitCell(column.getDetailCell());
        return null;
    }

    @Override
    public Void visitColumnGroup(ColumnGroup columnGroup) {
        this.visitBaseColumn(columnGroup);
        List<BaseColumn> subColumns = columnGroup.getColumns();
        if (subColumns != null) {
            for (BaseColumn subColumn : subColumns) {
                subColumn.visitColumn(this);
            }
        }
        return null;
    }

    protected void visitBaseColumn(BaseColumn column) {
        List<GroupCell> groupFooters;
        this.visitCell(column.getTableHeader());
        this.visitCell(column.getTableFooter());
        this.visitCell(column.getColumnHeader());
        this.visitCell(column.getColumnFooter());
        List<GroupCell> groupHeaders = column.getGroupHeaders();
        if (groupHeaders != null) {
            for (GroupCell groupCell : groupHeaders) {
                this.visitCell(groupCell.getCell());
            }
        }
        if ((groupFooters = column.getGroupFooters()) != null) {
            for (GroupCell groupCell : groupFooters) {
                this.visitCell(groupCell.getCell());
            }
        }
    }

    protected void visitCell(Cell cell) {
        if (cell != null) {
            ElementsVisitorUtils.visitElements(this.visitor, cell.getChildren());
        }
    }
}

