/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.shaded.ch.qos.logback.classic.layout;

import org.apache.streampark.shaded.ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import org.apache.streampark.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.streampark.shaded.ch.qos.logback.classic.spi.IThrowableProxy;
import org.apache.streampark.shaded.ch.qos.logback.core.CoreConstants;
import org.apache.streampark.shaded.ch.qos.logback.core.LayoutBase;
import org.apache.streampark.shaded.ch.qos.logback.core.util.CachingDateFormatter;

public class TTLLLayout
extends LayoutBase<ILoggingEvent> {
    CachingDateFormatter cachingDateFormatter = new CachingDateFormatter("HH:mm:ss.SSS");
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();

    @Override
    public void start() {
        this.tpc.start();
        super.start();
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        if (!this.isStarted()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        long timestamp = event.getTimeStamp();
        sb.append(this.cachingDateFormatter.format(timestamp));
        sb.append(" [");
        sb.append(event.getThreadName());
        sb.append("] ");
        sb.append(event.getLevel().toString());
        sb.append(" ");
        sb.append(event.getLoggerName());
        sb.append(" - ");
        sb.append(event.getFormattedMessage());
        sb.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp != null) {
            String stackTrace = this.tpc.convert(event);
            sb.append(stackTrace);
        }
        return sb.toString();
    }
}

