/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.filter;

import com.github.xiaoymin.knife4j.extend.filter.BasicFilter;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityBasicAuthFilter
extends BasicFilter
implements Filter {
    public static final String SwaggerBootstrapUiBasicAuthSession = "SwaggerBootstrapUiBasicAuthSession";
    private boolean enableBasicAuth = false;
    private String userName;
    private String password;

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration enumeration = filterConfig.getInitParameterNames();
        if (enumeration.hasMoreElements()) {
            this.setEnableBasicAuth(Boolean.valueOf(filterConfig.getInitParameter("enableBasicAuth")));
            this.setUserName(filterConfig.getInitParameter("userName"));
            this.setPassword(filterConfig.getInitParameter("password"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (!this.enableBasicAuth) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.match(servletRequest.getRequestURI())) {
            chain.doFilter(request, response);
            return;
        }
        Object swaggerSessionValue = servletRequest.getSession().getAttribute(SwaggerBootstrapUiBasicAuthSession);
        if (swaggerSessionValue != null) {
            chain.doFilter(request, response);
            return;
        }
        String auth = servletRequest.getHeader("Authorization");
        if (auth == null || "".equals(auth)) {
            this.writeForbiddenCode(httpServletResponse);
            return;
        }
        String userAndPass = this.decodeBase64(auth.substring(6));
        String[] upArr = userAndPass.split(":");
        if (upArr.length != 2) {
            this.writeForbiddenCode(httpServletResponse);
            return;
        }
        String iptUser = upArr[0];
        String iptPass = upArr[1];
        if (iptUser.equals(this.userName) && iptPass.equals(this.password)) {
            servletRequest.getSession().setAttribute(SwaggerBootstrapUiBasicAuthSession, (Object)this.userName);
            chain.doFilter(request, response);
            return;
        }
        this.writeForbiddenCode(httpServletResponse);
    }

    public void destroy() {
    }

    private void writeForbiddenCode(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"input Swagger Basic userName & password \"");
        httpServletResponse.getWriter().write("You do not have permission to access this resource");
    }

    public SecurityBasicAuthFilter(boolean enableBasicAuth, String userName, String password) {
        this.enableBasicAuth = enableBasicAuth;
        this.userName = userName;
        this.password = password;
    }

    public SecurityBasicAuthFilter(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public SecurityBasicAuthFilter() {
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

