/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.mongodb.DefaultMongoCommandTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.DefaultMongoConnectionPoolTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.MongoCommandTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.MongoConnectionPoolTagsProvider;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsCommandListener;
import io.micrometer.core.instrument.binder.mongodb.MongoMetricsConnectionPoolListener;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={MongoAutoConfiguration.class}, after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={MongoClientSettings.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class MongoMetricsAutoConfiguration {

    @ConditionalOnClass(value={MongoMetricsConnectionPoolListener.class})
    @ConditionalOnProperty(name={"management.metrics.mongo.connectionpool.enabled"}, havingValue="true", matchIfMissing=true)
    static class MongoConnectionPoolMetricsConfiguration {
        MongoConnectionPoolMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MongoMetricsConnectionPoolListener mongoMetricsConnectionPoolListener(MeterRegistry meterRegistry, MongoConnectionPoolTagsProvider mongoConnectionPoolTagsProvider) {
            return new MongoMetricsConnectionPoolListener(meterRegistry, mongoConnectionPoolTagsProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        MongoConnectionPoolTagsProvider mongoConnectionPoolTagsProvider() {
            return new DefaultMongoConnectionPoolTagsProvider();
        }

        @Bean
        MongoClientSettingsBuilderCustomizer mongoMetricsConnectionPoolListenerClientSettingsBuilderCustomizer(MongoMetricsConnectionPoolListener mongoMetricsConnectionPoolListener) {
            return clientSettingsBuilder -> clientSettingsBuilder.applyToConnectionPoolSettings(connectionPoolSettingsBuilder -> connectionPoolSettingsBuilder.addConnectionPoolListener((ConnectionPoolListener)mongoMetricsConnectionPoolListener));
        }
    }

    @ConditionalOnClass(value={MongoMetricsCommandListener.class})
    @ConditionalOnProperty(name={"management.metrics.mongo.command.enabled"}, havingValue="true", matchIfMissing=true)
    static class MongoCommandMetricsConfiguration {
        MongoCommandMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        MongoMetricsCommandListener mongoMetricsCommandListener(MeterRegistry meterRegistry, MongoCommandTagsProvider mongoCommandTagsProvider) {
            return new MongoMetricsCommandListener(meterRegistry, mongoCommandTagsProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        MongoCommandTagsProvider mongoCommandTagsProvider() {
            return new DefaultMongoCommandTagsProvider();
        }

        @Bean
        MongoClientSettingsBuilderCustomizer mongoMetricsCommandListenerClientSettingsBuilderCustomizer(MongoMetricsCommandListener mongoMetricsCommandListener) {
            return clientSettingsBuilder -> clientSettingsBuilder.addCommandListener((CommandListener)mongoMetricsCommandListener);
        }
    }
}

