% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/column.R, R/functions.R
\name{not}
\alias{not}
\alias{!,Column-method}
\alias{not,Column-method}
\title{!}
\usage{
not(x)

\S4method{!}{Column}(x)

\S4method{not}{Column}(x)
}
\arguments{
\item{x}{Column to compute on}
}
\description{
Inversion of boolean expression.

Inversion of boolean expression.
}
\details{
\code{not} and \code{!} cannot be applied directly to numerical column.
To achieve R-like truthiness column has to be casted to \code{BooleanType}.
}
\note{
! since 2.3.0

not since 2.3.0
}
\examples{
\dontrun{
df <- createDataFrame(data.frame(x = c(-1, 0, 1)))

head(select(df, !column("x") > 0))
}
\dontrun{
df <- createDataFrame(data.frame(
  is_true = c(TRUE, FALSE, NA),
  flag = c(1, 0,  1)
))

head(select(df, not(df$is_true)))

# Explicit cast is required when working with numeric column
head(select(df, not(cast(df$flag, "boolean"))))
}
}
\seealso{
Other non-aggregate functions: 
\code{\link{column_nonaggregate_functions}},
\code{\link{column}()}
}
\concept{non-aggregate functions}
