/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.sql.catalyst.util.SQLOrderingUtil$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.math.Fractional;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class FloatExactNumeric$
implements Numeric.FloatIsFractional {
    public static final FloatExactNumeric$ MODULE$ = new FloatExactNumeric$();
    private static final int intUpperBound;
    private static final int intLowerBound;
    private static final long longUpperBound;
    private static final long longLowerBound;

    static {
        PartialOrdering.$init$((PartialOrdering)MODULE$);
        Ordering.$init$((Ordering)MODULE$);
        Numeric.$init$((Numeric)MODULE$);
        Fractional.$init$((Fractional)MODULE$);
        Numeric.FloatIsFractional.$init$((Numeric.FloatIsFractional)MODULE$);
        intUpperBound = Integer.MAX_VALUE;
        intLowerBound = Integer.MIN_VALUE;
        longUpperBound = Long.MAX_VALUE;
        longLowerBound = Long.MIN_VALUE;
    }

    public float plus(float x, float y) {
        return Numeric.FloatIsFractional.plus$((Numeric.FloatIsFractional)this, (float)x, (float)y);
    }

    public float minus(float x, float y) {
        return Numeric.FloatIsFractional.minus$((Numeric.FloatIsFractional)this, (float)x, (float)y);
    }

    public float times(float x, float y) {
        return Numeric.FloatIsFractional.times$((Numeric.FloatIsFractional)this, (float)x, (float)y);
    }

    public float negate(float x) {
        return Numeric.FloatIsFractional.negate$((Numeric.FloatIsFractional)this, (float)x);
    }

    public float fromInt(int x) {
        return Numeric.FloatIsFractional.fromInt$((Numeric.FloatIsFractional)this, (int)x);
    }

    public Option<Object> parseString(String str) {
        return Numeric.FloatIsFractional.parseString$((Numeric.FloatIsFractional)this, (String)str);
    }

    public float toFloat(float x) {
        return Numeric.FloatIsFractional.toFloat$((Numeric.FloatIsFractional)this, (float)x);
    }

    public double toDouble(float x) {
        return Numeric.FloatIsFractional.toDouble$((Numeric.FloatIsFractional)this, (float)x);
    }

    public float div(float x, float y) {
        return Numeric.FloatIsFractional.div$((Numeric.FloatIsFractional)this, (float)x, (float)y);
    }

    public float abs(float x) {
        return Numeric.FloatIsFractional.abs$((Numeric.FloatIsFractional)this, (float)x);
    }

    public float sign(float x) {
        return Numeric.FloatIsFractional.sign$((Numeric.FloatIsFractional)this, (float)x);
    }

    public Fractional.FractionalOps mkNumericOps(Object lhs) {
        return Fractional.mkNumericOps$((Fractional)this, (Object)lhs);
    }

    public Object zero() {
        return Numeric.zero$((Numeric)this);
    }

    public Object one() {
        return Numeric.one$((Numeric)this);
    }

    public int signum(Object x) {
        return Numeric.signum$((Numeric)this, (Object)x);
    }

    public Some tryCompare(Object x, Object y) {
        return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lteq(Object x, Object y) {
        return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gteq(Object x, Object y) {
        return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lt(Object x, Object y) {
        return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
    }

    public boolean equiv(Object x, Object y) {
        return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
    }

    public Object max(Object x, Object y) {
        return Ordering.max$((Ordering)this, (Object)x, (Object)y);
    }

    public Object min(Object x, Object y) {
        return Ordering.min$((Ordering)this, (Object)x, (Object)y);
    }

    public Ordering<Object> reverse() {
        return Ordering.reverse$((Ordering)this);
    }

    public boolean isReverseOf(Ordering<?> other) {
        return Ordering.isReverseOf$((Ordering)this, other);
    }

    public <U> Ordering<U> on(Function1<U, Object> f) {
        return Ordering.on$((Ordering)this, f);
    }

    public Ordering<Object> orElse(Ordering<Object> other) {
        return Ordering.orElse$((Ordering)this, other);
    }

    public <S> Ordering<Object> orElseBy(Function1<Object, S> f, Ordering<S> ord) {
        return Ordering.orElseBy$((Ordering)this, f, ord);
    }

    public Ordering.OrderingOps mkOrderingOps(Object lhs) {
        return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
    }

    private int intUpperBound() {
        return intUpperBound;
    }

    private int intLowerBound() {
        return intLowerBound;
    }

    private long longUpperBound() {
        return longUpperBound;
    }

    private long longLowerBound() {
        return longLowerBound;
    }

    public int toInt(float x) {
        if (Math.floor(x) <= (double)this.intUpperBound() && Math.ceil(x) >= (double)this.intLowerBound()) {
            return (int)x;
        }
        throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToFloat((float)x), (DataType)FloatType$.MODULE$, (DataType)IntegerType$.MODULE$);
    }

    public long toLong(float x) {
        if (Math.floor(x) <= (double)this.longUpperBound() && Math.ceil(x) >= (double)this.longLowerBound()) {
            return (long)x;
        }
        throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToFloat((float)x), (DataType)FloatType$.MODULE$, (DataType)LongType$.MODULE$);
    }

    public int compare(float x, float y) {
        return SQLOrderingUtil$.MODULE$.compareFloats(x, y);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FloatExactNumeric$.class);
    }

    private FloatExactNumeric$() {
    }
}

