/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.Correlations;
import org.apache.spark.examples.mllib.Correlations$Params$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class Correlations$ {
    public static final Correlations$ MODULE$ = new Correlations$();

    public void main(String[] args) {
        Correlations.Params defaultParams = new Correlations.Params(Correlations$Params$.MODULE$.apply$default$1());
        OptionParser<Correlations.Params> parser = new OptionParser<Correlations.Params>(defaultParams){
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Correlations: an example app for computing correlations"}));
                this.opt("input", Read$.MODULE$.stringRead()).text("Input path to labeled examples in LIBSVM format, default: " + defaultParams$1.input()).action((Function2 & Serializable)(x, c) -> c.copy((String)x));
                this.note(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |For example, the following command runs this app on a synthetic dataset:\n        |\n        | bin/spark-submit --class org.apache.spark.examples.mllib.Correlations \\\n        |  examples/target/scala-*/spark-examples-*.jar \\\n        |  --input data/mllib/sample_linear_regression_data.txt\n        ")));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.Correlations$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            Correlations.Params params = (Correlations.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(Correlations.Params params) {
        SparkConf conf = new SparkConf().setAppName("Correlations with " + params);
        SparkContext sc = new SparkContext(conf);
        RDD examples = MLUtils$.MODULE$.loadLibSVMFile(sc, params.input()).cache();
        Predef$.MODULE$.println((Object)("Summary of data file: " + params.input()));
        Predef$.MODULE$.println((Object)(examples.count() + " data points"));
        RDD labelRDD = examples.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.label()), (ClassTag)ClassTag$.MODULE$.Double());
        int numFeatures = ((LabeledPoint[])examples.take(1))[0].features().size();
        String corrType = "pearson";
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)("Correlation (" + corrType + ") between label and each feature"));
        Predef$.MODULE$.println((Object)"Feature\tCorrelation");
        IntRef feature = IntRef.create((int)0);
        while (feature.elem < numFeatures) {
            RDD featureRDD = examples.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)Correlations$.$anonfun$run$2(feature, x$2)), (ClassTag)ClassTag$.MODULE$.Double());
            double corr = Statistics$.MODULE$.corr(labelRDD, featureRDD);
            Predef$.MODULE$.println((Object)(feature.elem + "\t" + corr));
            ++feature.elem;
        }
        Predef$.MODULE$.println();
        sc.stop();
    }

    public static final /* synthetic */ double $anonfun$run$2(IntRef feature$1, LabeledPoint x$2) {
        return x$2.features().apply(feature$1.elem);
    }

    private Correlations$() {
    }
}

