/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.credentials;

import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.core.Authentication$;
import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials$;
import coursierapi.shaded.coursier.credentials.Password;
import coursierapi.shaded.coursier.credentials.Password$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.Try$;
import java.io.Serializable;
import java.net.URI;

public final class DirectCredentials
extends Credentials
implements Product {
    private final String host;
    private final Option<String> usernameOpt;
    private final Option<Password<String>> passwordOpt;
    private final Option<String> realm;
    private final boolean optional;
    private final boolean matchHost;
    private final boolean httpsOnly;
    private final boolean passOnRedirect;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public String host() {
        return this.host;
    }

    public Option<String> usernameOpt() {
        return this.usernameOpt;
    }

    public Option<Password<String>> passwordOpt() {
        return this.passwordOpt;
    }

    public Option<String> realm() {
        return this.realm;
    }

    public boolean optional() {
        return this.optional;
    }

    public boolean matchHost() {
        return this.matchHost;
    }

    public boolean httpsOnly() {
        return this.httpsOnly;
    }

    public boolean passOnRedirect() {
        return this.passOnRedirect;
    }

    public DirectCredentials withUsername(String username) {
        return this.withUsernameOpt(new Some<String>(username));
    }

    public DirectCredentials withPassword(String password) {
        return this.withPasswordOpt(new Some<Password<String>>(Password$.MODULE$.apply(password)));
    }

    public DirectCredentials withRealm(String realm2) {
        return this.withRealm(Option$.MODULE$.apply(realm2));
    }

    private boolean nonEmpty() {
        return this.usernameOpt().nonEmpty() && this.passwordOpt().nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean autoMatches(String url, Option<String> realm0) {
        if (!this.nonEmpty()) return false;
        if (!this.matchHost()) return false;
        Option uriOpt = Try$.MODULE$.apply((Function0<URI> & Serializable)() -> new URI(url)).toOption();
        Option schemeOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getScheme()));
        Option hostOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getHost()));
        if (!schemeOpt.contains("http") || this.httpsOnly()) {
            if (!schemeOpt.contains("https")) return false;
        }
        if (!hostOpt.contains(this.host())) return false;
        if (!this.realm().forall((Function1<String, Object>)(Function1<Object, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(realm0.contains(elem)))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String url, String user) {
        if (!this.nonEmpty()) return false;
        Option uriOpt = Try$.MODULE$.apply((Function0<URI> & Serializable)() -> new URI(url)).toOption();
        Option schemeOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getScheme()));
        Option hostOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getHost()));
        Option userInfoOpt = uriOpt.flatMap((Function1<URI, Option> & Serializable)uri -> Option$.MODULE$.apply(uri.getUserInfo()));
        if (!userInfoOpt.isEmpty()) return false;
        if (!schemeOpt.contains("http") || this.httpsOnly()) {
            if (!schemeOpt.contains("https")) return false;
        }
        if (!hostOpt.contains(this.host())) return false;
        if (!this.usernameOpt().contains(user)) return false;
        return true;
    }

    public Authentication authentication() {
        String x$12 = (String)this.usernameOpt().getOrElse((Function0<String> & Serializable)() -> "");
        Option<String> x$2 = this.passwordOpt().map((Function1<Password, String> & Serializable)x$1 -> (String)x$1.value());
        Option<String> x$3 = this.realm();
        boolean x$4 = this.optional();
        boolean x$5 = this.httpsOnly();
        boolean x$6 = this.passOnRedirect();
        return Authentication$.MODULE$.apply(x$12, x$2, x$4, x$3, x$5, x$6);
    }

    @Override
    public Seq<DirectCredentials> get() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DirectCredentials[]{this}));
    }

    public DirectCredentials withHost(String host) {
        return new DirectCredentials(host, this.usernameOpt(), this.passwordOpt(), this.realm(), this.optional(), this.matchHost(), this.httpsOnly(), this.passOnRedirect());
    }

    public DirectCredentials withUsernameOpt(Option<String> usernameOpt) {
        return new DirectCredentials(this.host(), usernameOpt, this.passwordOpt(), this.realm(), this.optional(), this.matchHost(), this.httpsOnly(), this.passOnRedirect());
    }

    public DirectCredentials withPasswordOpt(Option<Password<String>> passwordOpt) {
        return new DirectCredentials(this.host(), this.usernameOpt(), passwordOpt, this.realm(), this.optional(), this.matchHost(), this.httpsOnly(), this.passOnRedirect());
    }

    public DirectCredentials withRealm(Option<String> realm2) {
        return new DirectCredentials(this.host(), this.usernameOpt(), this.passwordOpt(), realm2, this.optional(), this.matchHost(), this.httpsOnly(), this.passOnRedirect());
    }

    public DirectCredentials withOptional(boolean optional) {
        return new DirectCredentials(this.host(), this.usernameOpt(), this.passwordOpt(), this.realm(), optional, this.matchHost(), this.httpsOnly(), this.passOnRedirect());
    }

    public DirectCredentials withMatchHost(boolean matchHost) {
        return new DirectCredentials(this.host(), this.usernameOpt(), this.passwordOpt(), this.realm(), this.optional(), matchHost, this.httpsOnly(), this.passOnRedirect());
    }

    public DirectCredentials withHttpsOnly(boolean httpsOnly) {
        return new DirectCredentials(this.host(), this.usernameOpt(), this.passwordOpt(), this.realm(), this.optional(), this.matchHost(), httpsOnly, this.passOnRedirect());
    }

    public DirectCredentials withPassOnRedirect(boolean passOnRedirect) {
        return new DirectCredentials(this.host(), this.usernameOpt(), this.passwordOpt(), this.realm(), this.optional(), this.matchHost(), this.httpsOnly(), passOnRedirect);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("DirectCredentials(");
        b.append(String.valueOf(this.host()));
        b.append(", ");
        b.append(String.valueOf(this.usernameOpt()));
        b.append(", ");
        b.append(String.valueOf(this.passwordOpt()));
        b.append(", ");
        b.append(String.valueOf(this.realm()));
        b.append(", ");
        b.append(String.valueOf(this.optional()));
        b.append(", ");
        b.append(String.valueOf(this.matchHost()));
        b.append(", ");
        b.append(String.valueOf(this.httpsOnly()));
        b.append(", ");
        b.append(String.valueOf(this.passOnRedirect()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof DirectCredentials && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        DirectCredentials other = (DirectCredentials)obj;
        if (!true) return false;
        String string = this.host();
        String string2 = other.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.usernameOpt();
        Option<String> option2 = other.usernameOpt();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Password<String>> option3 = this.passwordOpt();
        Option<Password<String>> option4 = other.passwordOpt();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<String> option5 = this.realm();
        Option<String> option6 = other.realm();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (this.optional() != other.optional()) return false;
        if (this.matchHost() != other.matchHost()) return false;
        if (this.httpsOnly() != other.httpsOnly()) return false;
        if (this.passOnRedirect() != other.passOnRedirect()) return false;
        return true;
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("DirectCredentials");
        code = 37 * code + Statics.anyHash(this.host());
        code = 37 * code + Statics.anyHash(this.usernameOpt());
        code = 37 * code + Statics.anyHash(this.passwordOpt());
        code = 37 * code + Statics.anyHash(this.realm());
        code = 37 * code + (this.optional() ? 1231 : 1237);
        code = 37 * code + (this.matchHost() ? 1231 : 1237);
        code = 37 * code + (this.httpsOnly() ? 1231 : 1237);
        code = 37 * code + (this.passOnRedirect() ? 1231 : 1237);
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "DirectCredentials";
    }

    @Override
    public int productArity() {
        return 8;
    }

    @Override
    public Object productElement(int n) {
        Serializable serializable;
        int n2 = n;
        switch (n2) {
            case 0: {
                serializable = this.host();
                break;
            }
            case 1: {
                serializable = this.usernameOpt();
                break;
            }
            case 2: {
                serializable = this.passwordOpt();
                break;
            }
            case 3: {
                serializable = this.realm();
                break;
            }
            case 4: {
                serializable = BoxesRunTime.boxToBoolean(this.optional());
                break;
            }
            case 5: {
                serializable = BoxesRunTime.boxToBoolean(this.matchHost());
                break;
            }
            case 6: {
                serializable = BoxesRunTime.boxToBoolean(this.httpsOnly());
                break;
            }
            case 7: {
                serializable = BoxesRunTime.boxToBoolean(this.passOnRedirect());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return serializable;
    }

    public DirectCredentials(String host, Option<String> usernameOpt, Option<Password<String>> passwordOpt, Option<String> realm2, boolean optional, boolean matchHost, boolean httpsOnly, boolean passOnRedirect) {
        this.host = host;
        this.usernameOpt = usernameOpt;
        this.passwordOpt = passwordOpt;
        this.realm = realm2;
        this.optional = optional;
        this.matchHost = matchHost;
        this.httpsOnly = httpsOnly;
        this.passOnRedirect = passOnRedirect;
        Product.$init$(this);
    }

    public DirectCredentials() {
        this("", None$.MODULE$, None$.MODULE$, None$.MODULE$, true, DirectCredentials$.MODULE$.defaultMatchHost(), DirectCredentials$.MODULE$.defaultHttpsOnly(), false);
    }
}

