/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.visitors;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.jpmml.agent.InstrumentationProvider;
import org.sparkproject.jpmml.model.ReflectionUtil;
import org.sparkproject.jpmml.model.visitors.AbstractVisitor;
import org.sparkproject.jpmml.model.visitors.Resettable;

public class MemoryMeasurer
extends AbstractVisitor
implements Resettable {
    private Instrumentation instrumentation = InstrumentationProvider.getInstrumentation();
    private long size = 0L;
    private Set<Object> objects = Collections.newSetFromMap(new IdentityHashMap());

    @Override
    public void reset() {
        this.size = 0L;
        this.objects.clear();
    }

    @Override
    public VisitorAction visit(PMMLObject object) {
        this.measure(object);
        return super.visit(object);
    }

    public long getSize() {
        return this.size;
    }

    public Set<Object> getObjects() {
        return this.objects;
    }

    private void measure(Object object) {
        boolean status = this.objects.add(object);
        if (!status) {
            return;
        }
        this.size += this.instrumentation.getObjectSize(object);
        Class<?> clazz = object.getClass();
        if (ReflectionUtil.isPrimitiveWrapper(clazz)) {
            return;
        }
        List<Field> fields = ReflectionUtil.getFields(clazz);
        for (Field field : fields) {
            Object value;
            Class<?> type = field.getType();
            if (type.isPrimitive() || !MemoryMeasurer.shouldMeasure(value = ReflectionUtil.getFieldValue(field, object))) continue;
            this.measure(value);
        }
        if (object instanceof Object[]) {
            Object[] values = (Object[])object;
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (!MemoryMeasurer.shouldMeasure(value)) continue;
                this.measure(value);
            }
        }
    }

    private static boolean shouldMeasure(Object object) {
        if (object != null) {
            if (object instanceof Enum) {
                return false;
            }
            return !(object instanceof PMMLObject);
        }
        return false;
    }
}

