/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.DiskBlockManager$;
import org.apache.spark.storage.ShuffleMergedDataBlockId;
import org.apache.spark.storage.ShuffleMergedIndexBlockId;
import org.apache.spark.storage.ShuffleMergedMetaBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg!\u0002\u00192\u0001MJ\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00111\u0003!\u00111A\u0005\u00025C\u0001\"\u0015\u0001\u0003\u0002\u0004%\tA\u0015\u0005\t1\u0002\u0011\t\u0011)Q\u0005\u001d\"A\u0011\f\u0001B\u0001B\u0003%a\nC\u0003[\u0001\u0011\u00051\f\u0003\u0005b\u0001\t\u0007I\u0011A\u001ac\u0011\u00191\u0007\u0001)A\u0005G\"Aq\r\u0001b\u0001\n\u0003\u0019\u0004\u000e\u0003\u0004u\u0001\u0001\u0006I!\u001b\u0005\tk\u0002\u0011\r\u0011\"\u00014m\"9\u0011q\u0001\u0001!\u0002\u00139\b\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\ty\u0001\u0001Q\u0001\n\u00055\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\ty\u0002\u0001Q\u0001\n\u0005U\u0001\"CA\u0011\u0001\t\u0007I\u0011BA\u0012\u0011\u001d\t)\u0003\u0001Q\u0001\niB\u0001\"a\n\u0001\u0005\u0004%I!\u0014\u0005\b\u0003S\u0001\u0001\u0015!\u0003O\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\u000b\u0001\t\u0003\t\u0019\u0004C\u0004\u0002@\u0001!\t!!\u0011\t\u000f\u0005}\u0002\u0001\"\u0003\u0002P!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\t\u0019\f\u0001C\u0001\u0003kCq!a.\u0001\t\u0013\tI\f\u0003\u0005\u0002<\u0002!\taMAU\u0011\u001d\ti\f\u0001C\u0005\u0003S;\u0001\"a02\u0011\u0003\u0019\u0014\u0011\u0019\u0004\baEB\taMAb\u0011\u0019Q\u0006\u0006\"\u0001\u0002F\"I\u0011q\u0019\u0015C\u0002\u0013\u0005\u00111\u0003\u0005\t\u0003\u0013D\u0003\u0015!\u0003\u0002\u0016!I\u00111\u001a\u0015C\u0002\u0013\u0005\u00111\u0003\u0005\t\u0003\u001bD\u0003\u0015!\u0003\u0002\u0016!I\u0011q\u001a\u0015C\u0002\u0013\u0005\u00111\u0003\u0005\t\u0003#D\u0003\u0015!\u0003\u0002\u0016\t\u0001B)[:l\u00052|7m['b]\u0006<WM\u001d\u0006\u0003eM\nqa\u001d;pe\u0006<WM\u0003\u00025k\u0005)1\u000f]1sW*\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h'\r\u0001!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u001b\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0015\u0013%a\u0002'pO\u001eLgnZ\u0001\u0005G>tgm\u0001\u0001\u0011\u0005%SU\"A\u001a\n\u0005-\u001b$!C*qCJ\\7i\u001c8g\u0003E!W\r\\3uK\u001aKG.Z:P]N#x\u000e]\u000b\u0002\u001dB\u00111hT\u0005\u0003!r\u0012qAQ8pY\u0016\fg.A\u000beK2,G/\u001a$jY\u0016\u001cxJ\\*u_B|F%Z9\u0015\u0005M3\u0006CA\u001eU\u0013\t)FH\u0001\u0003V]&$\bbB,\u0004\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0014A\u00053fY\u0016$XMR5mKN|en\u0015;pa\u0002\n\u0001\"[:Ee&4XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqsv\f\u0019\t\u0003;\u0002i\u0011!\r\u0005\u0006\r\u001a\u0001\r\u0001\u0013\u0005\u0006\u0019\u001a\u0001\rA\u0014\u0005\u00063\u001a\u0001\rAT\u0001\u0013gV\u0014G)\u001b:t!\u0016\u0014Hj\\2bY\u0012K'/F\u0001d!\tYD-\u0003\u0002fy\t\u0019\u0011J\u001c;\u0002'M,(\rR5sgB+'\u000fT8dC2$\u0015N\u001d\u0011\u0002\u00131|7-\u00197ESJ\u001cX#A5\u0011\u0007mRG.\u0003\u0002ly\t)\u0011I\u001d:bsB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\u0003S>T\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u0002t]\n!a)\u001b7f\u0003)awnY1m\t&\u00148\u000fI\u0001\u0010Y>\u001c\u0017\r\u001c#jeN\u001cFO]5oOV\tq\u000fE\u0002<Ub\u00042!_A\u0001\u001d\tQh\u0010\u0005\u0002|y5\tAP\u0003\u0002~\u000f\u00061AH]8pizJ!a \u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\tyH(\u0001\tm_\u000e\fG\u000eR5sgN#(/\u001b8hA\u000591/\u001e2ESJ\u001cXCAA\u0007!\rY$.[\u0001\tgV\u0014G)\u001b:tA\u0005aQ.\u001a:hK\u0012K'OT1nKV\u0011\u0011Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u00049\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\tI\"A\u0007nKJ<W\rR5s\u001d\u0006lW\rI\u0001\rg\",H\u000fZ8x]\"{wn[\u000b\u0002u\u0005i1\u000f[;uI><h\u000eS8pW\u0002\n!\u0004]3s[&\u001c8/[8o\u0007\"\fgnZ5oOJ+\u0017/^5sK\u0012\f1\u0004]3s[&\u001c8/[8o\u0007\"\fgnZ5oOJ+\u0017/^5sK\u0012\u0004\u0013aB4fi\u001aKG.\u001a\u000b\u0004Y\u0006=\u0002BBA\u0019+\u0001\u0007\u00010\u0001\u0005gS2,g.Y7f)\ra\u0017Q\u0007\u0005\b\u0003o1\u0002\u0019AA\u001d\u0003\u001d\u0011Gn\\2l\u0013\u0012\u00042!XA\u001e\u0013\r\ti$\r\u0002\b\u00052|7m[%e\u0003Q9W\r^'fe\u001e,Gm\u00155vM\u001adWMR5mKR)A.a\u0011\u0002F!9\u0011qG\fA\u0002\u0005e\u0002bBA$/\u0001\u0007\u0011\u0011J\u0001\u0005I&\u00148\u000f\u0005\u0003<\u0003\u0017:\u0018bAA'y\t1q\n\u001d;j_:$R\u0001\\A)\u0003'Ba!!\r\u0019\u0001\u0004A\bbBA$1\u0001\u0007\u0011\u0011J\u0001\u000eG>tG/Y5og\ncwnY6\u0015\u00079\u000bI\u0006C\u0004\u00028e\u0001\r!!\u000f\u0002\u0017\u001d,G/\u00117m\r&dWm\u001d\u000b\u0003\u0003?\u0002R!!\u0019\u0002l1tA!a\u0019\u0002h9\u001910!\u001a\n\u0003uJ1!!\u001b=\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001c\u0002p\t\u00191+Z9\u000b\u0007\u0005%D(\u0001\u0007hKR\fE\u000e\u001c\"m_\u000e\\7\u000f\u0006\u0002\u0002vA1\u0011\u0011MA6\u0003s\tqc\u0019:fCR,wk\u001c:mIJ+\u0017\rZ1cY\u00164\u0015\u000e\\3\u0015\u0007M\u000bY\b\u0003\u0004\u0002~q\u0001\r\u0001\\\u0001\u0005M&dW-\u0001\nde\u0016\fG/\u001a+f[B4\u0015\u000e\\3XSRDGc\u00017\u0002\u0004\"1\u0011QP\u000fA\u00021\fAc\u0019:fCR,G+Z7q\u0019>\u001c\u0017\r\u001c\"m_\u000e\\GCAAE!\u0019Y\u00141RAHY&\u0019\u0011Q\u0012\u001f\u0003\rQ+\b\u000f\\33!\ri\u0016\u0011S\u0005\u0004\u0003'\u000b$\u0001\u0005+f[BdunY1m\u00052|7m[%e\u0003Y\u0019'/Z1uKR+W\u000e]*ik\u001a4G.\u001a\"m_\u000e\\GCAAM!\u0019Y\u00141RANYB\u0019Q,!(\n\u0007\u0005}\u0015G\u0001\nUK6\u00048\u000b[;gM2,'\t\\8dW&#\u0017aD2sK\u0006$X\rT8dC2$\u0015N]:\u0015\u0007%\f)\u000bC\u0003GA\u0001\u0007\u0001*A\u0013de\u0016\fG/\u001a'pG\u0006dG)\u001b:t\r>\u0014X*\u001a:hK\u0012\u001c\u0006.\u001e4gY\u0016\u0014En\\2lgR\t1+\u0001\u000ede\u0016\fG/\u001a#je^KG\u000f\u001b)fe6L7o]5p]^:\u0004\u0007F\u0002T\u0003_Ca!!-#\u0001\u0004a\u0017a\u00033jeR{7I]3bi\u0016\fqeZ3u\u001b\u0016\u0014x-\u001a#je\u0016\u001cGo\u001c:z\u0003:$\u0017\t\u001e;f[B$\u0018\n\u0012&t_:\u001cFO]5oOR\t\u00010A\bbI\u0012\u001c\u0006.\u001e;e_^t\u0007j\\8l)\u0005Q\u0014\u0001B:u_B\fa\u0001Z8Ti>\u0004\u0018\u0001\u0005#jg.\u0014En\\2l\u001b\u0006t\u0017mZ3s!\ti\u0006f\u0005\u0002)uQ\u0011\u0011\u0011Y\u0001\u0010\u001b\u0016\u0013v)R0E\u0013J+5\tV(S3\u0006\u0001R*\u0012*H\u000b~#\u0015JU#D)>\u0013\u0016\fI\u0001\u000e\u001b\u0016\u0013v)R0E\u0013J{6*R-\u0002\u001d5+%kR#`\t&\u0013vlS#ZA\u0005q\u0011\t\u0016+F\u001bB#v,\u0013#`\u0017\u0016K\u0016aD!U)\u0016k\u0005\u000bV0J\t~[U)\u0017\u0011")
public class DiskBlockManager
implements Logging {
    private final SparkConf conf;
    private boolean deleteFilesOnStop;
    private final boolean isDriver;
    private final int subDirsPerLocalDir;
    private final File[] localDirs;
    private final String[] localDirsString;
    private final File[][] subDirs;
    private final String mergeDirName;
    private final Object shutdownHook;
    private final boolean permissionChangingRequired;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String ATTEMPT_ID_KEY() {
        return DiskBlockManager$.MODULE$.ATTEMPT_ID_KEY();
    }

    public static String MERGE_DIR_KEY() {
        return DiskBlockManager$.MODULE$.MERGE_DIR_KEY();
    }

    public static String MERGE_DIRECTORY() {
        return DiskBlockManager$.MODULE$.MERGE_DIRECTORY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean deleteFilesOnStop() {
        return this.deleteFilesOnStop;
    }

    public void deleteFilesOnStop_$eq(boolean x$1) {
        this.deleteFilesOnStop = x$1;
    }

    public int subDirsPerLocalDir() {
        return this.subDirsPerLocalDir;
    }

    public File[] localDirs() {
        return this.localDirs;
    }

    public String[] localDirsString() {
        return this.localDirsString;
    }

    private File[][] subDirs() {
        return this.subDirs;
    }

    private String mergeDirName() {
        return this.mergeDirName;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    private boolean permissionChangingRequired() {
        return this.permissionChangingRequired;
    }

    public File getFile(String filename) {
        File file;
        int hash = Utils$.MODULE$.nonNegativeHash(filename);
        int dirId = hash % this.localDirs().length;
        int subDirId = hash / this.localDirs().length % this.subDirsPerLocalDir();
        File[] fileArray = this.subDirs()[dirId];
        synchronized (fileArray) {
            File file2;
            File old = this.subDirs()[dirId][subDirId];
            if (old != null) {
                file2 = old;
            } else {
                File newDir = new File(this.localDirs()[dirId], StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)})));
                if (!newDir.exists()) {
                    Path path = newDir.toPath();
                    Files.createDirectory(path, new FileAttribute[0]);
                    if (this.permissionChangingRequired()) {
                        Set<PosixFilePermission> currentPerms = Files.getPosixFilePermissions(path, new LinkOption[0]);
                        currentPerms.add(PosixFilePermission.GROUP_WRITE);
                        v1 = Files.setPosixFilePermissions(path, currentPerms);
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                this.subDirs()[dirId][subDirId] = newDir;
                file2 = newDir;
            }
            file = file2;
        }
        File subDir = file;
        return new File(subDir, filename);
    }

    public File getFile(BlockId blockId) {
        return this.getFile(blockId.name());
    }

    public File getMergedShuffleFile(BlockId blockId, Option<String[]> dirs) {
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleMergedDataBlockId) {
            ShuffleMergedDataBlockId shuffleMergedDataBlockId = (ShuffleMergedDataBlockId)blockId2;
            return this.getMergedShuffleFile(shuffleMergedDataBlockId.name(), dirs);
        }
        if (blockId2 instanceof ShuffleMergedIndexBlockId) {
            ShuffleMergedIndexBlockId shuffleMergedIndexBlockId = (ShuffleMergedIndexBlockId)blockId2;
            return this.getMergedShuffleFile(shuffleMergedIndexBlockId.name(), dirs);
        }
        if (blockId2 instanceof ShuffleMergedMetaBlockId) {
            ShuffleMergedMetaBlockId shuffleMergedMetaBlockId = (ShuffleMergedMetaBlockId)blockId2;
            return this.getMergedShuffleFile(shuffleMergedMetaBlockId.name(), dirs);
        }
        throw SparkException$.MODULE$.internalError("Only merged block ID is supported, but got " + blockId, "STORAGE");
    }

    private File getMergedShuffleFile(String filename, Option<String[]> dirs) {
        if (!dirs.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])x$2))))) {
            throw SparkException$.MODULE$.internalError("Cannot read " + filename + " because merged shuffle dirs is empty", "STORAGE");
        }
        return new File(ExecutorDiskUtils.getFilePath((String[])((String[])dirs.get()), (int)this.subDirsPerLocalDir(), (String)filename));
    }

    public boolean containsBlock(BlockId blockId) {
        return this.getFile(blockId.name()).exists();
    }

    public Seq<File> getAllFiles() {
        return ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.subDirs()), (Function1 & Serializable)dir -> {
            File[] fileArray = dir;
            synchronized (dir) {
                File[] fileArray2 = (File[])dir.clone();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return fileArray2;
            }
        }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DiskBlockManager.$anonfun$getAllFiles$3(x$3)))), (Function1 & Serializable)dir -> {
            File[] files = dir.listFiles();
            if (files != null) {
                return ArrayImplicits$.MODULE$.SparkArrayOps((Object)files).toImmutableArraySeq();
            }
            return (Seq)package$.MODULE$.Seq().empty();
        }, ClassTag$.MODULE$.apply(File.class))).toImmutableArraySeq();
    }

    public Seq<BlockId> getAllBlocks() {
        return (Seq)this.getAllFiles().flatMap((Function1 & Serializable)f -> {
            Some some;
            try {
                some = new Some((Object)BlockId$.MODULE$.apply(f.getName()));
            }
            catch (UnrecognizedBlockId unrecognizedBlockId) {
                some = None$.MODULE$;
            }
            return some;
        });
    }

    public void createWorldReadableFile(File file) {
        Path path = file.toPath();
        Files.createFile(path, new FileAttribute[0]);
        Set<PosixFilePermission> currentPerms = Files.getPosixFilePermissions(path, new LinkOption[0]);
        currentPerms.add(PosixFilePermission.OTHERS_READ);
        Files.setPosixFilePermissions(path, currentPerms);
    }

    public File createTempFileWith(File file) {
        File tmpFile;
        block0: {
            tmpFile = Utils$.MODULE$.tempFileWith(file);
            if (!this.permissionChangingRequired()) break block0;
            this.createWorldReadableFile(tmpFile);
        }
        return tmpFile;
    }

    public Tuple2<TempLocalBlockId, File> createTempLocalBlock() {
        TempLocalBlockId blockId = new TempLocalBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempLocalBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    public Tuple2<TempShuffleBlockId, File> createTempShuffleBlock() {
        TempShuffleBlockId blockId = new TempShuffleBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempShuffleBlockId(UUID.randomUUID());
        }
        File tmpFile = this.getFile(blockId);
        if (this.permissionChangingRequired()) {
            this.createWorldReadableFile(tmpFile);
        }
        return new Tuple2((Object)blockId, (Object)tmpFile);
    }

    private File[] createLocalDirs(SparkConf conf) {
        return (File[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf)), (Function1 & Serializable)rootDir -> {
            None$ none$;
            try {
                File localDir = Utils$.MODULE$.createDirectory((String)rootDir, "blockmgr");
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Created local directory at ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)localDir)}))));
                none$ = new Some((Object)localDir);
            }
            catch (IOException e) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create local dir in ", ". Ignoring this directory."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, rootDir)}))), (Throwable)e);
                none$ = None$.MODULE$;
            }
            return none$;
        }, ClassTag$.MODULE$.apply(File.class));
    }

    private void createLocalDirsForMergedShuffleBlocks() {
        if (Utils$.MODULE$.isPushBasedShuffleEnabled(this.conf, this.isDriver, false)) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(this.conf)), (Function1 & Serializable)rootDir -> {
                DiskBlockManager.$anonfun$createLocalDirsForMergedShuffleBlocks$1(this, rootDir);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void createDirWithPermission770(File dirToCreate) {
        int attempts = 0;
        int maxAttempts = Utils$.MODULE$.MAX_DIR_CREATION_ATTEMPTS();
        File created = null;
        while (created == null) {
            if (++attempts > maxAttempts) {
                throw SparkCoreErrors$.MODULE$.failToCreateDirectoryError(dirToCreate.getAbsolutePath(), maxAttempts);
            }
            try {
                dirToCreate.mkdirs();
                Files.setPosixFilePermissions(dirToCreate.toPath(), PosixFilePermissions.fromString("rwxrwx---"));
                if (dirToCreate.exists()) {
                    created = dirToCreate;
                }
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Created directory at " + dirToCreate.getAbsolutePath() + " with permission 770");
            }
            catch (SecurityException e) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create directory ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)dirToCreate.getAbsolutePath())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"with permission 770"}))).log((Seq)Nil$.MODULE$))), (Throwable)e);
                created = null;
            }
        }
    }

    public String getMergeDirectoryAndAttemptIDJsonString() {
        HashMap mergedMetaMap = new HashMap();
        mergedMetaMap.put((Object)DiskBlockManager$.MODULE$.MERGE_DIR_KEY(), (Object)this.mergeDirName());
        ((Option)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.APP_ATTEMPT_ID())).foreach((Function1 & Serializable)attemptId -> mergedMetaMap.put((Object)DiskBlockManager$.MODULE$.ATTEMPT_ID_KEY(), attemptId));
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        String jsonString = mapper.writeValueAsString((Object)mergedMetaMap);
        return jsonString;
    }

    private Object addShutdownHook() {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Adding shutdown hook");
        return ShutdownHookManager$.MODULE$.addShutdownHook(ShutdownHookManager$.MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY() + 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Shutdown hook called");
            this.doStop();
        });
    }

    public void stop() {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook()));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception while removing shutdown hook.", (Throwable)e);
            bl = BoxedUnit.UNIT;
        }
        this.doStop();
    }

    private void doStop() {
        if (this.deleteFilesOnStop()) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.localDirs()), (Function1 & Serializable)localDir -> {
                DiskBlockManager.$anonfun$doStop$1(this, localDir);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllFiles$3(File x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ void $anonfun$createLocalDirsForMergedShuffleBlocks$1(DiskBlockManager $this, String rootDir) {
        try {
            File mergeDir = new File(rootDir, $this.mergeDirName());
            if (!mergeDir.exists() || mergeDir.listFiles().length < $this.subDirsPerLocalDir()) {
                $this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Try to create " + mergeDir + " and its sub dirs since the " + $this.mergeDirName() + " dir does not exist");
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.subDirsPerLocalDir()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)dirNum -> {
                    File subDir = new File(mergeDir, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirNum)})));
                    if (!subDir.exists()) {
                        $this.createDirWithPermission770(subDir);
                        return;
                    }
                });
            }
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Merge directory and its sub dirs get created at ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)mergeDir)}))));
        }
        catch (IOException e) {
            $this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to create ", " dir in "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.MERGE_DIR_NAME$.MODULE$, (Object)$this.mergeDirName())})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Ignoring this directory."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)rootDir)})))), (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$doStop$1(DiskBlockManager $this, File localDir) {
        if (localDir.isDirectory() && localDir.exists()) {
            try {
                if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(localDir)) {
                    Utils$.MODULE$.deleteRecursively(localDir);
                }
            }
            catch (Exception e) {
                $this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while deleting local spark dir: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)localDir)}))), (Throwable)e);
            }
            return;
        }
    }

    public DiskBlockManager(SparkConf conf, boolean deleteFilesOnStop, boolean isDriver) {
        this.conf = conf;
        this.deleteFilesOnStop = deleteFilesOnStop;
        this.isDriver = isDriver;
        Logging.$init$((Logging)this);
        this.subDirsPerLocalDir = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DISKSTORE_SUB_DIRECTORIES()));
        this.localDirs = this.createLocalDirs(conf);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.localDirs()))) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to create any local dir.");
            System.exit(ExecutorExitCode$.MODULE$.DISK_STORE_FAILED_TO_CREATE_DIR());
        }
        this.localDirsString = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.localDirs()), (Function1 & Serializable)x$1 -> x$1.toString(), ClassTag$.MODULE$.apply(String.class));
        this.subDirs = (File[][])Array$.MODULE$.fill(this.localDirs().length, (Function0 & Serializable)() -> new File[this.subDirsPerLocalDir()], ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(File.class)));
        this.mergeDirName = DiskBlockManager$.MODULE$.MERGE_DIRECTORY() + ((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.APP_ATTEMPT_ID())).map((Function1 & Serializable)id -> "_" + id).getOrElse((Function0 & Serializable)() -> "");
        this.createLocalDirsForMergedShuffleBlocks();
        this.shutdownHook = this.addShutdownHook();
        this.permissionChangingRequired = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED())) && (BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_REMOVE_SHUFFLE_ENABLED())) || BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_FETCH_RDD_ENABLED())));
    }
}

