/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.impl.sql.execute.TablePrivilegeInfo;
import org.apache.derby.shared.common.error.StandardException;

class TablePrivilegesNode
extends QueryTreeNode {
    private boolean[] actionAllowed = new boolean[6];
    private ResultColumnList[] columnLists = new ResultColumnList[6];
    private FormatableBitSet[] columnBitSets = new FormatableBitSet[6];
    private TableDescriptor td;
    private List<Provider> descriptorList;

    TablePrivilegesNode(ContextManager contextManager) {
        super(contextManager);
    }

    void addAll() {
        for (int i = 0; i < 6; ++i) {
            this.actionAllowed[i] = true;
            this.columnLists[i] = null;
        }
    }

    void addAction(int n, ResultColumnList resultColumnList) {
        this.actionAllowed[n] = true;
        if (resultColumnList == null) {
            this.columnLists[n] = null;
        } else if (this.columnLists[n] == null) {
            this.columnLists[n] = resultColumnList;
        } else {
            this.columnLists[n].appendResultColumns(resultColumnList, false);
        }
    }

    void bind(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        this.td = tableDescriptor;
        for (int i = 0; i < 6; ++i) {
            if (this.columnLists[i] != null) {
                this.columnBitSets[i] = this.columnLists[i].bindResultColumnsByName(tableDescriptor, null);
            }
            if (tableDescriptor.getTableType() != 2 || i == 0 || !this.actionAllowed[i]) continue;
            throw StandardException.newException((String)"42509", (Object[])new Object[]{tableDescriptor.getQualifiedName()});
        }
        if (bl && tableDescriptor.getTableType() == 2) {
            this.bindPrivilegesForView(tableDescriptor);
        }
    }

    PrivilegeInfo makePrivilegeInfo() {
        return new TablePrivilegeInfo(this.td, this.actionAllowed, this.columnBitSets, this.descriptorList);
    }

    private void bindPrivilegesForView(TableDescriptor tableDescriptor) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        ViewDescriptor viewDescriptor = dataDictionary.getViewDescriptor(tableDescriptor);
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        ProviderInfo[] providerInfoArray = dependencyManager.getPersistentProviderInfos(viewDescriptor);
        this.descriptorList = new ArrayList<Provider>();
        int n = providerInfoArray.length;
        for (int i = 0; i < n; ++i) {
            Provider provider = (Provider)providerInfoArray[i].getDependableFinder().getDependable(dataDictionary, providerInfoArray[i].getObjectId());
            if (!(provider instanceof TableDescriptor) && !(provider instanceof ViewDescriptor) && !(provider instanceof AliasDescriptor)) continue;
            this.descriptorList.add(provider);
        }
    }
}

