/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.IterableFactory;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.StrictOptimizedIterableOps;
import coursierapi.shaded.scala.collection.generic.DefaultSerializable;
import coursierapi.shaded.scala.collection.mutable.AbstractSet;
import coursierapi.shaded.scala.collection.mutable.LinkedHashSet$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.hashing.MurmurHash3$;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class LinkedHashSet<A>
extends AbstractSet<A>
implements StrictOptimizedIterableOps<A, LinkedHashSet, LinkedHashSet<A>>,
DefaultSerializable {
    private Entry<A> firstEntry = null;
    private Entry<A> lastEntry = null;
    public Entry<A>[] scala$collection$mutable$LinkedHashSet$$table = new Entry[this.tableSizeFor(16)];
    private int threshold = (int)((double)this.scala$collection$mutable$LinkedHashSet$$table.length * 0.75);
    private int contentSize = 0;

    @Override
    public Tuple2<LinkedHashSet<A>, LinkedHashSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<LinkedHashSet<A1>, LinkedHashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public IterableFactory<LinkedHashSet> iterableFactory() {
        return LinkedHashSet$.MODULE$;
    }

    public Entry<A> firstEntry() {
        return this.firstEntry;
    }

    public void firstEntry_$eq(Entry<A> x$1) {
        this.firstEntry = x$1;
    }

    public Entry<A> lastEntry() {
        return this.lastEntry;
    }

    public void lastEntry_$eq(Entry<A> x$1) {
        this.lastEntry = x$1;
    }

    @Override
    public A last() {
        if (this.size() > 0) {
            return this.lastEntry().key();
        }
        throw new NoSuchElementException("Cannot call .last on empty LinkedHashSet");
    }

    @Override
    public Option<A> lastOption() {
        if (this.size() > 0) {
            return new Some<A>(this.lastEntry().key());
        }
        return None$.MODULE$;
    }

    @Override
    public A head() {
        if (this.size() > 0) {
            return this.firstEntry().key();
        }
        throw new NoSuchElementException("Cannot call .head on empty LinkedHashSet");
    }

    @Override
    public Option<A> headOption() {
        if (this.size() > 0) {
            return new Some<A>(this.firstEntry().key());
        }
        return None$.MODULE$;
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(A elem) {
        int findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash >>> 16;
        Entry<A> entry = this.scala$collection$mutable$LinkedHashSet$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashSet$$table.length - 1];
        Entry<A> entry2 = entry == null ? null : entry.findEntry(elem, findEntry_hash);
        entry = null;
        return entry2 != null;
    }

    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / 0.75));
        if (target > this.scala$collection$mutable$LinkedHashSet$$table.length) {
            this.growTable(target);
            return;
        }
    }

    @Override
    public boolean add(A elem) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$LinkedHashSet$$table.length * 2);
        }
        int scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int hash = scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash >>> 16;
        return this.put0(elem, hash, hash & this.scala$collection$mutable$LinkedHashSet$$table.length - 1);
    }

    @Override
    public LinkedHashSet<A> addOne(A elem) {
        this.add(elem);
        return this;
    }

    @Override
    public LinkedHashSet<A> subtractOne(A elem) {
        this.remove(elem);
        return this;
    }

    @Override
    public boolean remove(A elem) {
        int scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(elem);
        return this.remove0(elem, scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash >>> 16);
    }

    @Override
    public Iterator<A> iterator() {
        return new LinkedHashSetIterator(this){

            public A extract(Entry<A> nd) {
                return nd.key();
            }
        };
    }

    public Iterator<Entry<A>> entryIterator() {
        return new LinkedHashSetIterator(this){

            public Entry<A> extract(Entry<A> nd) {
                return nd;
            }
        };
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        for (Entry<A> cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply(cur.key());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.scala$collection$mutable$LinkedHashSet$$table, null);
        this.contentSize = 0;
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private int tableSizeFor(int capacity) {
        int n = capacity - 1;
        int max$extension_that = 4;
        int n2 = Integer.highestOneBit(Math.max(n, max$extension_that)) * 2;
        int min$extension_that = 0x40000000;
        return Math.min(n2, min$extension_that);
    }

    public int unimproveHash(int improvedHash) {
        return improvedHash ^ improvedHash >>> 16;
    }

    private Entry<A> createNewEntry(A key, int hash) {
        Entry<A> e = new Entry<A>(key, hash);
        if (this.firstEntry() == null) {
            this.firstEntry_$eq(e);
        } else {
            this.lastEntry().later_$eq(e);
            e.earlier_$eq(this.lastEntry());
        }
        this.lastEntry_$eq(e);
        return e;
    }

    private void deleteEntry(Entry<A> e) {
        if (e.earlier() == null) {
            this.firstEntry_$eq(e.later());
        } else {
            e.earlier().later_$eq(e.later());
        }
        if (e.later() == null) {
            this.lastEntry_$eq(e.earlier());
        } else {
            e.later().earlier_$eq(e.earlier());
        }
        e.earlier_$eq(null);
        e.later_$eq(null);
        e.next_$eq(null);
    }

    private boolean put0(A elem, int hash, int idx) {
        Entry<A> entry = this.scala$collection$mutable$LinkedHashSet$$table[idx];
        if (entry == null) {
            this.scala$collection$mutable$LinkedHashSet$$table[idx] = this.createNewEntry(elem, hash);
        } else {
            Entry<A> prev = null;
            for (Entry<A> n = entry; n != null && n.hash() <= hash; n = n.next()) {
                if (n.hash() == hash && BoxesRunTime.equals(elem, n.key())) {
                    return false;
                }
                prev = n;
            }
            Entry<A> nnode = this.createNewEntry(elem, hash);
            if (prev == null) {
                nnode.next_$eq(entry);
                this.scala$collection$mutable$LinkedHashSet$$table[idx] = nnode;
            } else {
                nnode.next_$eq(prev.next());
                prev.next_$eq(nnode);
            }
        }
        ++this.contentSize;
        return true;
    }

    private boolean remove0(A elem, int hash) {
        int idx = hash & this.scala$collection$mutable$LinkedHashSet$$table.length - 1;
        Entry<A> entry = this.scala$collection$mutable$LinkedHashSet$$table[idx];
        if (entry == null) {
            return false;
        }
        if (entry.hash() == hash && BoxesRunTime.equals(entry.key(), elem)) {
            this.scala$collection$mutable$LinkedHashSet$$table[idx] = entry.next();
            this.deleteEntry(entry);
            --this.contentSize;
            return true;
        }
        Entry<A> prev = entry;
        for (Entry<A> next = entry.next(); next != null && next.hash() <= hash; next = next.next()) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                this.deleteEntry(next);
                --this.contentSize;
                return true;
            }
            prev = next;
        }
        return false;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException(new StringBuilder(36).append("new hash table size ").append(newlen).append(" exceeds maximum").toString());
        }
        this.threshold = (int)((double)newlen * 0.75);
        if (this.size() == 0) {
            this.scala$collection$mutable$LinkedHashSet$$table = new Entry[newlen];
            return;
        }
        this.scala$collection$mutable$LinkedHashSet$$table = Arrays.copyOf(this.scala$collection$mutable$LinkedHashSet$$table, newlen);
        Entry<Object> preLow = new Entry<Object>(null, 0);
        Entry<Object> preHigh = new Entry<Object>(null, 0);
        for (int oldlen = this.scala$collection$mutable$LinkedHashSet$$table.length; oldlen < newlen; oldlen *= 2) {
            for (int i = 0; i < oldlen; ++i) {
                Entry<A> old = this.scala$collection$mutable$LinkedHashSet$$table[i];
                if (old == null) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Entry<Object> lastLow = preLow;
                Entry<Object> lastHigh = preHigh;
                Entry<A> n = old;
                while (n != null) {
                    Entry<A> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (old != preLow.next()) {
                    this.scala$collection$mutable$LinkedHashSet$$table[i] = preLow.next();
                }
                if (preHigh.next() == null) continue;
                this.scala$collection$mutable$LinkedHashSet$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    @Override
    public int hashCode() {
        LinkedHashSetIterator setHashIterator = this.isEmpty() ? this.iterator() : new LinkedHashSetIterator(this){
            private int hash;
            private final /* synthetic */ LinkedHashSet $outer;

            public int hash() {
                return this.hash;
            }

            public void hash_$eq(int x$1) {
                this.hash = x$1;
            }

            public int hashCode() {
                return this.hash();
            }

            public Object extract(Entry<A> nd) {
                this.hash_$eq(this.$outer.unimproveHash(nd.hash()));
                return this;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hash = 0;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash(setHashIterator, MurmurHash3$.MODULE$.setSeed());
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashSet";
    }

    public static final class Entry<A> {
        private final A key;
        private final int hash;
        private Entry<A> earlier;
        private Entry<A> later;
        private Entry<A> next;

        public A key() {
            return this.key;
        }

        public int hash() {
            return this.hash;
        }

        public Entry<A> earlier() {
            return this.earlier;
        }

        public void earlier_$eq(Entry<A> x$1) {
            this.earlier = x$1;
        }

        public Entry<A> later() {
            return this.later;
        }

        public void later_$eq(Entry<A> x$1) {
            this.later = x$1;
        }

        public Entry<A> next() {
            return this.next;
        }

        public void next_$eq(Entry<A> x$1) {
            this.next = x$1;
        }

        public final Entry<A> findEntry(A k, int h) {
            while (h != this_.hash() || !BoxesRunTime.equals(k, this_.key())) {
                if (this_.next() == null || this_.hash() > h) {
                    return null;
                }
                Entry<A> this_ = this_.next();
            }
            return this_;
        }

        public Entry(A key, int hash) {
            this.key = key;
            this.hash = hash;
            this.earlier = null;
            this.later = null;
            this.next = null;
        }
    }

    private abstract class LinkedHashSetIterator<T>
    extends AbstractIterator<T> {
        private Entry<A> cur;

        public abstract T extract(Entry<A> var1);

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T r = this.extract(this.cur);
                this.cur = this.cur.later();
                return r;
            }
            return (T)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        public LinkedHashSetIterator() {
            if (LinkedHashSet.this == null) {
                throw null;
            }
            this.cur = LinkedHashSet.this.firstEntry();
        }
    }
}

