/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;

@Experimental
public class CaseInsensitiveStringMap
implements Map<String, String> {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(CaseInsensitiveStringMap.class);
    private final Map<String, String> original;
    private final Map<String, String> delegate;

    public static CaseInsensitiveStringMap empty() {
        return new CaseInsensitiveStringMap(new HashMap<String, String>(0));
    }

    public CaseInsensitiveStringMap(Map<String, String> originalMap) {
        this.original = new HashMap<String, String>(originalMap);
        this.delegate = new HashMap<String, String>(originalMap.size());
        for (Map.Entry<String, String> entry : originalMap.entrySet()) {
            String key = this.toLowerCase(entry.getKey());
            if (this.delegate.containsKey(key)) {
                logger.warn("Converting duplicated key {} into CaseInsensitiveStringMap.", new MDC[]{MDC.of((LogKey)LogKeys.KEY$.MODULE$, (Object)entry.getKey())});
            }
            this.delegate.put(key, entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    private String toLowerCase(Object key) {
        return key.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(this.toLowerCase(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.delegate.get(this.toLowerCase(key));
    }

    @Override
    public String put(String key, String value) {
        throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3132");
    }

    @Override
    public String remove(Object key) {
        throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3132");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3132");
    }

    @Override
    public void clear() {
        throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3132");
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3206", Map.of("value", value));
    }

    public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Double.parseDouble(value);
    }

    public Map<String, String> asCaseSensitiveMap() {
        return Collections.unmodifiableMap(this.original);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseInsensitiveStringMap that = (CaseInsensitiveStringMap)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

