/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unhex$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Converts hexadecimal `expr` to binary.", examples="\n    Examples:\n      > SELECT decode(_FUNC_('537061726B2053514C'), 'UTF-8');\n       Spark SQL\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003R\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011Q\u0011\u0015)\u0006\u0001\"\u0001\\\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015I\u0007\u0001\"\u0011Q\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015y\u0007\u0001\"\u0015q\u0011\u00151\b\u0001\"\u0015x\u0011\u001d\tY\u0001\u0001C)\u0003\u001bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005m\u0001!%A\u0005\u0002\u0005u\u0001\"CA\u001a\u0001E\u0005I\u0011AA\u001b\u0011%\tI\u0004AA\u0001\n\u0003\nY\u0004C\u0005\u0002N\u0001\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003?\u0002\u0011\u0011!C!\u0003CB\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\t\u0013\u0005U\u0004!!A\u0005B\u0005]\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u000f%\t\tKIA\u0001\u0012\u0003\t\u0019K\u0002\u0005\"E\u0005\u0005\t\u0012AAS\u0011\u0019)\u0016\u0004\"\u0001\u0002>\"I\u0011qX\r\u0002\u0002\u0013\u0015\u0013\u0011\u0019\u0005\n\u0003\u0007L\u0012\u0011!CA\u0003\u000bD\u0011\"a3\u001a#\u0003%\t!!\u000e\t\u0013\u00055\u0017$!A\u0005\u0002\u0006=\u0007\"CAq3E\u0005I\u0011AA\u001b\u0011%\t\u0019/GA\u0001\n\u0013\t)OA\u0003V]\",\u0007P\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0007N\u001c>!\t\t$'D\u0001#\u0013\t\u0019$EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tT'\u0003\u00027E\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005y2eBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011e&\u0001\u0004=e>|GOP\u0005\u0002u%\u0011Q)O\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Fs\u0005)1\r[5mIV\t1\n\u0005\u00022\u0019&\u0011QJ\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%A\u0006gC&dwJ\\#se>\u0014X#A)\u0011\u0005a\u0012\u0016BA*:\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDcA,Y3B\u0011\u0011\u0007\u0001\u0005\u0006\u0013\u0016\u0001\ra\u0013\u0005\b\u001f\u0016\u0001\n\u00111\u0001R\u00039qW\u000f\u001c7J]R|G.\u001a:b]R$\"a\u0016/\t\u000bu;\u0001\u0019A&\u0002\t\u0015D\bO]\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00011\u0011\u0007y\n7-\u0003\u0002c\u0011\n\u00191+Z9\u0011\u0005\u0011<W\"A3\u000b\u0005\u00194\u0013!\u0002;za\u0016\u001c\u0018B\u00015f\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u0003!!\u0017\r^1UsB,W#\u00017\u0011\u0005\u0011l\u0017B\u00018f\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCA9u!\tA$/\u0003\u0002ts\t\u0019\u0011I\\=\t\u000bU\\\u0001\u0019A9\u0002\u00079,X.A\u0005e_\u001e+gnQ8eKR!\u0001P`A\u0004!\tIH0D\u0001{\u0015\tY(%A\u0004d_\u0012,w-\u001a8\n\u0005uT(\u0001C#yaJ\u001cu\u000eZ3\t\r}d\u0001\u0019AA\u0001\u0003\r\u0019G\u000f\u001f\t\u0004s\u0006\r\u0011bAA\u0003u\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0005\u0019\u0001\u0007\u00010\u0001\u0002fm\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2aVA\b\u0011\u0019\t\t\"\u0004a\u0001\u0017\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#B,\u0002\u0018\u0005e\u0001bB%\u000f!\u0003\u0005\ra\u0013\u0005\b\u001f:\u0001\n\u00111\u0001R\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\b+\u0007-\u000b\tc\u000b\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!C;oG\",7m[3e\u0015\r\ti#O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0019\u0003O\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u000e+\u0007E\u000b\t#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0001B!a\u0010\u0002J5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0003mC:<'BAA$\u0003\u0011Q\u0017M^1\n\t\u0005-\u0013\u0011\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0003c\u0001\u001d\u0002T%\u0019\u0011QK\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007E\fY\u0006C\u0005\u0002^M\t\t\u00111\u0001\u0002R\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0019\u0011\u000b\u0005\u0015\u00141N9\u000e\u0005\u0005\u001d$bAA5s\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0014q\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002R\u0003gB\u0001\"!\u0018\u0016\u0003\u0003\u0005\r!]\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002>\u0005e\u0004\"CA/-\u0005\u0005\t\u0019AA)\u0003\u0019)\u0017/^1mgR\u0019\u0011+a \t\u0011\u0005us#!AA\u0002ED3\u0003AAB\u0003\u0013\u000bY)a$\u0002\u0012\u0006U\u0015qSAN\u0003;\u00032!MAC\u0013\r\t9I\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti)A\u001b`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!\u0007>tg/\u001a:ug\u0002BW\r_1eK\u000eLW.\u00197!A\u0016D\bO\u001d1!i>\u0004#-\u001b8beft\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005M\u0015\u0001\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!I\u0016\u001cw\u000eZ3)?\u001a+fjQ0)OU\u001at\u0007\r\u001c2oI2$I\r\u00196gU\nDgQ\u0014*Y\u0001:S\u000b\u0016$.q\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\\u0007eU)M\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAM\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\ty*\u0001\u0006nCRDwLZ;oGN\fQ!\u00168iKb\u0004\"!M\r\u0014\u000be\t9+a-\u0011\u000f\u0005%\u0016qV&R/6\u0011\u00111\u0016\u0006\u0004\u0003[K\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003c\u000bYKA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0005\u0003s\u000b)%\u0001\u0002j_&\u0019q)a.\u0015\u0005\u0005\r\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0012!B1qa2LH#B,\u0002H\u0006%\u0007\"B%\u001d\u0001\u0004Y\u0005bB(\u001d!\u0003\u0005\r!U\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BAi\u0003;\u0004R\u0001OAj\u0003/L1!!6:\u0005\u0019y\u0005\u000f^5p]B)\u0001(!7L#&\u0019\u00111\\\u001d\u0003\rQ+\b\u000f\\33\u0011!\tyNHA\u0001\u0002\u00049\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a:\u0011\t\u0005}\u0012\u0011^\u0005\u0005\u0003W\f\tE\u0001\u0004PE*,7\r\u001e")
public class Unhex
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$2() {
        return Unhex$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Unhex x$0) {
        return Unhex$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Unhex$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Unhex> tupled() {
        return Unhex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Unhex>> curried() {
        return Unhex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object num) {
        byte[] byArray;
        try {
            byArray = Hex$.MODULE$.unhex(((UTF8String)num).getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.failOnError()) {
                byArray = null;
            }
            throw QueryExecutionErrors$.MODULE$.invalidInputInConversionError((DataType)BinaryType$.MODULE$, (UTF8String)num, UTF8String.fromString((String)"HEX"), "try_to_binary");
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return byArray;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String expr = ctx.addReferenceObj("this", this, ctx.addReferenceObj$default$3());
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)input -> "\n        " + ev.value() + " = (byte[]) " + expr + ".nullSafeEval(" + input + ");\n        " + ev.isNull() + " = " + ev.value() + " == null;\n      ");
    }

    @Override
    public Unhex withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.failOnError());
    }

    public Unhex copy(Expression child, boolean failOnError) {
        return new Unhex(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Unhex";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Unhex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Unhex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Unhex unhex = (Unhex)x$1;
        if (this.failOnError() != unhex.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unhex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unhex.canEqual(this)) return false;
        return true;
    }

    public Unhex(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Unhex(Expression expr) {
        this(expr, false);
    }
}

