/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeYMInterval$;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([years[, months]]) - Make year-month interval from years, months.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 2);\n       1-2\n      > SELECT _FUNC_(1, 0);\n       1-0\n      > SELECT _FUNC_(-1, 1);\n       -0-11\n      > SELECT _FUNC_(2);\n       2-0\n  ", since="3.2.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}a\u0001B\u0012%\u0001FB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u00151\u0006\u0001\"\u0001a\u0011\u00151\u0006\u0001\"\u0001c\u0011\u0015\u0019\u0007\u0001\"\u0011P\u0011\u0015!\u0007\u0001\"\u0011P\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015)\b\u0001\"\u0011w\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\tY\u0002\u0001C!\u0003;Aq!a\f\u0001\t#\n\t\u0004C\u0004\u0002<\u0001!\t%!\u0010\t\u0013\u00055\u0003!!A\u0005\u0002\u0005=\u0003\"CA+\u0001E\u0005I\u0011AA,\u0011%\ti\u0007AI\u0001\n\u0003\t9\u0006C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r!I\u0011\u0011\u0011\u0001\u0002\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C\u0001\u0003\u001bC\u0011\"a%\u0001\u0003\u0003%\t%!&\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAU\u0001\u0005\u0005I\u0011IAV\u0011%\ty\u000bAA\u0001\n\u0003\n\tlB\u0005\u0002\\\u0012\n\t\u0011#\u0001\u0002^\u001aA1\u0005JA\u0001\u0012\u0003\ty\u000e\u0003\u0004W;\u0011\u0005\u0011q\u001f\u0005\n\u0003sl\u0012\u0011!C#\u0003wD\u0011\"!@\u001e\u0003\u0003%\t)a@\t\u0013\t\u0015Q$!A\u0005\u0002\n\u001d\u0001\"\u0003B\u000b;\u0005\u0005I\u0011\u0002B\f\u00059i\u0015m[3Z\u001b&sG/\u001a:wC2T!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0007\u0001I2\u0014h\u0012&\u0011\u0005M\"T\"\u0001\u0013\n\u0005U\"#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0019t'\u0003\u00029I\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002;\t:\u00111(\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}A\na\u0001\u0010:p_Rt\u0014\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t\u001b\u0015a\u00029bG.\fw-\u001a\u0006\u0002\u0001&\u0011QI\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0005\u000e\u0003\"a\r%\n\u0005%##aE*vaB|'\u000f^)vKJL8i\u001c8uKb$\bCA&M\u001b\u0005\u0019\u0015BA'D\u0005\u001d\u0001&o\u001c3vGR\fQ!_3beN,\u0012\u0001\u0015\t\u0003gEK!A\u0015\u0013\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004zK\u0006\u00148\u000fI\u0001\u0007[>tG\u000f[:\u0002\u000f5|g\u000e\u001e5tA\u00051A(\u001b8jiz\"2\u0001W-[!\t\u0019\u0004\u0001C\u0003O\u000b\u0001\u0007\u0001\u000bC\u0003U\u000b\u0001\u0007\u0001+\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u0003u\u0003\"a\u00130\n\u0005}\u001b%a\u0002\"p_2,\u0017M\u001c\u000b\u00031\u0006DQAT\u0004A\u0002A#\u0012\u0001W\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u001a\t\u0004u!T\u0017BA5G\u0005\r\u0019V-\u001d\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\"\nQ\u0001^=qKNL!a\u001c7\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003I\u0004\"a[:\n\u0005Qd'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007]TH\u0010\u0005\u0002Lq&\u0011\u0011p\u0011\u0002\u0004\u0003:L\b\"B>\u000e\u0001\u00049\u0018\u0001B=fCJDQ!`\u0007A\u0002]\fQ!\\8oi\"\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\u0005\u0011QBA\f!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004I\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0006\u0003\u000b\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u001fq\u0001\u0019AA\t\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0007\t\u0019\"\u0003\u0003\u0002\u0016\u0005\u0015!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u00033q\u0001\u0019AA\u0001\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\b\u0011\t\u0005\u0005\u0012\u0011\u0006\b\u0005\u0003G\t)\u0003\u0005\u0002=\u0007&\u0019\u0011qE\"\u0002\rA\u0013X\rZ3g\u0013\u0011\tY#!\f\u0003\rM#(/\u001b8h\u0015\r\t9cQ\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R\u0001UA\u001a\u0003oAa!!\u000e\u0011\u0001\u0004\u0001\u0016a\u00028fo2+g\r\u001e\u0005\u0007\u0003s\u0001\u0002\u0019\u0001)\u0002\u00119,wOU5hQR\f\u0001#\u001b8jiF+XM]=D_:$X\r\u001f;\u0015\u0005\u0005}\u0002#B&\u0002B\u0005\u0015\u0013bAA\"\u0007\n1q\n\u001d;j_:\u0004B!a\u0012\u0002J5\t!&C\u0002\u0002L)\u0012A\"U;fef\u001cuN\u001c;fqR\fAaY8qsR)\u0001,!\u0015\u0002T!9aJ\u0005I\u0001\u0002\u0004\u0001\u0006b\u0002+\u0013!\u0003\u0005\r\u0001U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIFK\u0002Q\u00037Z#!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\u001a\u0015AC1o]>$\u0018\r^5p]&!\u00111NA1\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000f\t\u0005\u0003k\ny(\u0004\u0002\u0002x)!\u0011\u0011PA>\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0014\u0001\u00026bm\u0006LA!a\u000b\u0002x\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0011\t\u0004\u0017\u0006\u001d\u0015bAAE\u0007\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q/a$\t\u0013\u0005Eu#!AA\u0002\u0005\u0015\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0018B)\u0011\u0011TAPo6\u0011\u00111\u0014\u0006\u0004\u0003;\u001b\u0015AC2pY2,7\r^5p]&!\u0011\u0011UAN\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007u\u000b9\u000b\u0003\u0005\u0002\u0012f\t\t\u00111\u0001x\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u0014Q\u0016\u0005\n\u0003#S\u0012\u0011!a\u0001\u0003\u000b\u000ba!Z9vC2\u001cHcA/\u00024\"A\u0011\u0011S\u000e\u0002\u0002\u0003\u0007q\u000fK\f\u0001\u0003o\u000bi,a0\u0002D\u0006\u0015\u0017\u0011ZAf\u0003\u001f\f\t.!6\u0002XB\u00191'!/\n\u0007\u0005mFEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0005\u0017\u0001S0G+:\u001bu\fK.zK\u0006\u00148o\u0017\u0017![>tG\u000f[:^;&\u0002S\u0006I'bW\u0016\u0004\u00130Z1s[5|g\u000e\u001e5!S:$XM\u001d<bY\u00022'o\\7!s\u0016\f'o\u001d\u0017![>tG\u000f[:/\u0003%\t'oZ;nK:$8/\t\u0002\u0002H\u0006\t\tB\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!s\u0016\f'o\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gAe,\u0017M]:-AA|7/\u001b;jm\u0016\u0004sN\u001d\u0011oK\u001e\fG/\u001b<f\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001jwN\u001c;ig\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007%\\8oi\"\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAg\u0003\u0005\r$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0019-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019.e)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\u0007\f\u00111SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013'\f\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q5\nD\u0006I\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0003'L\u00192\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113[AR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003'\fQa\r\u00183]A\nQa\u001a:pkB\f#!!7\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006qQ*Y6f36Ke\u000e^3sm\u0006d\u0007CA\u001a\u001e'\u0015i\u0012\u0011]Aw!\u001d\t\u0019/!;Q!bk!!!:\u000b\u0007\u0005\u001d8)A\u0004sk:$\u0018.\\3\n\t\u0005-\u0018Q\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAx\u0003kl!!!=\u000b\t\u0005M\u00181P\u0001\u0003S>L1!RAy)\t\ti.\u0001\u0005u_N#(/\u001b8h)\t\t\u0019(A\u0003baBd\u0017\u0010F\u0003Y\u0005\u0003\u0011\u0019\u0001C\u0003OA\u0001\u0007\u0001\u000bC\u0003UA\u0001\u0007\u0001+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t%!\u0011\u0003\t\u0006\u0017\u0006\u0005#1\u0002\t\u0006\u0017\n5\u0001\u000bU\u0005\u0004\u0005\u001f\u0019%A\u0002+va2,'\u0007\u0003\u0005\u0003\u0014\u0005\n\t\u00111\u0001Y\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00053\u0001B!!\u001e\u0003\u001c%!!QDA<\u0005\u0019y%M[3di\u0002")
public class MakeYMInterval
extends BinaryExpression
implements ImplicitCastInputTypes,
SupportQueryContext {
    private final Expression years;
    private final Expression months;
    private Option<QueryContext> queryContext;

    public static Option<Tuple2<Expression, Expression>> unapply(MakeYMInterval x$0) {
        return MakeYMInterval$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, MakeYMInterval> tupled() {
        return MakeYMInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MakeYMInterval>> curried() {
        return MakeYMInterval$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.years();
    }

    @Override
    public Expression right() {
        return this.months();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return YearMonthIntervalType$.MODULE$.apply();
    }

    @Override
    public Object nullSafeEval(Object year, Object month) {
        return BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.makeYearMonthInterval(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), this.origin().context()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(years, months) -> {
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName()), "$");
            return iu + ".makeYearMonthInterval(" + years + ", " + months + ", " + errorContext + ")";
        });
    }

    @Override
    public String prettyName() {
        return "make_ym_interval";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public MakeYMInterval copy(Expression years, Expression months) {
        return new MakeYMInterval(years, months);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    @Override
    public String productPrefix() {
        return "MakeYMInterval";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.years();
            }
            case 1: {
                return this.months();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeYMInterval;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "years";
            }
            case 1: {
                return "months";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeYMInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeYMInterval makeYMInterval = (MakeYMInterval)x$1;
        Expression expression = this.years();
        Expression expression2 = makeYMInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeYMInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!makeYMInterval.canEqual(this)) return false;
        return true;
    }

    public MakeYMInterval(Expression years, Expression months) {
        this.years = years;
        this.months = months;
        ExpectsInputTypes.$init$(this);
        SupportQueryContext.$init$(this);
    }

    public MakeYMInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeYMInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

