/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ml;

import java.io.Serializable;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.connect.proto.Doubles;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Fetch;
import org.apache.spark.connect.proto.Ints;
import org.apache.spark.connect.proto.MlParams;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Params;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter$;
import org.apache.spark.sql.connect.common.ProtoDataTypes$;
import org.apache.spark.sql.connect.ml.MLUtils$;
import org.apache.spark.sql.connect.ml.MlUnsupportedException;
import org.apache.spark.sql.connect.service.SessionHolder;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Serializer$ {
    public static final Serializer$ MODULE$ = new Serializer$();

    public Expression.Literal serializeParam(Object data) {
        Object object = data;
        if (object instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)object;
            Expression.Literal.Struct.Builder builder = Expression.Literal.Struct.newBuilder();
            builder.setStructType(ProtoDataTypes$.MODULE$.VectorUDT());
            builder.addElements(Expression.Literal.newBuilder().setByte(0));
            builder.addElements(Expression.Literal.newBuilder().setInteger(sparseVector.size()));
            builder.addElements(this.buildIntArray(sparseVector.indices()));
            builder.addElements(this.buildDoubleArray(sparseVector.values()));
            return Expression.Literal.newBuilder().setStruct(builder).build();
        }
        if (object instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)object;
            Expression.Literal.Struct.Builder builder = Expression.Literal.Struct.newBuilder();
            builder.setStructType(ProtoDataTypes$.MODULE$.VectorUDT());
            builder.addElements(Expression.Literal.newBuilder().setByte(1));
            builder.addElements(Expression.Literal.newBuilder().setNull(ProtoDataTypes$.MODULE$.NullType()));
            builder.addElements(Expression.Literal.newBuilder().setNull(ProtoDataTypes$.MODULE$.NullType()));
            builder.addElements(this.buildDoubleArray(denseVector.values()));
            return Expression.Literal.newBuilder().setStruct(builder).build();
        }
        if (object instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)object;
            Expression.Literal.Struct.Builder builder = Expression.Literal.Struct.newBuilder();
            builder.setStructType(ProtoDataTypes$.MODULE$.MatrixUDT());
            builder.addElements(Expression.Literal.newBuilder().setByte(0));
            builder.addElements(Expression.Literal.newBuilder().setInteger(sparseMatrix.numRows()));
            builder.addElements(Expression.Literal.newBuilder().setInteger(sparseMatrix.numCols()));
            builder.addElements(this.buildIntArray(sparseMatrix.colPtrs()));
            builder.addElements(this.buildIntArray(sparseMatrix.rowIndices()));
            builder.addElements(this.buildDoubleArray(sparseMatrix.values()));
            builder.addElements(Expression.Literal.newBuilder().setBoolean(sparseMatrix.isTransposed()));
            return Expression.Literal.newBuilder().setStruct(builder).build();
        }
        if (object instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)object;
            Expression.Literal.Struct.Builder builder = Expression.Literal.Struct.newBuilder();
            builder.setStructType(ProtoDataTypes$.MODULE$.MatrixUDT());
            builder.addElements(Expression.Literal.newBuilder().setByte(1));
            builder.addElements(Expression.Literal.newBuilder().setInteger(denseMatrix.numRows()));
            builder.addElements(Expression.Literal.newBuilder().setInteger(denseMatrix.numCols()));
            builder.addElements(Expression.Literal.newBuilder().setNull(ProtoDataTypes$.MODULE$.NullType()));
            builder.addElements(Expression.Literal.newBuilder().setNull(ProtoDataTypes$.MODULE$.NullType()));
            builder.addElements(this.buildDoubleArray(denseMatrix.values()));
            builder.addElements(Expression.Literal.newBuilder().setBoolean(denseMatrix.isTransposed()));
            return Expression.Literal.newBuilder().setStruct(builder).build();
        }
        if (object instanceof Byte ? true : (object instanceof Short ? true : (object instanceof Integer ? true : (object instanceof Long ? true : (object instanceof Float ? true : (object instanceof Double ? true : (object instanceof Boolean ? true : (object instanceof String ? true : ScalaRunTime$.MODULE$.isArray(object, 1))))))))) {
            return LiteralValueProtoConverter$.MODULE$.toLiteralProto(data);
        }
        throw new MlUnsupportedException(object + " not supported");
    }

    private Expression.Literal buildIntArray(int[] values) {
        Ints.Builder builder = Ints.newBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(values), (Function1 & Serializable)x$1 -> builder.addValues(BoxesRunTime.unboxToInt((Object)x$1)));
        return Expression.Literal.newBuilder().setSpecializedArray(Expression.Literal.SpecializedArray.newBuilder().setInts(builder).build()).build();
    }

    private Expression.Literal buildDoubleArray(double[] values) {
        Doubles.Builder builder = Doubles.newBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(values), (Function1 & Serializable)x$1 -> builder.addValues(BoxesRunTime.unboxToDouble((Object)x$1)));
        return Expression.Literal.newBuilder().setSpecializedArray(Expression.Literal.SpecializedArray.newBuilder().setDoubles(builder).build()).build();
    }

    public Tuple2<Object, Class<?>>[] deserializeMethodArguments(Fetch.Method.Args[] args, SessionHolder sessionHolder) {
        return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])args), (Function1 & Serializable)arg -> {
            if (arg.hasParam()) {
                Expression.Literal literal = arg.getParam();
                Expression.Literal.LiteralTypeCase literalTypeCase = literal.getLiteralTypeCase();
                if (Expression.Literal.LiteralTypeCase.STRUCT.equals(literalTypeCase)) {
                    Expression.Literal.Struct struct = literal.getStruct();
                    String string = struct.getStructType().getUdt().getJvmClass();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -442626967: {
                            if (!"org.apache.spark.ml.linalg.MatrixUDT".equals(string)) break;
                            return new Tuple2((Object)MLUtils$.MODULE$.deserializeMatrix(struct), Matrix.class);
                        }
                        case 1006386087: {
                            if (!"org.apache.spark.ml.linalg.VectorUDT".equals(string)) break;
                            return new Tuple2((Object)MLUtils$.MODULE$.deserializeVector(struct), Vector.class);
                        }
                    }
                    throw new MlUnsupportedException("Unsupported struct " + literal.getStruct());
                }
                if (Expression.Literal.LiteralTypeCase.INTEGER.equals(literalTypeCase)) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)literal.getInteger()), Integer.TYPE);
                }
                if (Expression.Literal.LiteralTypeCase.FLOAT.equals(literalTypeCase)) {
                    return new Tuple2((Object)BoxesRunTime.boxToDouble((double)literal.getFloat()), Double.TYPE);
                }
                if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
                    return new Tuple2((Object)literal.getString(), String.class);
                }
                if (Expression.Literal.LiteralTypeCase.DOUBLE.equals(literalTypeCase)) {
                    return new Tuple2((Object)BoxesRunTime.boxToDouble((double)literal.getDouble()), Double.TYPE);
                }
                if (Expression.Literal.LiteralTypeCase.BOOLEAN.equals(literalTypeCase)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)literal.getBoolean()), Boolean.TYPE);
                }
                if (Expression.Literal.LiteralTypeCase.ARRAY.equals(literalTypeCase)) {
                    Expression.Literal.Array array = literal.getArray();
                    DataType.KindCase kindCase = array.getElementType().getKindCase();
                    if (DataType.KindCase.DOUBLE.equals(kindCase)) {
                        return new Tuple2((Object)MODULE$.parseDoubleArray(array), double[].class);
                    }
                    if (DataType.KindCase.STRING.equals(kindCase)) {
                        return new Tuple2((Object)MODULE$.parseStringArray(array), String[].class);
                    }
                    if (DataType.KindCase.ARRAY.equals(kindCase)) {
                        DataType.KindCase kindCase2 = array.getElementType().getArray().getElementType().getKindCase();
                        if (DataType.KindCase.STRING.equals(kindCase2)) {
                            return new Tuple2((Object)MODULE$.parseStringArrayArray(array), String[][].class);
                        }
                        throw new MlUnsupportedException("Unsupported inner array " + array);
                    }
                    throw new MlUnsupportedException("Unsupported array " + literal);
                }
                throw new MlUnsupportedException(literalTypeCase + " not supported");
            }
            if (arg.hasInput()) {
                return new Tuple2(MLUtils$.MODULE$.parseRelationProto(arg.getInput(), sessionHolder), Dataset.class);
            }
            throw new MlUnsupportedException(arg + " not supported");
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private double[] parseDoubleArray(Expression.Literal.Array array) {
        double[] values = new double[array.getElementsCount()];
        for (int i = 0; i < array.getElementsCount(); ++i) {
            values[i] = array.getElements(i).getDouble();
        }
        return values;
    }

    private String[] parseStringArray(Expression.Literal.Array array) {
        String[] values = new String[array.getElementsCount()];
        for (int i = 0; i < array.getElementsCount(); ++i) {
            values[i] = array.getElements(i).getString();
        }
        return values;
    }

    private String[][] parseStringArrayArray(Expression.Literal.Array array) {
        String[][] values = new String[array.getElementsCount()][];
        for (int i = 0; i < array.getElementsCount(); ++i) {
            values[i] = this.parseStringArray(array.getElements(i).getArray());
        }
        return values;
    }

    public MlParams serializeParams(Params instance) {
        MlParams.Builder builder = MlParams.newBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])instance.params()), (Function1 & Serializable)param -> {
            if (instance.isSet(param)) {
                Expression.Literal v = MODULE$.serializeParam(instance.get(param).get());
                return builder.putParams(param.name(), v);
            }
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private Serializer$() {
    }
}

