/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.shuffledb.StoreVersion;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.Options;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class LevelDBProvider {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(LevelDBProvider.class);

    public static DB initLevelDB(File dbFile, StoreVersion version, ObjectMapper mapper) throws IOException {
        DB tmpDb = null;
        if (dbFile != null) {
            Options options = new Options();
            options.createIfMissing(false);
            options.logger((Logger)new LevelDBLogger());
            try {
                tmpDb = JniDBFactory.factory.open(dbFile, options);
            }
            catch (NativeDB.DBException e) {
                if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                    logger.info("Creating state database at {}", new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)dbFile)});
                    options.createIfMissing(true);
                    try {
                        tmpDb = JniDBFactory.factory.open(dbFile, options);
                    }
                    catch (NativeDB.DBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("error opening leveldb file {}. Creating new file, will not be able to recover state for existing applications", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)dbFile)});
                if (dbFile.isDirectory()) {
                    for (File f : dbFile.listFiles()) {
                        if (f.delete()) continue;
                        logger.warn("error deleting {}", new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)f.getPath())});
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("error deleting {}", new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)dbFile.getPath())});
                }
                options.createIfMissing(true);
                try {
                    tmpDb = JniDBFactory.factory.open(dbFile, options);
                }
                catch (NativeDB.DBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            try {
                LevelDBProvider.checkVersion(tmpDb, version, mapper);
            }
            catch (IOException ioe) {
                tmpDb.close();
                throw ioe;
            }
        }
        return tmpDb;
    }

    @VisibleForTesting
    static DB initLevelDB(File file) throws IOException {
        Options options = new Options();
        options.createIfMissing(true);
        JniDBFactory factory = new JniDBFactory();
        return factory.open(file, options);
    }

    public static void checkVersion(DB db, StoreVersion newversion, ObjectMapper mapper) throws IOException {
        byte[] bytes = db.get(StoreVersion.KEY);
        if (bytes == null) {
            LevelDBProvider.storeVersion(db, newversion, mapper);
        } else {
            StoreVersion version = (StoreVersion)mapper.readValue(bytes, StoreVersion.class);
            if (version.major != newversion.major) {
                throw new IOException("cannot read state DB with version " + String.valueOf(version) + ", incompatible with current version " + String.valueOf(newversion));
            }
            LevelDBProvider.storeVersion(db, newversion, mapper);
        }
    }

    public static void storeVersion(DB db, StoreVersion version, ObjectMapper mapper) throws IOException {
        db.put(StoreVersion.KEY, mapper.writeValueAsBytes((Object)version));
    }

    private static class LevelDBLogger
    implements Logger {
        private static final SparkLogger LOG = SparkLoggerFactory.getLogger(LevelDBLogger.class);

        private LevelDBLogger() {
        }

        public void log(String message) {
            LOG.info(message);
        }
    }
}

