/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.streaming.util.RateLimitedOutputStream;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.collection.SeqLike;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RawTextSender$
implements Logging {
    public static RawTextSender$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RawTextSender$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        Option option;
        int blockSize;
        int port;
        String file;
        block13: {
            String[] stringArray;
            block12: {
                Option option2;
                if (args.length != 4) {
                    System.err.println("Usage: RawTextSender <port> <file> <blockSize> <bytesPerSec>");
                    System.exit(1);
                }
                if ((option2 = Array$.MODULE$.unapplySeq((Object)(stringArray = args))).isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(4) != 0) break block12;
                String string = (String)((SeqLike)option2.get()).apply(0);
                file = (String)((SeqLike)option2.get()).apply(1);
                String string2 = (String)((SeqLike)option2.get()).apply(2);
                String string3 = (String)((SeqLike)option2.get()).apply(3);
                Option option3 = IntParam$.MODULE$.unapply(string);
                if (option3.isEmpty()) break block12;
                port = BoxesRunTime.unboxToInt((Object)option3.get());
                Option option4 = IntParam$.MODULE$.unapply(string2);
                if (option4.isEmpty()) break block12;
                blockSize = BoxesRunTime.unboxToInt((Object)option4.get());
                option = IntParam$.MODULE$.unapply(string3);
                if (!option.isEmpty()) break block13;
            }
            throw new MatchError((Object)stringArray);
        }
        int bytesPerSec = BoxesRunTime.unboxToInt((Object)option.get());
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)port), (Object)file, (Object)BoxesRunTime.boxToInteger((int)blockSize), (Object)BoxesRunTime.boxToInteger((int)bytesPerSec));
        int port2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        String file2 = (String)tuple4._2();
        int blockSize2 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int bytesPerSec2 = BoxesRunTime.unboxToInt((Object)tuple4._4());
        String[] lines = (String[])Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> Source$.MODULE$.fromFile(file2, Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable & scala.Serializable)x$2 -> (String[])x$2.getLines().toArray(ClassTag$.MODULE$.apply(String.class)));
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream(blockSize2 + 1000);
        SerializerInstance ser = new KryoSerializer(new SparkConf()).newInstance();
        SerializationStream serStream = ser.serializeStream((OutputStream)bufferStream);
        int i = 0;
        while (bufferStream.size() < blockSize2) {
            serStream.writeObject((Object)lines[i], ClassTag$.MODULE$.apply(String.class));
            i = (i + 1) % lines.length;
        }
        byte[] array = bufferStream.toByteArray();
        ByteBuffer countBuf = ByteBuffer.wrap(new byte[4]);
        countBuf.putInt(array.length);
        countBuf.flip();
        ServerSocket serverSocket = new ServerSocket(port2);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Listening on port ").append(port2).toString());
        while (true) {
            Socket socket = serverSocket.accept();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got a new connection");
            RateLimitedOutputStream out = new RateLimitedOutputStream(socket.getOutputStream(), bytesPerSec2);
            try {
                try {
                    while (true) {
                        out.write(countBuf.array());
                        out.write(array);
                    }
                }
                catch (IOException e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Client disconnected");
                    continue;
                }
            }
            finally {
                socket.close();
                continue;
            }
            break;
        }
    }

    private RawTextSender$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

