/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import org.apache.spark.sql.execution.arrow.ArrowWriter$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.apache.spark.util.SizeEstimator$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\rrAB(Q\u0011\u0003!FL\u0002\u0004_!\"\u0005Ak\u0018\u0005\u0006Y\u0006!\tA\u001c\u0004\u0006_\u0006\u0001A\u000b\u001d\u0005\u000b\u0003/\u0019!\u0011!Q\u0001\n\u0005e\u0001BCA\u0014\u0007\t\u0005\t\u0015!\u0003\u0002*!Q\u0011QG\u0002\u0003\u0002\u0003\u0006I!a\u000e\t\u0015\u0005u2A!A!\u0002\u0013\ty\u0004\u0003\u0006\u0002P\r\u0011\t\u0011)A\u0005\u0003#B!\"a\u0016\u0004\u0005\u0003\u0005\u000b\u0011BA-\u0011\u0019a7\u0001\"\u0001\u0002b!I\u00111O\u0002C\u0002\u0013E\u0011Q\u000f\u0005\t\u0003\u0017\u001b\u0001\u0015!\u0003\u0002x!I\u0011QR\u0002C\u0002\u0013%\u0011q\u0012\u0005\t\u0003;\u001b\u0001\u0015!\u0003\u0002\u0012\"I\u0011qT\u0002C\u0002\u0013%\u0011\u0011\u0015\u0005\t\u0003W\u001b\u0001\u0015!\u0003\u0002$\"I\u0011QV\u0002C\u0002\u0013E\u0011q\u0016\u0005\t\u0003o\u001b\u0001\u0015!\u0003\u00022\"I\u0011\u0011X\u0002C\u0002\u0013E\u00111\u0018\u0005\t\u0003\u0007\u001c\u0001\u0015!\u0003\u0002>\"9\u0011QY\u0002\u0005B\u0005\u001d\u0007bBAe\u0007\u0011\u0005\u00131\u001a\u0005\b\u0003\u001b\u001cA\u0011IAh\r\u001d\t9.\u0001\u0001U\u00033D!\"a\u0006\u0019\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t9\u0003\u0007B\u0001B\u0003%\u0011\u0011\u0006\u0005\u000b\u0003kA\"\u0011!Q\u0001\n\u0005]\u0002BCAn1\t\u0005\t\u0015!\u0003\u00028!Q\u0011Q\b\r\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005=\u0003D!A!\u0002\u0013\t\t\u0006\u0003\u0006\u0002Xa\u0011\t\u0011)A\u0005\u00033Ba\u0001\u001c\r\u0005\u0002\u0005u\u0007\"CAx1\t\u0007I\u0011BAy\u0011!\t\u0019\u0010\u0007Q\u0001\n\u0005]\u0002\"CA{1\u0001\u0007I\u0011AAy\u0011%\t9\u0010\u0007a\u0001\n\u0003\tI\u0010\u0003\u0005\u0002\u0000b\u0001\u000b\u0015BA\u001c\u0011\u001d\tI\r\u0007C!\u0003\u0017D\u0001B!\u0001\u0002\t\u0003!&1\u0001\u0005\t\u0005#\tA\u0011\u0001+\u0003\u0014!A!\u0011E\u0001\u0005\u0002Q\u0013\u0019C\u0002\u0005\u0003,\u0005\t\t\u0001\u0016B\u0017\u0011%\u0011yC\u000bB\u0001B\u0003%\u0011\u000f\u0003\u0006\u0002X)\u0012\t\u0011)A\u0005\u00033Ba\u0001\u001c\u0016\u0005\u0002\tE\u0002\"\u0003B\u001dU\t\u0007I\u0011\u0001B\u001e\u0011!\u0011iE\u000bQ\u0001\n\tu\u0002\"CAGU\t\u0007I\u0011CAH\u0011!\tiJ\u000bQ\u0001\n\u0005E\u0005\"\u0003B(U\u0001\u0007I\u0011\u0002B)\u0011%\u0011IF\u000ba\u0001\n\u0013\u0011Y\u0006\u0003\u0005\u0003`)\u0002\u000b\u0015\u0002B*\u0011%\t9C\u000bb\u0001\n\u0003\u0011\t\u0007\u0003\u0005\u0003d)\u0002\u000b\u0011BA\u0015\u0011\u001d\t)M\u000bC!\u0003\u000fDq!!3+\t\u0003\u0012)\u0007C\u0004\u0003h)2\tA!\u001b\u0007\u000f\t-\u0014\u0001\u0001+\u0003n!I!q\u0006\u001e\u0003\u0002\u0003\u0006I!\u001d\u0005\u000b\u0003OQ$\u0011!Q\u0001\n\u0005%\u0002BCA\u001fu\t\u0005\t\u0015!\u0003\u0002@!Q\u0011q\n\u001e\u0003\u0002\u0003\u0006I!!\u0015\t\u0015\u0005]#H!A!\u0002\u0013\tI\u0006\u0003\u0004mu\u0011\u0005!q\u000e\u0005\b\u0005ORD\u0011\tB5\r\u001d\u0011i(\u0001\u0001U\u0005\u007fB\u0011Ba\fC\u0005\u0003\u0005\u000b\u0011B9\t\u0015\u0005]#I!A!\u0002\u0013\tI\u0006\u0003\u0004m\u0005\u0012\u0005!\u0011\u0011\u0005\b\u0005O\u0012E\u0011\tB5\u0011!\u0011I)\u0001C\u0001)\n-\u0005\u0002\u0003BL\u0003\u0011\u0005AK!'\t\u000f\t}\u0015\u0001\"\u0003\u0003\"\"A!QU\u0001\u0005\u0002A\u00139\u000bC\u0004\u0003@\u0006!\tA!1\t\u0011\tM\u0018\u0001\"\u0001U\u0005kD\u0001B!@\u0002\t\u0003!&q \u0005\b\u0007+\tA\u0011BB\f\u0003=\t%O]8x\u0007>tg/\u001a:uKJ\u001c(BA)S\u0003\u0015\t'O]8x\u0015\t\u0019F+A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QKV\u0001\u0004gFd'BA,Y\u0003\u0015\u0019\b/\u0019:l\u0015\tI&,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0006\u0019qN]4\u0011\u0005u\u000bQ\"\u0001)\u0003\u001f\u0005\u0013(o\\<D_:4XM\u001d;feN\u001c2!\u00011g!\t\tG-D\u0001c\u0015\u0005\u0019\u0017!B:dC2\f\u0017BA3c\u0005\u0019\te.\u001f*fMB\u0011qM[\u0007\u0002Q*\u0011\u0011NV\u0001\tS:$XM\u001d8bY&\u00111\u000e\u001b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001/\u0003%\u0005\u0013(o\\<CCR\u001c\u0007.\u0013;fe\u0006$xN]\n\u0006\u0007\u0001\f\u0018q\u0001\t\u0004ejlhBA:y\u001d\t!x/D\u0001v\u0015\t1X.\u0001\u0004=e>|GOP\u0005\u0002G&\u0011\u0011PY\u0001\ba\u0006\u001c7.Y4f\u0013\tYHP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\tI(\r\u0005\u0003b}\u0006\u0005\u0011BA@c\u0005\u0015\t%O]1z!\r\t\u00171A\u0005\u0004\u0003\u000b\u0011'\u0001\u0002\"zi\u0016\u0004B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0003mC:<'BAA\t\u0003\u0011Q\u0017M^1\n\t\u0005U\u00111\u0002\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\u0002\u000fI|w/\u0013;feB!!O_A\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011)\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002&\u0005}!aC%oi\u0016\u0014h.\u00197S_^\faa]2iK6\f\u0007\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=B+A\u0003usB,7/\u0003\u0003\u00024\u00055\"AC*ueV\u001cG\u000fV=qK\u0006\u0011R.\u0019=SK\u000e|'\u000fZ:QKJ\u0014\u0015\r^2i!\r\t\u0017\u0011H\u0005\u0004\u0003w\u0011'\u0001\u0002'p]\u001e\f!\u0002^5nKj{g.Z%e!\u0011\t\t%!\u0013\u000f\t\u0005\r\u0013Q\t\t\u0003i\nL1!a\u0012c\u0003\u0019\u0001&/\u001a3fM&!\u00111JA'\u0005\u0019\u0019FO]5oO*\u0019\u0011q\t2\u00027\u0015\u0014(o\u001c:P]\u0012+\b\u000f\\5dCR,GMR5fY\u0012t\u0015-\\3t!\r\t\u00171K\u0005\u0004\u0003+\u0012'a\u0002\"p_2,\u0017M\\\u0001\bG>tG/\u001a=u!\u0011\tY&!\u0018\u000e\u0003YK1!a\u0018W\u0005-!\u0016m]6D_:$X\r\u001f;\u0015\u001d\u0005\r\u0014qMA5\u0003W\ni'a\u001c\u0002rA\u0019\u0011QM\u0002\u000e\u0003\u0005Aq!a\u0006\u000b\u0001\u0004\tI\u0002C\u0004\u0002()\u0001\r!!\u000b\t\u000f\u0005U\"\u00021\u0001\u00028!9\u0011Q\b\u0006A\u0002\u0005}\u0002bBA(\u0015\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003/R\u0001\u0019AA-\u0003-\t'O]8x'\u000eDW-\\1\u0016\u0005\u0005]\u0004\u0003BA=\u0003\u000fk!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005a>TwN\u0003\u0003\u00020\u0005\u0005%\u0002BAB\u0003\u000b\u000baA^3di>\u0014(BA)Y\u0013\u0011\tI)a\u001f\u0003\rM\u001b\u0007.Z7b\u00031\t'O]8x'\u000eDW-\\1!\u0003%\tG\u000e\\8dCR|'/\u0006\u0002\u0002\u0012B!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006\u0015\u0015AB7f[>\u0014\u00180\u0003\u0003\u0002\u001c\u0006U%a\u0004\"vM\u001a,'/\u00117m_\u000e\fGo\u001c:\u0002\u0015\u0005dGn\\2bi>\u0014\b%\u0001\u0003s_>$XCAAR!\u0011\t)+a*\u000e\u0005\u0005\u0005\u0015\u0002BAU\u0003\u0003\u0013\u0001CV3di>\u00148k\u00195f[\u0006\u0014vn\u001c;\u0002\u000bI|w\u000e\u001e\u0011\u0002\u0011UtGn\\1eKJ,\"!!-\u0011\t\u0005\u0015\u00161W\u0005\u0005\u0003k\u000b\tI\u0001\bWK\u000e$xN]+oY>\fG-\u001a:\u0002\u0013UtGn\\1eKJ\u0004\u0013aC1se><xK]5uKJ,\"!!0\u0011\u0007u\u000by,C\u0002\u0002BB\u00131\"\u0011:s_^<&/\u001b;fe\u0006a\u0011M\u001d:po^\u0013\u0018\u000e^3sA\u00059\u0001.Y:OKb$XCAA)\u0003\u0011qW\r\u001f;\u0015\u0003u\fQa\u00197pg\u0016$\"!!5\u0011\u0007\u0005\f\u0019.C\u0002\u0002V\n\u0014A!\u00168ji\na\u0012I\u001d:po\n\u000bGo\u00195XSRD7k\u00195f[\u0006LE/\u001a:bi>\u00148c\u0001\r\u0002d\u0005)R.\u0019=FgRLW.\u0019;fI\n\u000bGo\u00195TSj,G\u0003EAp\u0003C\f\u0019/!:\u0002h\u0006%\u00181^Aw!\r\t)\u0007\u0007\u0005\b\u0003/\u0001\u0003\u0019AA\r\u0011\u001d\t9\u0003\ta\u0001\u0003SAq!!\u000e!\u0001\u0004\t9\u0004C\u0004\u0002\\\u0002\u0002\r!a\u000e\t\u000f\u0005u\u0002\u00051\u0001\u0002@!9\u0011q\n\u0011A\u0002\u0005E\u0003bBA,A\u0001\u0007\u0011\u0011L\u0001\u0010CJ\u0014xn^*dQ\u0016l\u0017mU5{KV\u0011\u0011qG\u0001\u0011CJ\u0014xn^*dQ\u0016l\u0017mU5{K\u0002\n1C]8x\u0007>,h\u000e^%o\u0019\u0006\u001cHOQ1uG\"\fqC]8x\u0007>,h\u000e^%o\u0019\u0006\u001cHOQ1uG\"|F%Z9\u0015\t\u0005E\u00171 \u0005\n\u0003{$\u0013\u0011!a\u0001\u0003o\t1\u0001\u001f\u00132\u0003Q\u0011xn^\"pk:$\u0018J\u001c'bgR\u0014\u0015\r^2iA\u0005yAo\u001c\"bi\u000eD\u0017\n^3sCR|'\u000f\u0006\b\u0002d\t\u0015!q\u0001B\u0005\u0005\u0017\u0011iAa\u0004\t\u000f\u0005]q\u00051\u0001\u0002\u001a!9\u0011qE\u0014A\u0002\u0005%\u0002bBA\u001bO\u0001\u0007\u0011q\u0007\u0005\b\u0003{9\u0003\u0019AA \u0011\u001d\tye\na\u0001\u0003#Bq!a\u0016(\u0001\u0004\tI&A\ru_\n\u000bGo\u00195XSRD7k\u00195f[\u0006LE/\u001a:bi>\u0014HCDAp\u0005+\u00119B!\u0007\u0003\u001c\tu!q\u0004\u0005\b\u0003/A\u0003\u0019AA\r\u0011\u001d\t9\u0003\u000ba\u0001\u0003SAq!!\u000e)\u0001\u0004\t9\u0004C\u0004\u0002\\\"\u0002\r!a\u000e\t\u000f\u0005u\u0002\u00061\u0001\u0002@!9\u0011q\n\u0015A\u0002\u0005E\u0013!F2sK\u0006$X-R7qif\f%O]8x\u0005\u0006$8\r\u001b\u000b\b{\n\u0015\"q\u0005B\u0015\u0011\u001d\t9#\u000ba\u0001\u0003SAq!!\u0010*\u0001\u0004\ty\u0004C\u0004\u0002P%\u0002\r!!\u0015\u0003'%sG/\u001a:oC2\u0014vn^%uKJ\fGo\u001c:\u0014\t)\u0002\u0017\u0011D\u0001\u000fCJ\u0014xn\u001e\"bi\u000eD\u0017\n^3s)\u0019\u0011\u0019D!\u000e\u00038A\u0019\u0011Q\r\u0016\t\r\t=R\u00061\u0001r\u0011\u001d\t9&\fa\u0001\u00033\n\u0011B]3t_V\u00148-Z:\u0016\u0005\tu\u0002C\u0002B \u0005\u0013\n9!\u0004\u0002\u0003B)!!1\tB#\u0003\u001diW\u000f^1cY\u0016T1Aa\u0012c\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0017\u0012\tEA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018A\u0003:fg>,(oY3tA\u0005\u0001\"o\\<Ji\u0016\u0014\u0018I\u001c3TG\",W.Y\u000b\u0003\u0005'\u0002r!\u0019B+\u00033\tI#C\u0002\u0003X\t\u0014a\u0001V;qY\u0016\u0014\u0014\u0001\u0006:po&#XM]!oIN\u001b\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0003\u0002R\nu\u0003\"CA\u007fg\u0005\u0005\t\u0019\u0001B*\u0003E\u0011xn^%uKJ\fe\u000eZ*dQ\u0016l\u0017\rI\u000b\u0003\u0003S\tqa]2iK6\f\u0007\u0005\u0006\u0002\u0002\u001c\u0005Ia.\u001a=u\u0005\u0006$8\r\u001b\u000b\u0003\u0005'\u0012\u0001%\u00138uKJt\u0017\r\u001c*po&#XM]1u_J<\u0016\u000e\u001e5pkR\u001c6\r[3nCN\u0019!Ha\r\u0015\u0019\tE$1\u000fB;\u0005o\u0012IHa\u001f\u0011\u0007\u0005\u0015$\b\u0003\u0004\u00030\u0001\u0003\r!\u001d\u0005\b\u0003O\u0001\u0005\u0019AA\u0015\u0011\u001d\ti\u0004\u0011a\u0001\u0003\u007fAq!a\u0014A\u0001\u0004\t\t\u0006C\u0004\u0002X\u0001\u0003\r!!\u0017\u0003;%sG/\u001a:oC2\u0014vn^%uKJ\fGo\u001c:XSRD7k\u00195f[\u0006\u001c2A\u0011B\u001a)\u0019\u0011\u0019I!\"\u0003\bB\u0019\u0011Q\r\"\t\r\t=R\t1\u0001r\u0011\u001d\t9&\u0012a\u0001\u00033\n\u0011C\u001a:p[\n\u000bGo\u00195Ji\u0016\u0014\u0018\r^8s)1\tIB!$\u0003\u0010\nE%1\u0013BK\u0011\u0019\u0011yc\u0012a\u0001c\"9\u0011qE$A\u0002\u0005%\u0002bBA\u001f\u000f\u0002\u0007\u0011q\b\u0005\b\u0003\u001f:\u0005\u0019AA)\u0011\u001d\t9f\u0012a\u0001\u00033\n1D\u001a:p[\n\u000bGo\u00195XSRD7k\u00195f[\u0006LE/\u001a:bi>\u0014HC\u0002B*\u00057\u0013i\n\u0003\u0004\u00030!\u0003\r!\u001d\u0005\b\u0003/B\u0005\u0019AA-\u0003Y1Xm\u0019;peN\u001b\u0007.Z7b%>|G\u000fV8Ji\u0016\u0014H\u0003BA\r\u0005GCq!a(J\u0001\u0004\t\u0019+A\u0005m_\u0006$')\u0019;dQR1!\u0011\u0016B]\u0005{\u0003BAa+\u000366\u0011!Q\u0016\u0006\u0005\u0005_\u0013\t,A\u0004nKN\u001c\u0018mZ3\u000b\t\tM\u0016\u0011Q\u0001\u0004SB\u001c\u0017\u0002\u0002B\\\u0005[\u0013\u0001#\u0011:s_^\u0014VmY8sI\n\u000bGo\u00195\t\r\tm&\n1\u0001~\u0003)\u0011\u0017\r^2i\u0005f$Xm\u001d\u0005\b\u0003\u001bS\u0005\u0019AAI\u0003-!x\u000eR1uC\u001a\u0013\u0018-\\3\u0015\u0011\t\r'q\u001cBr\u0005O\u0004BA!2\u0003Z:!!q\u0019Bl\u001d\u0011\u0011IM!6\u000f\t\t-'1\u001b\b\u0005\u0005\u001b\u0014\tND\u0002u\u0005\u001fL\u0011aW\u0005\u00033jK!a\u0016-\n\u0005U3\u0016BA=U\u0013\u0011\u0011YN!8\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA=U\u0011\u0019\u0011\to\u0013a\u0001c\u0006a\u0011M\u001d:po\n\u000bGo\u00195fg\"9!Q]&A\u0002\u0005}\u0012\u0001D:dQ\u0016l\u0017m\u0015;sS:<\u0007b\u0002Bu\u0017\u0002\u0007!1^\u0001\bg\u0016\u001c8/[8o!\u0011\u0011iOa<\u000e\u0003QK1A!=U\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003]\u0011X-\u00193BeJ|wo\u0015;sK\u0006lgI]8n\r&dW\r\u0006\u0003\u0003x\ne\bcA1\u007f{\"9!1 'A\u0002\u0005}\u0012\u0001\u00034jY\u0016t\u0017-\\3\u0002)\u001d,GOQ1uG\",7O\u0012:p[N#(/Z1n)\r\t8\u0011\u0001\u0005\b\u0007\u0007i\u0005\u0019AB\u0003\u0003\tIg\u000e\u0005\u0003\u0004\b\rEQBAB\u0005\u0015\u0011\u0019Ya!\u0004\u0002\u0011\rD\u0017M\u001c8fYNTAaa\u0004\u0002\u0010\u0005\u0019a.[8\n\t\rM1\u0011\u0002\u0002\u0014%\u0016\fG-\u00192mK\nKH/Z\"iC:tW\r\\\u0001\tG2|7/Z!mYR!\u0011\u0011[B\r\u0011\u001d\u0019YB\u0014a\u0001\u0007;\t!b\u00197pg\u0016\f'\r\\3t!\u0015\t7qDA\u0004\u0013\r\u0019\tC\u0019\u0002\u000byI,\u0007/Z1uK\u0012t\u0004")
public final class ArrowConverters {
    public static Dataset<Row> toDataFrame(Iterator<byte[]> iterator, String string, SparkSession sparkSession) {
        return ArrowConverters$.MODULE$.toDataFrame(iterator, string, sparkSession);
    }

    public static class ArrowBatchIterator
    implements Iterator<byte[]>,
    AutoCloseable {
        private final Iterator<InternalRow> rowIter;
        private final long maxRecordsPerBatch;
        private final Schema arrowSchema;
        private final BufferAllocator allocator;
        private final VectorSchemaRoot root;
        private final VectorUnloader unloader;
        private final ArrowWriter arrowWriter;

        public Iterator<byte[]> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<byte[]> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<byte[]> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<byte[]> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<byte[]> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<byte[], B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<byte[]> filter(Function1<byte[], Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<byte[], U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<byte[], Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<byte[], Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<byte[]> find(Function1<byte[], Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<byte[], Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<byte[], Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<byte[]> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<byte[]> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<byte[]> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<byte[]> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<byte[]> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<byte[], Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<byte[], B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, byte[], B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<byte[], B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<byte[]> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<byte[]> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<byte[]> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<byte[]> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<byte[]> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        public Schema arrowSchema() {
            return this.arrowSchema;
        }

        private BufferAllocator allocator() {
            return this.allocator;
        }

        private VectorSchemaRoot root() {
            return this.root;
        }

        public VectorUnloader unloader() {
            return this.unloader;
        }

        public ArrowWriter arrowWriter() {
            return this.arrowWriter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            if (this.rowIter.hasNext()) return true;
            this.close();
            if (!false) return false;
            return true;
        }

        public byte[] next() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
            Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                for (long rowCount = 0L; $this.rowIter.hasNext() && ($this.maxRecordsPerBatch <= 0L || rowCount < $this.maxRecordsPerBatch); ++rowCount) {
                    InternalRow row = (InternalRow)$this.rowIter.next();
                    this.arrowWriter().write(row);
                }
                this.arrowWriter().finish();
                ArrowRecordBatch batch = this.unloader().getRecordBatch();
                MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
                batch.close();
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.arrowWriter().reset());
            return out.toByteArray();
        }

        @Override
        public void close() {
            this.root().close();
            this.allocator().close();
        }

        public ArrowBatchIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
            this.rowIter = rowIter;
            this.maxRecordsPerBatch = maxRecordsPerBatch;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema, timeZoneId, errorOnDuplicatedFieldNames, ArrowUtils$.MODULE$.toArrowSchema$default$4());
            this.allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator(new java.lang.StringBuilder(2).append("to").append(this.getClass().getSimpleName()).toString(), 0L, Long.MAX_VALUE);
            this.root = VectorSchemaRoot.create((Schema)this.arrowSchema(), (BufferAllocator)this.allocator());
            this.unloader = new VectorUnloader(this.root());
            this.arrowWriter = ArrowWriter$.MODULE$.create(this.root());
            Option$.MODULE$.apply((Object)context).foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
                this.close();
                return BoxedUnit.UNIT;
            }));
        }
    }

    public static class ArrowBatchWithSchemaIterator
    extends ArrowBatchIterator {
        private final Iterator<InternalRow> rowIter;
        private final long maxRecordsPerBatch;
        private final long maxEstimatedBatchSize;
        private final long arrowSchemaSize;
        private long rowCountInLastBatch;

        private long arrowSchemaSize() {
            return this.arrowSchemaSize;
        }

        public long rowCountInLastBatch() {
            return this.rowCountInLastBatch;
        }

        public void rowCountInLastBatch_$eq(long x$1) {
            this.rowCountInLastBatch = x$1;
        }

        @Override
        public byte[] next() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(out));
            this.rowCountInLastBatch_$eq(0L);
            LongRef estimatedBatchSize = LongRef.create((long)this.arrowSchemaSize());
            Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MessageSerializer.serialize((WriteChannel)writeChannel, (Schema)this.arrowSchema());
                while ($this.rowIter.hasNext() && (this.rowCountInLastBatch() == 0L && $this.maxEstimatedBatchSize > 0L || !this.isBatchSizeLimitExceeded$1(estimatedBatchSize) && !this.isRecordLimitExceeded$1())) {
                    long l;
                    InternalRow row = (InternalRow)$this.rowIter.next();
                    this.arrowWriter().write(row);
                    long l2 = estimatedBatchSize$1.elem;
                    InternalRow internalRow = row;
                    if (internalRow instanceof UnsafeRow) {
                        UnsafeRow unsafeRow = (UnsafeRow)internalRow;
                        l = unsafeRow.getSizeInBytes();
                    } else if (internalRow != null) {
                        InternalRow internalRow2 = internalRow;
                        l = internalRow2.numFields() * 16;
                    } else {
                        throw new MatchError((Object)internalRow);
                    }
                    estimatedBatchSize$1.elem = l2 + l;
                    this.rowCountInLastBatch_$eq(this.rowCountInLastBatch() + 1L);
                }
                this.arrowWriter().finish();
                ArrowRecordBatch batch = this.unloader().getRecordBatch();
                MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
                ArrowStreamWriter.writeEndOfStream((WriteChannel)writeChannel, (IpcOption)IpcOption.DEFAULT);
                batch.close();
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.arrowWriter().reset());
            return out.toByteArray();
        }

        private final boolean isBatchSizeLimitExceeded$1(LongRef estimatedBatchSize$1) {
            return this.maxEstimatedBatchSize > 0L && estimatedBatchSize$1.elem >= this.maxEstimatedBatchSize;
        }

        private final boolean isRecordLimitExceeded$1() {
            return this.maxRecordsPerBatch > 0L && this.rowCountInLastBatch() >= this.maxRecordsPerBatch;
        }

        public ArrowBatchWithSchemaIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, long maxEstimatedBatchSize, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
            this.rowIter = rowIter;
            this.maxRecordsPerBatch = maxRecordsPerBatch;
            this.maxEstimatedBatchSize = maxEstimatedBatchSize;
            super(rowIter, schema, maxRecordsPerBatch, timeZoneId, errorOnDuplicatedFieldNames, context);
            this.arrowSchemaSize = SizeEstimator$.MODULE$.estimate((Object)this.arrowSchema());
            this.rowCountInLastBatch = 0L;
        }
    }

    public static abstract class InternalRowIterator
    implements Iterator<InternalRow> {
        private final Iterator<byte[]> arrowBatchIter;
        private final ArrayBuffer<AutoCloseable> resources;
        private final BufferAllocator allocator;
        private Tuple2<Iterator<InternalRow>, StructType> rowIterAndSchema;
        private final StructType schema;

        public Iterator<InternalRow> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<InternalRow> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<InternalRow> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<InternalRow> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<InternalRow> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<InternalRow, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<InternalRow, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<InternalRow, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<InternalRow, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<InternalRow> find(Function1<InternalRow, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<InternalRow, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<InternalRow, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<InternalRow> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<InternalRow> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<InternalRow> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<InternalRow> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<InternalRow> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<InternalRow, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<InternalRow, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<InternalRow> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<InternalRow> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<InternalRow> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<InternalRow> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<InternalRow> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<InternalRow, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        public ArrayBuffer<AutoCloseable> resources() {
            return this.resources;
        }

        public BufferAllocator allocator() {
            return this.allocator;
        }

        private Tuple2<Iterator<InternalRow>, StructType> rowIterAndSchema() {
            return this.rowIterAndSchema;
        }

        private void rowIterAndSchema_$eq(Tuple2<Iterator<InternalRow>, StructType> x$1) {
            this.rowIterAndSchema = x$1;
        }

        public StructType schema() {
            return this.schema;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            if (((Iterator)this.rowIterAndSchema()._1()).hasNext()) return true;
            if (this.arrowBatchIter.hasNext()) {
                this.rowIterAndSchema_$eq(this.nextBatch());
                StructType structType = this.schema();
                Object object = this.rowIterAndSchema()._2();
                if (structType == null ? object != null : !structType.equals(object)) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(66).append("ArrowBatch iterator contain 2 batches with").append(" different schema: ").append(this.schema()).append(" and ").append(this.rowIterAndSchema()._2()).toString());
                }
            } else {
                ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll((Seq<AutoCloseable>)((Seq)this.resources().toSeq().reverse()));
                if (!false) return false;
                return true;
            }
            if (((Iterator)this.rowIterAndSchema()._1()).hasNext()) return true;
            return false;
        }

        public InternalRow next() {
            return (InternalRow)((Iterator)this.rowIterAndSchema()._1()).next();
        }

        public abstract Tuple2<Iterator<InternalRow>, StructType> nextBatch();

        public InternalRowIterator(Iterator<byte[]> arrowBatchIter, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.resources = new ArrayBuffer();
            this.allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator(new java.lang.StringBuilder(2).append("to").append(this.getClass().getSimpleName()).toString(), 0L, Long.MAX_VALUE);
            this.resources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{this.allocator()}));
            this.rowIterAndSchema = arrowBatchIter.hasNext() ? this.nextBatch() : new Tuple2((Object)package$.MODULE$.Iterator().empty(), null);
            this.schema = (StructType)this.rowIterAndSchema()._2();
            Object object = context != null ? context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll((Seq<AutoCloseable>)((Seq)this.resources().toSeq().reverse()));
                return BoxedUnit.UNIT;
            }) : BoxedUnit.UNIT;
        }
    }

    public static class InternalRowIteratorWithSchema
    extends InternalRowIterator {
        private final Iterator<byte[]> arrowBatchIter;

        @Override
        public Tuple2<Iterator<InternalRow>, StructType> nextBatch() {
            ArrowStreamReader reader = new ArrowStreamReader((InputStream)new ByteArrayInputStream((byte[])this.arrowBatchIter.next()), this.allocator());
            VectorSchemaRoot root = reader.loadNextBatch() ? reader.getVectorSchemaRoot() : null;
            this.resources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{reader, root}));
            if (root == null) {
                return new Tuple2((Object)package$.MODULE$.Iterator().empty(), null);
            }
            return new Tuple2(ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(root), (Object)ArrowUtils$.MODULE$.fromArrowSchema(root.getSchema()));
        }

        public InternalRowIteratorWithSchema(Iterator<byte[]> arrowBatchIter, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            super(arrowBatchIter, context);
        }
    }

    public static class InternalRowIteratorWithoutSchema
    extends InternalRowIterator {
        private final Iterator<byte[]> arrowBatchIter;
        private final StructType schema;
        private final String timeZoneId;
        private final boolean errorOnDuplicatedFieldNames;

        @Override
        public Tuple2<Iterator<InternalRow>, StructType> nextBatch() {
            Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(this.schema, this.timeZoneId, this.errorOnDuplicatedFieldNames, ArrowUtils$.MODULE$.toArrowSchema$default$4());
            VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)this.allocator());
            this.resources().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{root}));
            ArrowRecordBatch arrowRecordBatch = ArrowConverters$.MODULE$.loadBatch((byte[])this.arrowBatchIter.next(), this.allocator());
            VectorLoader vectorLoader = new VectorLoader(root);
            vectorLoader.load(arrowRecordBatch);
            arrowRecordBatch.close();
            return new Tuple2(ArrowConverters$.MODULE$.org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(root), (Object)this.schema);
        }

        public InternalRowIteratorWithoutSchema(Iterator<byte[]> arrowBatchIter, StructType schema, String timeZoneId, boolean errorOnDuplicatedFieldNames, TaskContext context) {
            this.arrowBatchIter = arrowBatchIter;
            this.schema = schema;
            this.timeZoneId = timeZoneId;
            this.errorOnDuplicatedFieldNames = errorOnDuplicatedFieldNames;
            super(arrowBatchIter, context);
        }
    }
}

