/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.rewrite;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.rewrite.MaskMode;

public class RewriteOptions {
    final Configuration conf;
    final List<Path> inputFiles;
    final Path outputFile;
    final List<String> pruneColumns;
    final CompressionCodecName newCodecName;
    final Map<String, MaskMode> maskColumns;
    final List<String> encryptColumns;
    final FileEncryptionProperties fileEncryptionProperties;

    private RewriteOptions(Configuration conf, List<Path> inputFiles, Path outputFile, List<String> pruneColumns, CompressionCodecName newCodecName, Map<String, MaskMode> maskColumns, List<String> encryptColumns, FileEncryptionProperties fileEncryptionProperties) {
        this.conf = conf;
        this.inputFiles = inputFiles;
        this.outputFile = outputFile;
        this.pruneColumns = pruneColumns;
        this.newCodecName = newCodecName;
        this.maskColumns = maskColumns;
        this.encryptColumns = encryptColumns;
        this.fileEncryptionProperties = fileEncryptionProperties;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public List<Path> getInputFiles() {
        return this.inputFiles;
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    public List<String> getPruneColumns() {
        return this.pruneColumns;
    }

    public CompressionCodecName getNewCodecName() {
        return this.newCodecName;
    }

    public Map<String, MaskMode> getMaskColumns() {
        return this.maskColumns;
    }

    public List<String> getEncryptColumns() {
        return this.encryptColumns;
    }

    public FileEncryptionProperties getFileEncryptionProperties() {
        return this.fileEncryptionProperties;
    }

    public static class Builder {
        private Configuration conf;
        private List<Path> inputFiles;
        private Path outputFile;
        private List<String> pruneColumns;
        private CompressionCodecName newCodecName;
        private Map<String, MaskMode> maskColumns;
        private List<String> encryptColumns;
        private FileEncryptionProperties fileEncryptionProperties;

        public Builder(Configuration conf, Path inputFile, Path outputFile) {
            this.conf = conf;
            this.inputFiles = Arrays.asList(inputFile);
            this.outputFile = outputFile;
        }

        public Builder(Configuration conf, List<Path> inputFiles, Path outputFile) {
            this.conf = conf;
            this.inputFiles = inputFiles;
            this.outputFile = outputFile;
        }

        public Builder prune(List<String> columns) {
            this.pruneColumns = columns;
            return this;
        }

        public Builder transform(CompressionCodecName newCodecName) {
            this.newCodecName = newCodecName;
            return this;
        }

        public Builder mask(Map<String, MaskMode> maskColumns) {
            this.maskColumns = maskColumns;
            return this;
        }

        public Builder encrypt(List<String> encryptColumns) {
            this.encryptColumns = encryptColumns;
            return this;
        }

        public Builder encryptionProperties(FileEncryptionProperties fileEncryptionProperties) {
            this.fileEncryptionProperties = fileEncryptionProperties;
            return this;
        }

        public Builder addInputFile(Path path) {
            this.inputFiles.add(path);
            return this;
        }

        public RewriteOptions build() {
            Preconditions.checkArgument((this.inputFiles != null && !this.inputFiles.isEmpty() ? 1 : 0) != 0, (String)"Input file is required");
            Preconditions.checkArgument((this.outputFile != null ? 1 : 0) != 0, (String)"Output file is required");
            if (this.pruneColumns != null) {
                if (this.maskColumns != null) {
                    for (String pruneColumn : this.pruneColumns) {
                        Preconditions.checkArgument((!this.maskColumns.containsKey(pruneColumn) ? 1 : 0) != 0, (String)"Cannot prune and mask same column");
                    }
                }
                if (this.encryptColumns != null) {
                    for (String pruneColumn : this.pruneColumns) {
                        Preconditions.checkArgument((!this.encryptColumns.contains(pruneColumn) ? 1 : 0) != 0, (String)"Cannot prune and encrypt same column");
                    }
                }
            }
            if (this.encryptColumns != null && !this.encryptColumns.isEmpty()) {
                Preconditions.checkArgument((this.fileEncryptionProperties != null ? 1 : 0) != 0, (String)"FileEncryptionProperties is required when encrypting columns");
            }
            if (this.fileEncryptionProperties != null) {
                Preconditions.checkArgument((this.encryptColumns != null && !this.encryptColumns.isEmpty() ? 1 : 0) != 0, (String)"Encrypt columns is required when FileEncryptionProperties is set");
            }
            return new RewriteOptions(this.conf, this.inputFiles, this.outputFile, this.pruneColumns, this.newCodecName, this.maskColumns, this.encryptColumns, this.fileEncryptionProperties);
        }
    }
}

