/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDD$;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.mllib.rdd.RandomVectorRDD$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\t\u0013\u0001Qa\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u00119\u0002!\u0011!Q\u0001\n=B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001BC\u0002\u0013%1\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003=\u0011!Q\u0005A!b\u0001\n\u0013Y\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000b9\u0003A\u0011A(\t\u000ba\u0003A\u0011I-\t\u000bA\u0004A\u0011K9\b\u0011U\u0014\u0012\u0011!E\u0001)Y4\u0001\"\u0005\n\u0002\u0002#\u0005Ac\u001e\u0005\u0006\u001d6!\tA \u0005\t\u007f6\t\n\u0011\"\u0001\u0002\u0002!I\u0011qC\u0007\u0002\u0002\u0013%\u0011\u0011\u0004\u0002\u0010%\u0006tGm\\7WK\u000e$xN\u001d*E\t*\u00111\u0003F\u0001\u0004e\u0012$'BA\u000b\u0017\u0003\u0015iG\u000e\\5c\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7C\u0001\u0001\u001e!\rq\u0002EI\u0007\u0002?)\u00111CF\u0005\u0003C}\u00111A\u0015#E!\t\u0019c%D\u0001%\u0015\t)C#\u0001\u0004mS:\fGnZ\u0005\u0003O\u0011\u0012aAV3di>\u0014\u0018AA:d\u0007\u0001\u0001\"a\u000b\u0017\u000e\u0003YI!!\f\f\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\tML'0\u001a\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0005\u0019>tw-\u0001\u0006wK\u000e$xN]*ju\u0016\u0004\"\u0001M\u001c\n\u0005a\n$aA%oi\u0006ia.^7QCJ$\u0018\u000e^5p]N\f1A\u001d8h+\u0005a\u0004cA\u001fA\u00056\taH\u0003\u0002@)\u00051!/\u00198e_6L!!\u0011 \u0003'I\u000bg\u000eZ8n\t\u0006$\u0018mR3oKJ\fGo\u001c:\u0011\u0005A\u001a\u0015B\u0001#2\u0005\u0019!u.\u001e2mK\u0006!!O\\4!Q\t1q\t\u0005\u00021\u0011&\u0011\u0011*\r\u0002\niJ\fgn]5f]R\fAa]3fIV\tq&A\u0003tK\u0016$\u0007\u0005\u000b\u0002\t\u000f\u00061A(\u001b8jiz\"r\u0001\u0015*T)V3v\u000b\u0005\u0002R\u00015\t!\u0003C\u0003)\u0013\u0001\u0007!\u0006C\u0003/\u0013\u0001\u0007q\u0006C\u00036\u0013\u0001\u0007a\u0007C\u0003:\u0013\u0001\u0007a\u0007C\u0003;\u0013\u0001\u0007A\bC\u0004K\u0013A\u0005\t\u0019A\u0018\u0002\u000f\r|W\u000e];uKR\u0019!LZ6\u0011\u0007m\u001b'E\u0004\u0002]C:\u0011Q\fY\u0007\u0002=*\u0011q,K\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!AY\u0019\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\t\u0013R,'/\u0019;pe*\u0011!-\r\u0005\u0006O*\u0001\r\u0001[\u0001\bgBd\u0017\u000e^%o!\tY\u0013.\u0003\u0002k-\tI\u0001+\u0019:uSRLwN\u001c\u0005\u0006Y*\u0001\r!\\\u0001\bG>tG/\u001a=u!\tYc.\u0003\u0002p-\tYA+Y:l\u0007>tG/\u001a=u\u000359W\r\u001e)beRLG/[8ogV\t!\u000fE\u00021g\"L!\u0001^\u0019\u0003\u000b\u0005\u0013(/Y=\u0002\u001fI\u000bg\u000eZ8n-\u0016\u001cGo\u001c:S\t\u0012\u0003\"!U\u0007\u0014\u00075A8\u0010\u0005\u00021s&\u0011!0\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Ab\u0018BA?2\u00051\u0019VM]5bY&T\u0018M\u00197f)\u00051\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u0004)\u001aq&!\u0002,\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00052\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tYAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t1qJ\u00196fGR\u0004")
public class RandomVectorRDD
extends RDD<Vector> {
    private final long size;
    private final int vectorSize;
    private final int numPartitions;
    private final transient RandomDataGenerator<Object> rng;
    private final transient long seed;

    public static long $lessinit$greater$default$6() {
        return RandomVectorRDD$.MODULE$.$lessinit$greater$default$6();
    }

    private RandomDataGenerator<Object> rng() {
        return this.rng;
    }

    private long seed() {
        return this.seed;
    }

    public Iterator<Vector> compute(Partition splitIn, TaskContext context) {
        RandomRDDPartition split = (RandomRDDPartition)splitIn;
        return RandomRDD$.MODULE$.getVectorIterator(split, this.vectorSize);
    }

    public Partition[] getPartitions() {
        return RandomRDD$.MODULE$.getPartitions(this.size, this.numPartitions, this.rng(), this.seed());
    }

    public RandomVectorRDD(SparkContext sc, long size, int vectorSize, int numPartitions, RandomDataGenerator<Object> rng, long seed) {
        this.size = size;
        this.vectorSize = vectorSize;
        this.numPartitions = numPartitions;
        this.rng = rng;
        this.seed = seed;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Vector.class));
        Predef$.MODULE$.require(size > 0L, (Function0 & java.io.Serializable & Serializable)() -> "Positive RDD size required.");
        Predef$.MODULE$.require(numPartitions > 0, (Function0 & java.io.Serializable & Serializable)() -> "Positive number of partitions required");
        Predef$.MODULE$.require(vectorSize > 0, (Function0 & java.io.Serializable & Serializable)() -> "Positive vector size required.");
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)size / (double)numPartitions) <= (double)Integer.MAX_VALUE, (Function0 & java.io.Serializable & Serializable)() -> "Partition size cannot exceed Int.MaxValue");
    }
}

