/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.ExecutorFailureTracker;
import org.apache.spark.deploy.ExecutorFailureTracker$;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.Logging;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SparkExitCode$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd\u0001B(Q\u0001uC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005]\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011)\t)\u0001\u0001B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\n\u0003[\u0001!\u0019!C\t\u0003_A\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003\u0013\u0002!\u0019!C\t\u0003_A\u0001\"a\u0013\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003\u001b\u0002!\u0019!C\t\u0003\u001fB\u0001\"!\u0018\u0001A\u0003%\u0011\u0011\u000b\u0005\n\u0003?\u0002!\u0019!C\t\u0003CB\u0001\"!\u001b\u0001A\u0003%\u00111\r\u0005\n\u0003W\u0002!\u0019!C\t\u0003[B\u0001\"a\u001e\u0001A\u0003%\u0011q\u000e\u0005\n\u0003s\u0002!\u0019!C\t\u0003wB\u0001\"!'\u0001A\u0003%\u0011Q\u0010\u0005\n\u00037\u0003!\u0019!C\t\u0003\u001fB\u0001\"!(\u0001A\u0003%\u0011\u0011\u000b\u0005\n\u0003?\u0003!\u0019!C\t\u0003CC\u0001\"!+\u0001A\u0003%\u00111\u0015\u0005\n\u0003W\u0003!\u0019!C\t\u0003\u001fB\u0001\"!,\u0001A\u0003%\u0011\u0011\u000b\u0005\n\u0003_\u0003!\u0019!C\t\u0003\u001fB\u0001\"!-\u0001A\u0003%\u0011\u0011\u000b\u0005\n\u0003g\u0003!\u0019!C\t\u0003CC\u0001\"!.\u0001A\u0003%\u00111\u0015\u0005\n\u0003o\u0003!\u0019!C\t\u0003CC\u0001\"!/\u0001A\u0003%\u00111\u0015\u0005\n\u0003w\u0003!\u0019!C\t\u0003CC\u0001\"!0\u0001A\u0003%\u00111\u0015\u0005\n\u0003\u007f\u0003!\u0019!C\t\u0003\u0003D\u0001\"!7\u0001A\u0003%\u00111\u0019\u0005\n\u00037\u0004!\u0019!C\t\u0003;D\u0001\"!:\u0001A\u0003%\u0011q\u001c\u0005\n\u0003O\u0004!\u0019!C\t\u0003CB\u0001\"!;\u0001A\u0003%\u00111\r\u0005\n\u0003W\u0004!\u0019!C\u0001\u0003[D\u0001B!\u0001\u0001A\u0003%\u0011q\u001e\u0005\n\u0005\u0007\u0001!\u0019!C\t\u0005\u000bA\u0001Ba\u0005\u0001A\u0003%!q\u0001\u0005\n\u0005+\u0001!\u0019!C\t\u0005/A\u0001Ba\u0007\u0001A\u0003%!\u0011\u0004\u0005\n\u0005;\u0001!\u0019!C\t\u0003CB\u0001Ba\b\u0001A\u0003%\u00111\r\u0005\n\u0005C\u0001!\u0019!C\u0001\u0003_A\u0001Ba\t\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0005K\u0001\u0001\u0019!C\t\u0005OA\u0011Ba\f\u0001\u0001\u0004%\tB!\r\t\u0011\tu\u0002\u0001)Q\u0005\u0005SA1Ba\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002B\"Y!\u0011\t\u0001A\u0002\u0003\u0007I\u0011\u0003B\"\u0011-\u00119\u0005\u0001a\u0001\u0002\u0003\u0006K!a1\t\u0013\t%\u0003\u00011A\u0005\u0012\t-\u0003\"\u0003B-\u0001\u0001\u0007I\u0011\u0003B.\u0011!\u0011y\u0006\u0001Q!\n\t5\u0003\"\u0003B5\u0001\u0001\u0007I\u0011\u0002B&\u0011%\u0011Y\u0007\u0001a\u0001\n\u0013\u0011i\u0007\u0003\u0005\u0003r\u0001\u0001\u000b\u0015\u0002B'\u0011%\u0011)\b\u0001b\u0001\n#\u00119\b\u0003\u0005\u0003\u0006\u0002\u0001\u000b\u0011\u0002B=\u0011!\u00119\t\u0001C\t-\u0006=\u0003b\u0002BE\u0001\u0011\u0005!1\u0012\u0005\b\u00057\u0003A\u0011\u0001BO\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WC\u0001B!-\u0001\t\u0003\u0001&1\u0017\u0005\b\u0005s\u0003A\u0011\u0003B^\u0011\u001d\u00119\u000e\u0001C\t\u00053DqAa<\u0001\t#\u0011\t\u0010C\u0004\u0003\u0000\u0002!\tb!\u0001\t\u000f\r]\u0001\u0001\"\u0005\u0004\u001a!91\u0011\u0006\u0001\u0005B\r-r\u0001CB\u0018!\"\u0005ak!\r\u0007\u000f=\u0003\u0006\u0012\u0001,\u00044!9\u00111\u0004'\u0005\u0002\rm\u0002bBB\u001f\u0019\u0012\u00051q\b\u0002\u0016\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s\u0015\t\t&+A\u0002lqMT!a\u0015+\u0002\u000f\rdWo\u001d;fe*\u0011QKV\u0001\ng\u000eDW\rZ;mKJT!a\u0016-\u0002\u000bM\u0004\u0018M]6\u000b\u0005eS\u0016AB1qC\u000eDWMC\u0001\\\u0003\ry'oZ\u0002\u0001'\r\u0001aL\u0019\t\u0003?\u0002l\u0011\u0001U\u0005\u0003CB\u0013Q#\u00112tiJ\f7\r\u001e)pIN\fE\u000e\\8dCR|'\u000f\u0005\u0002dM6\tAM\u0003\u0002f-\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002hI\n9Aj\\4hS:<\u0017\u0001B2p]\u001a\u0004\"A[6\u000e\u0003YK!\u0001\u001c,\u0003\u0013M\u0003\u0018M]6D_:4\u0017AB:fG6;'\u000f\u0005\u0002k_&\u0011\u0001O\u0016\u0002\u0010'\u0016\u001cWO]5us6\u000bg.Y4fe\u0006yQ\r_3dkR|'OQ;jY\u0012,'\u000f\u0005\u0002`g&\u0011A\u000f\u0015\u0002\u001a\u0017V\u0014WM\u001d8fi\u0016\u001cX\t_3dkR|'OQ;jY\u0012,'/\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u0019q/!\u0001\u000e\u0003aT!!\u001f>\u0002\r\rd\u0017.\u001a8u\u0015\tYH0\u0001\u0006lk\n,'O\\3uKNT!! @\u0002\u000f\u0019\f'M]5dq)\tq0\u0001\u0002j_&\u0019\u00111\u0001=\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u0004?\u0006%\u0011bAA\u0006!\nQR\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\u001c8\u000b^8sK\u0006)1\r\\8dWB!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016Y\u000bA!\u001e;jY&!\u0011\u0011DA\n\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Qq\u0011qDA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0002CA0\u0001\u0011\u0015Aw\u00011\u0001j\u0011\u0015iw\u00011\u0001o\u0011\u0015\tx\u00011\u0001s\u0011\u0015)x\u00011\u0001w\u0011\u001d\t)a\u0002a\u0001\u0003\u000fAq!!\u0004\b\u0001\u0004\ty!A\nF1\u0016\u001bU\u000bV(S?&#ulQ(V\u001dR+%+\u0006\u0002\u00022A!\u00111GA\"\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012AB1u_6L7M\u0003\u0003\u0002<\u0005u\u0012AC2p]\u000e,(O]3oi*!\u0011QCA \u0015\t\t\t%\u0001\u0003kCZ\f\u0017\u0002BA#\u0003k\u0011Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018\u0001F#Y\u000b\u000e+Fk\u0014*`\u0013\u0012{6iT+O)\u0016\u0013\u0006%A\u0006Q-\u000e{6iT+O)\u0016\u0013\u0016\u0001\u0004)W\u0007~\u001bu*\u0016(U\u000bJ\u0003\u0013aB7bqB36i]\u000b\u0003\u0003#\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0003\u0003/\nQa]2bY\u0006LA!a\u0017\u0002V\t\u0019\u0011J\u001c;\u0002\u00115\f\u0007\u0010\u0015,Dg\u0002\nQ\u0002]8e\u00032dwnY(o!Z\u001bUCAA2!\u0011\t\u0019&!\u001a\n\t\u0005\u001d\u0014Q\u000b\u0002\b\u0005>|G.Z1o\u00039\u0001x\u000eZ!mY>\u001cwJ\u001c)W\u0007\u0002\n!\u0006^8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o\u001d)feJ+7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE-\u0006\u0002\u0002pAA\u0011\u0011OA:\u0003#\n\t&\u0004\u0002\u0002:%!\u0011QOA\u001d\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r]\u0001,i>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sgB+'OU3t_V\u00148-\u001a)s_\u001aLG.Z%eA\u0005)\"\u000f]%e)>\u0014Vm]8ve\u000e,\u0007K]8gS2,WCAA?!!\ty(!#\u0002R\u00055UBAAA\u0015\u0011\t\u0019)!\"\u0002\u000f5,H/\u00192mK*!\u0011qQA+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b\tIA\u0004ICNDW*\u00199\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#S1!a%W\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BAL\u0003#\u0013qBU3t_V\u00148-\u001a)s_\u001aLG.Z\u0001\u0017eBLE\rV8SKN|WO]2f!J|g-\u001b7fA\u0005\t\u0002o\u001c3BY2|7-\u0019;j_:\u001c\u0016N_3\u0002%A|G-\u00117m_\u000e\fG/[8o'&TX\rI\u0001\u0013a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u00170\u0006\u0002\u0002$B!\u00111KAS\u0013\u0011\t9+!\u0016\u0003\t1{gnZ\u0001\u0014a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8EK2\f\u0017\u0010I\u0001\u000f[\u0006D\b+\u001a8eS:<\u0007k\u001c3t\u0003=i\u0017\r\u001f)f]\u0012Lgn\u001a)pIN\u0004\u0013AF7bq:+X.\u0012=fGV$xN\u001d$bS2,(/Z:\u0002/5\f\u0007PT;n\u000bb,7-\u001e;pe\u001a\u000b\u0017\u000e\\;sKN\u0004\u0013A\u00059pI\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\f1\u0003]8e\u0007J,\u0017\r^5p]RKW.Z8vi\u0002\n\u0011\u0004\u001a:jm\u0016\u0014\bk\u001c3SK\u0006$\u0017N\\3tgRKW.Z8vi\u0006QBM]5wKJ\u0004v\u000e\u001a*fC\u0012Lg.Z:t)&lWm\\;uA\u0005\u0019R\r_3dkR|'/\u00133mKRKW.Z8vi\u0006!R\r_3dkR|'/\u00133mKRKW.Z8vi\u0002\n\u0011B\\1nKN\u0004\u0018mY3\u0016\u0005\u0005\r\u0007\u0003BAc\u0003'tA!a2\u0002PB!\u0011\u0011ZA+\u001b\t\tYMC\u0002\u0002Nr\u000ba\u0001\u0010:p_Rt\u0014\u0002BAi\u0003+\na\u0001\u0015:fI\u00164\u0017\u0002BAk\u0003/\u0014aa\u0015;sS:<'\u0002BAi\u0003+\n!B\\1nKN\u0004\u0018mY3!\u0003]YWOY3s]\u0016$Xm\u001d#sSZ,'\u000fU8e\u001d\u0006lW-\u0006\u0002\u0002`B1\u00111KAq\u0003\u0007LA!a9\u0002V\t1q\n\u001d;j_:\f\u0001d[;cKJtW\r^3t\tJLg/\u001a:Q_\u0012t\u0015-\\3!\u0003U\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN\fac\u001d5pk2$G)\u001a7fi\u0016,\u00050Z2vi>\u00148\u000fI\u0001\nIJLg/\u001a:Q_\u0012,\"!a<\u0011\r\u0005M\u0013\u0011]Ay!\u0011\t\u00190!@\u000e\u0005\u0005U(\u0002BA|\u0003s\fQ!\\8eK2T1!a?{\u0003\r\t\u0007/[\u0005\u0005\u0003\u007f\f)PA\u0002Q_\u0012\f!\u0002\u001a:jm\u0016\u0014\bk\u001c3!\u0003UqWm\u001e7z\u0007J,\u0017\r^3e\u000bb,7-\u001e;peN,\"Aa\u0002\u0011\u0011\u0005}$\u0011BAR\u0005\u001bIAAa\u0003\u0002\u0002\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\u0002\"a\u0015\u0003\u0010\u0005E\u00131U\u0005\u0005\u0005#\t)F\u0001\u0004UkBdWMM\u0001\u0017]\u0016<H._\"sK\u0006$X\rZ#yK\u000e,Ho\u001c:tA\u0005y2o\u00195fIVdWM]&o_^tg*Z<ms\u000e\u0013X-\u0019;fI\u0016CXmY:\u0016\u0005\te\u0001\u0003CA@\u0005\u0013\t\u0019+!\u0015\u0002AM\u001c\u0007.\u001a3vY\u0016\u00148J\\8x]:+w\u000f\\=De\u0016\fG/\u001a3Fq\u0016\u001c7\u000fI\u0001\u0019Ift\u0017-\\5d\u00032dwnY1uS>tWI\\1cY\u0016$\u0017!\u00073z]\u0006l\u0017nY!mY>\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0002\n!C\\;n\u001fV$8\u000f^1oI&tw\rU8eg\u0006\u0019b.^7PkR\u001cH/\u00198eS:<\u0007k\u001c3tA\u0005aA.Y:u':\f\u0007o\u001d5piV\u0011!\u0011\u0006\t\u0004?\n-\u0012b\u0001B\u0017!\n!R\t_3dkR|'\u000fU8egNs\u0017\r]:i_R\f\u0001\u0003\\1tiNs\u0017\r]:i_R|F%Z9\u0015\t\tM\"\u0011\b\t\u0005\u0003'\u0012)$\u0003\u0003\u00038\u0005U#\u0001B+oSRD\u0011Ba\u000f4\u0003\u0003\u0005\rA!\u000b\u0002\u0007a$\u0013'A\u0007mCN$8K\\1qg\"|G\u000fI\u0001\u0006CB\u0004\u0018\nZ\u0001\nCB\u0004\u0018\nZ0%KF$BAa\r\u0003F!I!1\b\u001c\u0002\u0002\u0003\u0007\u00111Y\u0001\u0007CB\u0004\u0018\n\u001a\u0011\u0002%\u0011,G.\u001a;fI\u0016CXmY;u_JLEm]\u000b\u0003\u0005\u001b\u0002bAa\u0014\u0003V\u0005\rVB\u0001B)\u0015\u0011\u0011\u0019&!\"\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002B,\u0005#\u00121aU3u\u0003Y!W\r\\3uK\u0012,\u00050Z2vi>\u0014\u0018\nZ:`I\u0015\fH\u0003\u0002B\u001a\u0005;B\u0011Ba\u000f:\u0003\u0003\u0005\rA!\u0014\u0002'\u0011,G.\u001a;fI\u0016CXmY;u_JLEm\u001d\u0011)\u0007i\u0012\u0019\u0007\u0005\u0003\u0002T\t\u0015\u0014\u0002\u0002B4\u0003+\u0012\u0001B^8mCRLG.Z\u0001\u0012M\u0006LG.\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\u0018!\u00064bS2,G-\u0012=fGV$xN]%eg~#S-\u001d\u000b\u0005\u0005g\u0011y\u0007C\u0005\u0003<q\n\t\u00111\u0001\u0003N\u0005\u0011b-Y5mK\u0012,\u00050Z2vi>\u0014\u0018\nZ:!Q\ri$1M\u0001\u000fM\u0006LG.\u001e:f)J\f7m[3s+\t\u0011I\b\u0005\u0003\u0003|\t\u0005UB\u0001B?\u0015\r\u0011yHV\u0001\u0007I\u0016\u0004Hn\\=\n\t\t\r%Q\u0010\u0002\u0017\u000bb,7-\u001e;pe\u001a\u000b\u0017\u000e\\;sKR\u0013\u0018mY6fe\u0006ya-Y5mkJ,GK]1dW\u0016\u0014\b%A\u000bhKRtU/\\#yK\u000e,Ho\u001c:t\r\u0006LG.\u001a3\u0002\u000bM$\u0018M\u001d;\u0015\r\tM\"Q\u0012BI\u0011\u001d\u0011y)\u0011a\u0001\u0003\u0007\fQ\"\u00199qY&\u001c\u0017\r^5p]&#\u0007b\u0002BJ\u0003\u0002\u0007!QS\u0001\u0011g\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u00042a\u0018BL\u0013\r\u0011I\n\u0015\u0002\"\u0017V\u0014WM\u001d8fi\u0016\u001c8\t\\;ti\u0016\u00148k\u00195fIVdWM\u001d\"bG.,g\u000eZ\u0001\u001ag\u0016$Hk\u001c;bY\u0016C\b/Z2uK\u0012,\u00050Z2vi>\u00148\u000f\u0006\u0003\u00034\t}\u0005b\u0002BQ\u0005\u0002\u0007!1U\u0001\u001ce\u0016\u001cx.\u001e:dKB\u0013xNZ5mKR{Gk\u001c;bY\u0016CXmY:\u0011\u0011\u0005\u0015'QUAG\u0003#JAAa*\u0002X\n\u0019Q*\u00199\u0002\u0013%\u001cH)\u001a7fi\u0016$G\u0003BA2\u0005[CqAa,D\u0001\u0004\t\u0019-\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\fqb\u001d;pa\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0005\u0005g\u0011)\fC\u0004\u00038\u0012\u0003\r!!\u0015\u0002\u0011\u0015D\u0018\u000e^\"pI\u0016\fab\u001c8OK^\u001cf.\u00199tQ>$8\u000f\u0006\u0005\u00034\tu&q\u0018Ba\u0011\u001d\u0011y)\u0012a\u0001\u0003\u0007DqAa%F\u0001\u0004\u0011)\nC\u0004\u0003D\u0016\u0003\rA!2\u0002\u0013Mt\u0017\r]:i_R\u001c\bC\u0002Bd\u0005#\u0014IC\u0004\u0003\u0003J\n5g\u0002BAe\u0005\u0017L!!a\u0016\n\t\t=\u0017QK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019N!6\u0003\u0007M+\u0017O\u0003\u0003\u0003P\u0006U\u0013aD4fiJ+Wo]1cY\u0016\u0004fkQ:\u0015\r\tm'q\u001dBu!\u0019\tyH!8\u0003b&!!q\\AA\u0005\u0019\u0011UO\u001a4feB!\u00111\u001fBr\u0013\u0011\u0011)/!>\u0003+A+'o]5ti\u0016tGOV8mk6,7\t\\1j[\"9!q\u0012$A\u0002\u0005\r\u0007b\u0002Bv\r\u0002\u0007!Q^\u0001\naZ\u001c7/\u00138Vg\u0016\u0004bAa2\u0003R\u0006\r\u0017a\u0005:fcV,7\u000f\u001e(fo\u0016CXmY;u_J\u001cHC\u0003B\u001a\u0005g\u00149P!?\u0003~\"9!Q_$A\u0002\u0005E\u0013A\u00068v[\u0016CXmY;u_J\u001cHk\\!mY>\u001c\u0017\r^3\t\u000f\t=u\t1\u0001\u0002D\"9!1`$A\u0002\u0005E\u0013!\u0005:fg>,(oY3Qe>4\u0017\u000e\\3JI\"9!1^$A\u0002\t5\u0018a\u0005:fa2\f7-\u001a)W\u0007NLeMT3fI\u0016$G\u0003CB\u0002\u0007\u0017\u0019yaa\u0005\u0011\r\t\u001d'\u0011[B\u0003!\u0011\t\u0019pa\u0002\n\t\r%\u0011Q\u001f\u0002\f\u0011\u0006\u001cX*\u001a;bI\u0006$\u0018\rC\u0004\u0004\u000e!\u0003\r!!=\u0002\u0007A|G\rC\u0004\u0004\u0012!\u0003\raa\u0001\u0002\u0013I,7o\\;sG\u0016\u001c\bbBB\u000b\u0011\u0002\u0007!1\\\u0001\re\u0016,8/\u00192mKB36i]\u0001\u0017SN,\u00050Z2vi>\u0014\u0018\n\u001a7f)&lW\rZ(viR1\u00111MB\u000e\u0007KAqa!\bJ\u0001\u0004\u0019y\"A\u0003ti\u0006$X\rE\u0002`\u0007CI1aa\tQ\u0005A)\u00050Z2vi>\u0014\bk\u001c3Ti\u0006$X\rC\u0004\u0004(%\u0003\r!a)\u0002\u0017\r,(O]3oiRKW.Z\u0001\u0005gR|\u0007\u000f\u0006\u0003\u00034\r5\u0002b\u0002BH\u0015\u0002\u0007\u00111Y\u0001\u0016\u000bb,7-\u001e;peB{Gm]!mY>\u001c\u0017\r^8s!\tyFjE\u0002M\u0007k\u0001B!a\u0015\u00048%!1\u0011HA+\u0005\u0019\te.\u001f*fMR\u00111\u0011G\u0001\u000bgBd\u0017\u000e^*m_R\u001cX\u0003BB!\u0007\u0017\"baa\u0011\u0004^\r\r\u0004C\u0002Bd\u0005#\u001c)\u0005\u0005\u0005\u0002T\t=1qIA)!\u0011\u0019Iea\u0013\r\u0001\u001191Q\n(C\u0002\r=#!\u0001+\u0012\t\rE3q\u000b\t\u0005\u0003'\u001a\u0019&\u0003\u0003\u0004V\u0005U#a\u0002(pi\"Lgn\u001a\t\u0005\u0003'\u001aI&\u0003\u0003\u0004\\\u0005U#aA!os\"91q\f(A\u0002\r\u0005\u0014!C2p]N,X.\u001a:t!\u0019\u00119M!5\u0004H!91Q\r(A\u0002\u0005E\u0013!B:m_R\u001c\b")
public class ExecutorPodsAllocator
extends AbstractPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicInteger EXECUTOR_ID_COUNTER;
    private final AtomicInteger PVC_COUNTER;
    private final int maxPVCs;
    private final boolean podAllocOnPVC;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final int maxPendingPods;
    private final int maxNumExecutorFailures;
    private final long podCreationTimeout;
    private final long driverPodReadinessTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs;
    private final boolean dynamicAllocationEnabled;
    private final AtomicInteger numOutstandingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private String appId;
    private volatile scala.collection.immutable.Set<Object> deletedExecutorIds;
    private volatile scala.collection.immutable.Set<Object> failedExecutorIds;
    private final ExecutorFailureTracker failureTracker;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <T> Seq<Tuple2<T, Object>> splitSlots(Seq<T> seq, int n) {
        return ExecutorPodsAllocator$.MODULE$.splitSlots(seq, n);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public AtomicInteger EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    public AtomicInteger PVC_COUNTER() {
        return this.PVC_COUNTER;
    }

    public int maxPVCs() {
        return this.maxPVCs;
    }

    public boolean podAllocOnPVC() {
        return this.podAllocOnPVC;
    }

    public ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    public HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    public int podAllocationSize() {
        return this.podAllocationSize;
    }

    public long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    public int maxPendingPods() {
        return this.maxPendingPods;
    }

    public int maxNumExecutorFailures() {
        return this.maxNumExecutorFailures;
    }

    public long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    public long driverPodReadinessTimeout() {
        return this.driverPodReadinessTimeout;
    }

    public long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    public String namespace() {
        return this.namespace;
    }

    public Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    public boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    @Override
    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    public LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    public LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs() {
        return this.schedulerKnownNewlyCreatedExecs;
    }

    public boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public AtomicInteger numOutstandingPods() {
        return this.numOutstandingPods;
    }

    public ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    public void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public scala.collection.immutable.Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    public void deletedExecutorIds_$eq(scala.collection.immutable.Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    private scala.collection.immutable.Set<Object> failedExecutorIds() {
        return this.failedExecutorIds;
    }

    private void failedExecutorIds_$eq(scala.collection.immutable.Set<Object> x$1) {
        this.failedExecutorIds = x$1;
    }

    public ExecutorFailureTracker failureTracker() {
        return this.failureTracker;
    }

    public int getNumExecutorsFailed() {
        return this.failureTracker().numFailedExecutors();
    }

    @Override
    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.appId_$eq(applicationId);
        this.driverPod().foreach((Function1 & Serializable & scala.Serializable)pod -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Waitable)((Nameable)this.kubernetesClient.pods().inNamespace(this.namespace())).withName(pod.getMetadata().getName())).waitUntilReady(this.driverPodReadinessTimeout(), TimeUnit.SECONDS));
            return BoxedUnit.UNIT;
        });
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)executorPodsSnapshot -> {
            ExecutorPodsAllocator.$anonfun$start$3(this, applicationId, schedulerBackend, executorPodsSnapshot);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setTotalExpectedExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        resourceProfileToTotalExecs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Set total expected execs to ").append(this.totalExpectedExecutorsPerResourceProfileId()).toString());
        if (this.numOutstandingPods().get() == 0) {
            this.snapshotsStore.notifySubscribers();
            return;
        }
    }

    @Override
    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(executorId)).toLong()));
    }

    public void stopApplication(int exitCode) {
        throw scala.sys.package$.MODULE$.exit(exitCode);
    }

    public void onNewSnapshots(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Received ").append(snapshots.size()).append(" snapshots").toString());
        Seq k8sKnownExecIds = (Seq)((SeqLike)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.executorPods().keys(), Seq$.MODULE$.canBuildFrom())).distinct();
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        this.schedulerKnownNewlyCreatedExecs().$minus$minus$eq((TraversableOnce)k8sKnownExecIds);
        Seq k8sKnownPVCNames = (Seq)((SeqLike)((TraversableLike)snapshots.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Iterable)x$2.executorPods().values().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.pod(), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)pod -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getSpec().getVolumes()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)v -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)v.getPersistentVolumeClaim()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getClaimName())), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
        scala.collection.immutable.Set schedulerKnownExecs = ((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$8(x$5)), Seq$.MODULE$.canBuildFrom())).toSet();
        this.schedulerKnownNewlyCreatedExecs().$plus$plus$eq((TraversableOnce)this.newlyCreatedExecutors().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$6 -> schedulerKnownExecs.contains((Object)BoxesRunTime.boxToLong((long)x$6))).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7._1$mcI$sp())));
        this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)this.schedulerKnownNewlyCreatedExecs().keySet());
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    long timeCreated = tuple22._2$mcJ$sp();
                    if (currentTime - timeCreated > this.podCreationTimeout()) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)execId)));
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Executor with id ").append(execId).append(" was not found in the Kubernetes cluster since it").append(" was created ").append(currentTime - timeCreated).append(" milliseconds ago.").toString());
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
        if (timedOut.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(230).append("Executors with ids ").append(timedOut.mkString(",")).append(" were not detected in the").append(" Kubernetes cluster after ").append(this.podCreationTimeout()).append(" ms despite the fact that a previous").append(" allocation attempt tried to create them. The executors may have been deleted but the").append(" application missed the deletion event.").toString());
            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)timedOut.toSeq().map((Function1 & Serializable & scala.Serializable)x$8 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$15(BoxesRunTime.unboxToLong((Object)x$8)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            scala.collection.immutable.Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds.elem).intersect((GenSet)existingExecs);
        }
        Map notDeletedPods = this.lastSnapshot().executorPods().filterKeys((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> !((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)x$9)));
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq((TraversableOnce)notDeletedPods));
        } else {
            notDeletedPods.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$17(rpIdToExecsAndPodState, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        IntRef totalNotRunningPodCount = IntRef.create((int)0);
        Seq podsToAllocateWithRpId = (Seq)((TraversableLike)((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.totalExpectedExecutorsPerResourceProfileId()).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int rpId = tuple2._1$mcI$sp();
                int targetNum = tuple2._2$mcI$sp();
                HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> HashMap$.MODULE$.empty());
                int currentRunningCount = podsForRpId.values().count((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$22(x0$4)));
                Set currentFailedExecutorIds = ((HashMap)podsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$23(x0$5)))).keySet();
                Set newFailedExecutorIds = (Set)currentFailedExecutorIds.$minus$minus(this.failedExecutorIds());
                if (newFailedExecutorIds.nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append(newFailedExecutorIds.size()).append(" new failed executors.").toString());
                    newFailedExecutorIds.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$11 -> this.failureTracker().registerExecutorFailure());
                }
                this.failedExecutorIds_$eq((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)this.failedExecutorIds().$plus$plus((GenTraversableOnce)currentFailedExecutorIds)));
                Tuple2 tuple22 = ((TraversableLike)podsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$26(x0$6)))).partition((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$27(schedulerKnownExecs, x0$7)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                HashMap schedulerKnownPendingExecsForRpId = (HashMap)tuple22._1();
                HashMap currentPendingExecutorsForRpId = (HashMap)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)schedulerKnownPendingExecsForRpId, (Object)currentPendingExecutorsForRpId);
                HashMap schedulerKnownPendingExecsForRpId2 = (HashMap)tuple23._1();
                HashMap currentPendingExecutorsForRpId2 = (HashMap)tuple23._2();
                IntRef pendingCountForRpId = IntRef.create((int)currentPendingExecutorsForRpId2.size());
                LinkedHashMap newlyCreatedExecutorsForRpId = (LinkedHashMap)this.newlyCreatedExecutors().filter((Function1 & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$28(rpId, x0$8)));
                LinkedHashMap schedulerKnownNewlyCreatedExecsForRpId = (LinkedHashMap)this.schedulerKnownNewlyCreatedExecs().filter((Function1 & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$29(rpId, x0$9)));
                if (podsForRpId.nonEmpty()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(170).append("ResourceProfile Id: ").append(rpId).append(" (").append("pod allocation status: ").append(currentRunningCount).append(" running, ").append(currentPendingExecutorsForRpId2.size()).append(" unknown pending, ").append(schedulerKnownPendingExecsForRpId2.size()).append(" scheduler backend known pending, ").append(newlyCreatedExecutorsForRpId.size()).append(" unknown newly created, ").append(schedulerKnownNewlyCreatedExecsForRpId.size()).append(" scheduler backend known newly created)").toString());
                }
                IntRef notRunningPodCountForRpId = IntRef.create((int)(currentPendingExecutorsForRpId2.size() + schedulerKnownPendingExecsForRpId2.size() + newlyCreatedExecutorsForRpId.size() + schedulerKnownNewlyCreatedExecsForRpId.size()));
                int podCountForRpId = currentRunningCount + notRunningPodCountForRpId.elem;
                if (podCountForRpId > targetNum) {
                    scala.collection.mutable.Iterable pendingToDelete;
                    int excess = podCountForRpId - targetNum;
                    List newlyCreatedToDelete = ((TraversableOnce)((MapLike)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable & scala.Serializable)x0$10 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$31(this, currentTime, x0$10)))).keys().take(excess)).toList();
                    List toDelete = (List)newlyCreatedToDelete.$plus$plus((GenTraversableOnce)(pendingToDelete = (scala.collection.mutable.Iterable)((TraversableLike)((IterableLike)currentPendingExecutorsForRpId2.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime)))).take(excess - newlyCreatedToDelete.size())).map((Function1 & Serializable & scala.Serializable)x0$11 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$33(x0$11)), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())), List$.MODULE$.canBuildFrom());
                    if (toDelete.nonEmpty()) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Deleting ").append(toDelete.size()).append(" excess pod requests (").append(toDelete.mkString(",")).append(").").toString());
                        _deletedExecutorIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).$plus$plus((GenTraversableOnce)toDelete);
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            ((Deletable)((Filterable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((TraversableOnce)((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$13 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$36(BoxesRunTime.unboxToLong((Object)x$13)), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                            this.newlyCreatedExecutors().$minus$minus$eq((TraversableOnce)newlyCreatedToDelete);
                            pendingCountForRpId$1.elem -= pendingToDelete.size();
                            notRunningPodCountForRpId$1.elem -= toDelete.size();
                        });
                    }
                }
                totalPendingCount$1.elem += pendingCountForRpId.elem;
                totalNotRunningPodCount$1.elem += notRunningPodCountForRpId.elem;
                if (this.log().isDebugEnabled() && snapshots.nonEmpty()) {
                    int outstanding = pendingCountForRpId.elem + newlyCreatedExecutorsForRpId.size();
                    if (currentRunningCount >= targetNum && !this.dynamicAllocationEnabled()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(130).append("Current number of running executors for ResourceProfile Id ").append(rpId).append(" is ").append("equal to the number of requested executors. Not scaling up further.").toString());
                    } else if (newlyCreatedExecutorsForRpId.nonEmpty()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Still waiting for ").append(newlyCreatedExecutorsForRpId.size()).append(" executors for ").append("ResourceProfile Id ").append(rpId).append(" before requesting more.").toString());
                    }
                }
                if (newlyCreatedExecutorsForRpId.isEmpty() && podCountForRpId < targetNum) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)rpId), (Object)BoxesRunTime.boxToInteger((int)podCountForRpId), (Object)BoxesRunTime.boxToInteger((int)targetNum))));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        int remainingSlotFromPendingPods = this.maxPendingPods() - totalNotRunningPodCount.elem;
        if (!(remainingSlotFromPendingPods <= 0 || podsToAllocateWithRpId.size() <= 0 || snapshots.isEmpty() && this.podAllocOnPVC() && this.maxPVCs() <= this.PVC_COUNTER().get())) {
            ExecutorPodsAllocator$.MODULE$.splitSlots(podsToAllocateWithRpId, remainingSlotFromPendingPods).foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$39(this, applicationId, k8sKnownPVCNames, x0$12);
                return BoxedUnit.UNIT;
            });
        }
        this.deletedExecutorIds_$eq((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)_deletedExecutorIds.elem));
        this.numOutstandingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size());
    }

    public Buffer<PersistentVolumeClaim> getReusablePVCs(String applicationId, Seq<String> pvcsInUse) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && this.driverPod().nonEmpty()) {
            Buffer buffer;
            try {
                Buffer createdPVCs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((PersistentVolumeClaimList)((Listable)((Filterable)this.kubernetesClient.persistentVolumeClaims().inNamespace(this.namespace())).withLabel("spark-app-selector", applicationId)).list()).getItems()).asScala();
                long now = Instant.now().toEpochMilli();
                Buffer reusablePVCs = (Buffer)((TraversableLike)createdPVCs.filterNot((Function1 & Serializable & scala.Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)pvcsInUse.contains((Object)pvc.getMetadata().getName())))).filter((Function1 & Serializable & scala.Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$getReusablePVCs$2(this, now, pvc)));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Found ").append(reusablePVCs.size()).append(" reusable PVCs from ").append(createdPVCs.size()).append(" PVCs").toString());
                buffer = reusablePVCs;
            }
            catch (KubernetesClientException kubernetesClientException) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot list PVC resources. Please check account permissions.");
                buffer = (Buffer)Buffer$.MODULE$.empty();
            }
            return buffer;
        }
        return (Buffer)Buffer$.MODULE$.empty();
    }

    public void requestNewExecutors(int numExecutorsToAllocate, String applicationId, int resourceProfileId, Seq<String> pvcsInUse) {
        Object object = new Object();
        try {
            Buffer<PersistentVolumeClaim> reusablePVCs = this.getReusablePVCs(applicationId, pvcsInUse);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                if (reusablePVCs.isEmpty() && this.podAllocOnPVC() && this.maxPVCs() <= this.PVC_COUNTER().get()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Wait to reuse one of the existing ").append(this.PVC_COUNTER().get()).append(" PVCs.").toString());
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                int newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
                KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, Integer.toString(newExecutorId), applicationId, this.driverPod(), resourceProfileId);
                KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
                SparkPod executorPod = resolvedExecutorSpec.pod();
                Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
                Seq<HasMetadata> resources = this.replacePVCsIfNeeded(podWithAttachedContainer, resolvedExecutorSpec.executorKubernetesResources(), reusablePVCs);
                Pod createdExecutorPod = (Pod)((CreateOrReplaceable)((AnyNamespaceOperation)$this.kubernetesClient.pods().inNamespace(this.namespace())).resource((Object)podWithAttachedContainer)).create();
                try {
                    KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                    ((IterableLike)resources.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$3(x$14)))).foreach((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$requestNewExecutors$4(this, resource)));
                    this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Requested executor with id ").append(newExecutorId).append(" from Kubernetes.").toString());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        ((Deletable)((AnyNamespaceOperation)$this.kubernetesClient.pods().inNamespace(this.namespace())).resource((Object)createdExecutorPod)).delete();
                        throw e;
                    }
                    throw throwable;
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Seq<HasMetadata> replacePVCsIfNeeded(Pod pod, Seq<HasMetadata> resources, Buffer<PersistentVolumeClaim> reusablePVCs) {
        scala.collection.mutable.Set replacedResources = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        resources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$1(this, reusablePVCs, pod, replacedResources, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)resources.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)replacedResources.contains((Object)elem)));
    }

    public boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long creationTime = Instant.parse(state.pod().getMetadata().getCreationTimestamp()).toEpochMilli();
                if (currentTime - creationTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Cannot get the creationTimestamp of the pod: ").append(state.pod()).toString(), e);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void stop(String applicationId) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
    }

    public static final /* synthetic */ void $anonfun$start$3(ExecutorPodsAllocator $this, String applicationId$1, KubernetesClusterSchedulerBackend schedulerBackend$1, Seq executorPodsSnapshot) {
        $this.onNewSnapshots(applicationId$1, schedulerBackend$1, (Seq<ExecutorPodsSnapshot>)executorPodsSnapshot);
        if ($this.failureTracker().numFailedExecutors() > $this.maxNumExecutorFailures()) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Max number of executor failures (").append($this.maxNumExecutorFailures()).append(") reached").toString());
            $this.stopApplication(SparkExitCode$.MODULE$.EXCEED_MAX_EXECUTOR_FAILURES());
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ResourceProfile rp = (ResourceProfile)tuple2._1();
            int numExecs = tuple2._2$mcI$sp();
            $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable & scala.Serializable)() -> rp);
            return BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$8(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$15(long x$8) {
        return Long.toString(x$8);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$17(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long execId = tuple2._1$mcJ$sp();
            ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
            int rpId = new StringOps(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL()))).toInt();
            HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$22(ExecutorPodState x0$4) {
        ExecutorPodState executorPodState = x0$4;
        return executorPodState instanceof PodRunning;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$23(Tuple2 x0$5) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$5;
        return tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodFailed;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$26(Tuple2 x0$6) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$6;
        return tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$27(scala.collection.immutable.Set schedulerKnownExecs$1, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            long k = tuple2._1$mcJ$sp();
            return schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$28(int rpId$1, Tuple2 x0$8) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$8;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            int waitingRpId = tuple2._1$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$29(int rpId$1, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            int waitingRpId = tuple2._2$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$31(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$10) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$10;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            long createTime = tuple2._2$mcJ$sp();
            return currentTime$1 - createTime > $this.executorIdleTimeout();
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$33(Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 != null) {
            long id = tuple2._1$mcJ$sp();
            return id;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$36(long x$13) {
        return Long.toString(x$13);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$39(ExecutorPodsAllocator $this, String applicationId$2, Seq k8sKnownPVCNames$1, Tuple2 x0$12) {
        Tuple2 tuple2 = x0$12;
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            int sharedSlotFromPendingPods = tuple2._2$mcI$sp();
            if (tuple3 != null) {
                int rpId = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int podCountForRpId = BoxesRunTime.unboxToInt((Object)tuple3._2());
                int targetNum = BoxesRunTime.unboxToInt((Object)tuple3._3());
                int numMissingPodsForRpId = targetNum - podCountForRpId;
                int numExecutorsToAllocate = package$.MODULE$.min(package$.MODULE$.min(numMissingPodsForRpId, $this.podAllocationSize()), sharedSlotFromPendingPods);
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append("Going to request ").append(numExecutorsToAllocate).append(" executors from Kubernetes for ").append("ResourceProfile Id: ").append(rpId).append(", target: ").append(targetNum).append(", known: ").append(podCountForRpId).append(", ").append("sharedSlotFromPendingPods: ").append(sharedSlotFromPendingPods).append(".").toString());
                $this.requestNewExecutors(numExecutorsToAllocate, applicationId$2, rpId, (Seq<String>)k8sKnownPVCNames$1);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getReusablePVCs$2(ExecutorPodsAllocator $this, long now$1, PersistentVolumeClaim pvc) {
        return now$1 - Instant.parse(pvc.getMetadata().getCreationTimestamp()).toEpochMilli() > $this.podCreationTimeout();
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$3(HasMetadata x$14) {
        String string = x$14.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$requestNewExecutors$4(ExecutorPodsAllocator $this, HasMetadata resource) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && $this.driverPod().nonEmpty()) {
            KubernetesUtils$.MODULE$.addOwnerReference((Pod)$this.driverPod().get(), (Seq<HasMetadata>)((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)));
        }
        PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Trying to create PersistentVolumeClaim ").append(pvc.getMetadata().getName()).append(" with ").append("StorageClass ").append(pvc.getSpec().getStorageClassName()).toString());
        ((CreateOrReplaceable)((AnyNamespaceOperation)$this.kubernetesClient.persistentVolumeClaims().inNamespace($this.namespace())).resource((Object)pvc)).create();
        return $this.PVC_COUNTER().incrementAndGet();
    }

    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$2(PersistentVolumeClaim x2$1, PersistentVolumeClaim p) {
        String string = p.getSpec().getStorageClassName();
        String string2 = x2$1.getSpec().getStorageClassName();
        return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.equals(p.getSpec().getResources().getRequests().get("storage"), x2$1.getSpec().getResources().getRequests().get("storage"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$3(PersistentVolumeClaim x2$1, Volume v) {
        if (v.getPersistentVolumeClaim() == null) return false;
        String string = v.getPersistentVolumeClaim().getClaimName();
        String string2 = x2$1.getMetadata().getName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$replacePVCsIfNeeded$1(ExecutorPodsAllocator $this, Buffer reusablePVCs$3, Pod pod$2, scala.collection.mutable.Set replacedResources$1, HasMetadata x0$1) {
        HasMetadata hasMetadata = x0$1;
        if (hasMetadata instanceof PersistentVolumeClaim) {
            PersistentVolumeClaim persistentVolumeClaim = (PersistentVolumeClaim)hasMetadata;
            int index = reusablePVCs$3.indexWhere((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$2(persistentVolumeClaim, p)));
            if (index >= 0) {
                Option volume = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod$2.getSpec().getVolumes()).asScala()).find((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$3(persistentVolumeClaim, v)));
                if (volume.nonEmpty()) {
                    PersistentVolumeClaim matchedPVC = (PersistentVolumeClaim)reusablePVCs$3.remove(index);
                    replacedResources$1.add((Object)persistentVolumeClaim);
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Reuse PersistentVolumeClaim ").append(matchedPVC.getMetadata().getName()).toString());
                    ((Volume)volume.get()).getPersistentVolumeClaim().setClaimName(matchedPVC.getMetadata().getName());
                    return;
                }
                return;
            }
            return;
        }
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicInteger(0);
        this.PVC_COUNTER = new AtomicInteger(0);
        this.maxPVCs = Utils$.MODULE$.isDynamicAllocationEnabled(conf) ? BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MAX_EXECUTORS())) : conf.getInt(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key(), SchedulerBackendUtils$.MODULE$.DEFAULT_NUMBER_EXECUTORS());
        this.podAllocOnPVC = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_WAIT_TO_REUSE_PVC()));
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.maxPendingPods = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS()));
        this.maxNumExecutorFailures = ExecutorFailureTracker$.MODULE$.maxNumExecutorFailures(conf);
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.driverPodReadinessTimeout = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_DRIVER_READINESS_TIMEOUT()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable & scala.Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(name)).get()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException(new StringBuilder(99).append("No pod was found named ").append((String)name).append(" in the cluster in the ").append("namespace ").append(this.namespace()).append(" (this was supposed to be the driver pod.).").toString());
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.schedulerKnownNewlyCreatedExecs = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled(conf);
        this.numOutstandingPods = new AtomicInteger();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
        this.failedExecutorIds = Predef$.MODULE$.Set().empty();
        this.failureTracker = new ExecutorFailureTracker(conf, clock);
    }
}

