/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.DoubleFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public class JavaRecommendationExample {
    public static void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("Java Collaborative Filtering Example");
        JavaSparkContext jsc = new JavaSparkContext(conf);
        String path = "data/mllib/als/test.data";
        JavaRDD data = jsc.textFile(path);
        JavaRDD ratings = data.map((Function & Serializable)s -> {
            String[] sarray = s.split(",");
            return new Rating(Integer.parseInt(sarray[0]), Integer.parseInt(sarray[1]), Double.parseDouble(sarray[2]));
        });
        int rank = 10;
        int numIterations = 10;
        MatrixFactorizationModel model = ALS.train((RDD)JavaRDD.toRDD((JavaRDD)ratings), (int)rank, (int)numIterations, (double)0.01);
        JavaRDD userProducts = ratings.map((Function & Serializable)r -> new Tuple2((Object)r.user(), (Object)r.product()));
        JavaPairRDD predictions = JavaPairRDD.fromJavaRDD((JavaRDD)model.predict(JavaRDD.toRDD((JavaRDD)userProducts)).toJavaRDD().map((Function & Serializable)r -> new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating())));
        JavaRDD ratesAndPreds = JavaPairRDD.fromJavaRDD((JavaRDD)ratings.map((Function & Serializable)r -> new Tuple2((Object)new Tuple2((Object)r.user(), (Object)r.product()), (Object)r.rating()))).join(predictions).values();
        double MSE = ratesAndPreds.mapToDouble((DoubleFunction & Serializable)pair -> {
            double err = (Double)pair._1() - (Double)pair._2();
            return err * err;
        }).mean();
        System.out.println("Mean Squared Error = " + MSE);
        model.save(jsc.sc(), "target/tmp/myCollaborativeFilter");
        MatrixFactorizationModel sameModel = MatrixFactorizationModel.load((SparkContext)jsc.sc(), (String)"target/tmp/myCollaborativeFilter");
        jsc.stop();
    }
}

