/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.metrics.MetricsConfig;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.MetricsServlet;
import org.apache.spark.metrics.sink.PrometheusServlet;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.metrics.source.StaticSources$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u001db!\u0002\u0017.\u0001=*\u0004\u0002\u0003\"\u0001\u0005\u000b\u0007I\u0011\u0001#\t\u0011A\u0003!\u0011!Q\u0001\n\u0015C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\u0006-\u0002!Ia\u0016\u0005\u00079\u0002\u0001\u000b\u0011B/\t\u000f\u0001\u0004!\u0019!C\u0005C\"1\u0001\u000f\u0001Q\u0001\n\tDq!\u001d\u0001C\u0002\u0013%!\u000f\u0003\u0004{\u0001\u0001\u0006Ia\u001d\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\ti\u0001\u0001Q\u0001\nuD\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u0013\u0005e\u0001\u00011A\u0005\n\u0005m\u0001\u0002CA\u0014\u0001\u0001\u0006K!a\u0005\t\u0013\u0005%\u0002\u00011A\u0005\n\u0005-\u0002\"CA\u001d\u0001\u0001\u0007I\u0011BA\u001e\u0011!\ty\u0004\u0001Q!\n\u00055\u0002\"CA!\u0001\u0001\u0007I\u0011BA\"\u0011%\ti\u0005\u0001a\u0001\n\u0013\ty\u0005\u0003\u0005\u0002T\u0001\u0001\u000b\u0015BA#\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!a\u001d\u0001\t\u0003\t)\bC\u0005\u0002|\u0001\t\n\u0011\"\u0001\u0002~!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBAL\u0001\u0011\u0005\u0011Q\u0013\u0005\t\u00033\u0003A\u0011A\u0018\u0002\u001c\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\t)\r\u0001C\u0005\u0003+Cq!a2\u0001\t\u0013\t)\nC\u0004\u0002J\u0002!\t!a3\b\u0011\u0005uW\u0006#\u00010\u0003?4q\u0001L\u0017\t\u0002=\n\t\u000f\u0003\u0004WE\u0011\u0005\u00111\u001d\u0005\n\u0003K\u0014#\u0019!C\u0001\u0003OD\u0001\"a>#A\u0003%\u0011\u0011\u001e\u0005\n\u0003s\u0014#\u0019!C\u0001\u0003OD\u0001\"a?#A\u0003%\u0011\u0011\u001e\u0005\t\u0003{\u0014\u0003\u0015!\u0003\u0002\u0000\"A!1\u0002\u0012!\u0002\u0013\u0011i\u0001C\u0004\u0003\u0014\t\"\tA!\u0006\t\u000f\t}!\u0005\"\u0001\u0003\"\tiQ*\u001a;sS\u000e\u001c8+_:uK6T!AL\u0018\u0002\u000f5,GO]5dg*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xmE\u0002\u0001mq\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0007CA\u001fA\u001b\u0005q$BA 0\u0003!Ig\u000e^3s]\u0006d\u0017BA!?\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-Z\u0002\u0001+\u0005)\u0005C\u0001$N\u001d\t95\n\u0005\u0002Iq5\t\u0011J\u0003\u0002K\u0007\u00061AH]8pizJ!\u0001\u0014\u001d\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019b\n\u0011\"\u001b8ti\u0006t7-\u001a\u0011\u0002\t\r|gN\u001a\t\u0003'Rk\u0011aL\u0005\u0003+>\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\rA&l\u0017\t\u00033\u0002i\u0011!\f\u0005\u0006\u0005\u0012\u0001\r!\u0012\u0005\u0006#\u0012\u0001\rAU\u0001\u000e[\u0016$(/[2t\u0007>tg-[4\u0011\u0005es\u0016BA0.\u00055iU\r\u001e:jGN\u001cuN\u001c4jO\u0006)1/\u001b8lgV\t!\rE\u0002dQ*l\u0011\u0001\u001a\u0006\u0003K\u001a\fq!\\;uC\ndWM\u0003\u0002hq\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005%$'aC!se\u0006L()\u001e4gKJ\u0004\"a\u001b8\u000e\u00031T!!\\\u0017\u0002\tMLgn[\u0005\u0003_2\u0014AaU5oW\u000611/\u001b8lg\u0002\nqa]8ve\u000e,7/F\u0001t!\r\u0019\u0007\u000e\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003o6\naa]8ve\u000e,\u0017BA=w\u0005\u0019\u0019v.\u001e:dK\u0006A1o\\;sG\u0016\u001c\b%\u0001\u0005sK\u001eL7\u000f\u001e:z+\u0005i\bc\u0001@\u0002\n5\tqPC\u0002/\u0003\u0003QA!a\u0001\u0002\u0006\u0005A1m\u001c3bQ\u0006dWM\u0003\u0002\u0002\b\u0005\u00191m\\7\n\u0007\u0005-qP\u0001\bNKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0002\u0013I,w-[:uef\u0004\u0013a\u0002:v]:LgnZ\u000b\u0003\u0003'\u00012aNA\u000b\u0013\r\t9\u0002\u000f\u0002\b\u0005>|G.Z1o\u0003-\u0011XO\u001c8j]\u001e|F%Z9\u0015\t\u0005u\u00111\u0005\t\u0004o\u0005}\u0011bAA\u0011q\t!QK\\5u\u0011%\t)#DA\u0001\u0002\u0004\t\u0019\"A\u0002yIE\n\u0001B];o]&tw\rI\u0001\u000f[\u0016$(/[2t'\u0016\u0014h\u000f\\3u+\t\ti\u0003E\u00038\u0003_\t\u0019$C\u0002\u00022a\u0012aa\u00149uS>t\u0007cA6\u00026%\u0019\u0011q\u00077\u0003\u001d5+GO]5dgN+'O\u001e7fi\u0006\u0011R.\u001a;sS\u000e\u001c8+\u001a:wY\u0016$x\fJ3r)\u0011\ti\"!\u0010\t\u0013\u0005\u0015\u0002#!AA\u0002\u00055\u0012aD7fiJL7m]*feZdW\r\u001e\u0011\u0002#A\u0014x.\\3uQ\u0016,8oU3sm2,G/\u0006\u0002\u0002FA)q'a\f\u0002HA\u00191.!\u0013\n\u0007\u0005-CNA\tQe>lW\r\u001e5fkN\u001cVM\u001d<mKR\fQ\u0003\u001d:p[\u0016$\b.Z;t'\u0016\u0014h\u000f\\3u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\u0005E\u0003\"CA\u0013'\u0005\u0005\t\u0019AA#\u0003I\u0001(o\\7fi\",Wo]*feZdW\r\u001e\u0011\u0002%\u001d,GoU3sm2,G\u000fS1oI2,'o]\u000b\u0003\u00033\u0002RaNA.\u0003?J1!!\u00189\u0005\u0015\t%O]1z!\u0011\t\t'a\u001c\u000e\u0005\u0005\r$\u0002BA3\u0003O\nqa]3sm2,GO\u0003\u0003\u0002j\u0005-\u0014!\u00026fiRL(bAA7g\u00059Qm\u00197jaN,\u0017\u0002BA9\u0003G\u0012QcU3sm2,GoQ8oi\u0016DH\u000fS1oI2,'/A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002\u001e\u0005]\u0004\"CA=-A\u0005\t\u0019AA\n\u0003U\u0011XmZ5ti\u0016\u00148\u000b^1uS\u000e\u001cv.\u001e:dKN\fqb\u001d;beR$C-\u001a4bk2$H%M\u000b\u0003\u0003\u007fRC!a\u0005\u0002\u0002.\u0012\u00111\u0011\t\u0005\u0003\u000b\u000by)\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003%)hn\u00195fG.,GMC\u0002\u0002\u000eb\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t*a\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003ti>\u0004HCAA\u000f\u0003\u0019\u0011X\r]8si\u0006\t\"-^5mIJ+w-[:ueft\u0015-\\3\u0015\u0007\u0015\u000bi\nC\u0003x5\u0001\u0007A/\u0001\thKR\u001cv.\u001e:dKN\u0014\u0015PT1nKR!\u00111UA[!\u0015\t)+a,u\u001d\u0011\t9+a+\u000f\u0007!\u000bI+C\u0001:\u0013\r\ti\u000bO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t,a-\u0003\u0007M+\u0017OC\u0002\u0002.bBa!a.\u001c\u0001\u0004)\u0015AC:pkJ\u001cWMT1nK\u0006q!/Z4jgR,'oU8ve\u000e,G\u0003BA\u000f\u0003{CQa\u001e\u000fA\u0002Q\fAB]3n_Z,7k\\;sG\u0016$B!!\b\u0002D\")q/\ba\u0001i\u0006y!/Z4jgR,'oU8ve\u000e,7/A\u0007sK\u001eL7\u000f^3s'&t7n]\u0001\u0012[\u0016$(/[2t!J|\u0007/\u001a:uS\u0016\u001cHCAAg!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\fA!\u001e;jY*\u0011\u0011q[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\\\u0006E'A\u0003)s_B,'\u000f^5fg\u0006iQ*\u001a;sS\u000e\u001c8+_:uK6\u0004\"!\u0017\u0012\u0014\u0005\t2DCAAp\u0003)\u0019\u0016JT&`%\u0016;U\tW\u000b\u0003\u0003S\u0004B!a;\u0002t6\u0011\u0011Q\u001e\u0006\u0005\u0003_\f\t0\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\t\u0019\u000eO\u0005\u0005\u0003k\fiOA\u0003SK\u001e,\u00070A\u0006T\u0013:[uLU#H\u000bb\u0003\u0013\u0001D*P+J\u001bUi\u0018*F\u000f\u0016C\u0016!D*P+J\u001bUi\u0018*F\u000f\u0016C\u0006%A\tN\u0013:KU*\u0011'`!>cEjX+O\u0013R\u0003BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0005\u0005\u000b\t\t.\u0001\u0006d_:\u001cWO\u001d:f]RLAA!\u0003\u0003\u0004\tAA+[7f+:LG/A\nN\u0013:KU*\u0011'`!>cEj\u0018)F%&{E\tE\u00028\u0005\u001fI1A!\u00059\u0005\rIe\u000e^\u0001\u001aG\",7m['j]&l\u0017\r\u001c)pY2Lgn\u001a)fe&|G\r\u0006\u0004\u0002\u001e\t]!1\u0004\u0005\b\u00053Q\u0003\u0019AA\u0000\u0003!\u0001x\u000e\u001c7V]&$\bb\u0002B\u000fU\u0001\u0007!QB\u0001\u000ba>dG\u000eU3sS>$\u0017aE2sK\u0006$X-T3ue&\u001c7oU=ti\u0016lG#\u0002-\u0003$\t\u0015\u0002\"\u0002\",\u0001\u0004)\u0005\"B),\u0001\u0004\u0011\u0006")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final SparkConf conf;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final ArrayBuffer<Source> sources;
    private final MetricRegistry registry;
    private boolean running;
    private Option<MetricsServlet> metricsServlet;
    private Option<PrometheusServlet> prometheusServlet;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MetricsSystem createMetricsSystem(String string, SparkConf sparkConf) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, sparkConf);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String instance() {
        return this.instance;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private ArrayBuffer<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private Option<MetricsServlet> metricsServlet() {
        return this.metricsServlet;
    }

    private void metricsServlet_$eq(Option<MetricsServlet> x$1) {
        this.metricsServlet = x$1;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    public ServletContextHandler[] getServletHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (ServletContextHandler[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metricsServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServletContextHandler.class)));
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            StaticSources$.MODULE$.allSources().foreach((Function1 & Serializable & scala.Serializable)source -> {
                this.registerSource(source);
                return BoxedUnit.UNIT;
            });
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.stop();
                return BoxedUnit.UNIT;
            });
            this.registry().removeMatching((x$5, x$6) -> true);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.report();
            return BoxedUnit.UNIT;
        });
    }

    public String buildRegistryName(Source source) {
        String defaultName;
        block7: {
            Option executorId;
            Option metricsNamespace;
            block6: {
                metricsNamespace = ((Option)this.conf.get(package$.MODULE$.METRICS_NAMESPACE())).orElse((Function0 & Serializable & scala.Serializable)() -> $this.conf.getOption("spark.app.id"));
                executorId = (Option)this.conf.get(package$.MODULE$.EXECUTOR_ID());
                defaultName = MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
                String string = this.instance();
                String string2 = "driver";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block6;
                String string3 = this.instance();
                String string4 = "executor";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block7;
            }
            if (metricsNamespace.isDefined() && executorId.isDefined()) {
                return MetricRegistry.name((String)((String)metricsNamespace.get()), (String[])new String[]{(String)executorId.get(), source.sourceName()});
            }
            if (metricsNamespace.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Using default name ").append(defaultName).append(" for source because neither ").append(package$.MODULE$.METRICS_NAMESPACE().key()).append(" nor spark.app.id is set.").toString());
            }
            if (executorId.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Using default name ").append(defaultName).append(" for source because spark.executor.id is ").append("not set.").toString());
            }
            return defaultName;
        }
        return defaultName;
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        Seq seq;
        ArrayBuffer<Source> arrayBuffer = this.sources();
        synchronized (arrayBuffer) {
            seq = ((SeqLike)this.sources().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$8)))).toSeq();
        }
        return seq;
    }

    public void registerSource(Source source) {
        ArrayBuffer<Source> arrayBuffer = this.sources();
        synchronized (arrayBuffer) {
            this.sources().$plus$eq((Object)source);
        }
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        ArrayBuffer<Source> arrayBuffer = this.sources();
        synchronized (arrayBuffer) {
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.sources().$minus$eq((Object)source);
        }
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching((name, x$9) -> name.startsWith(regName));
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                BoxedUnit boxedUnit;
                block7: {
                    try {
                        Sink sink;
                        Object object = kv._1();
                        String string = "servlet";
                        if (!(object != null ? !object.equals(string) : string != null)) {
                            MetricsServlet servlet = (MetricsServlet)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                            this.metricsServlet_$eq((Option<MetricsServlet>)new Some((Object)servlet));
                            boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        Object object2 = kv._1();
                        String string2 = "prometheusServlet";
                        if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                            PrometheusServlet servlet = (PrometheusServlet)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                            this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)servlet));
                            boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        try {
                            sink = (Sink)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            sink = (Sink)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(Properties.class, MetricRegistry.class, SecurityManager.class).newInstance(kv._2(), this.registry(), null);
                        }
                        Sink sink2 = sink;
                        boxedUnit = this.sinks().$plus$eq((Object)sink2);
                    }
                    catch (Exception e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                        throw e;
                    }
                }
                return boxedUnit;
            }
            return BoxedUnit.UNIT;
        });
    }

    public Properties metricsProperties() {
        return this.metricsConfig.properties();
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$8) {
        String string = x$8.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Source source = (Source)Utils$.MODULE$.classForName(classPath, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
            $this.registerSource(source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, SparkConf conf) {
        this.instance = instance;
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new ArrayBuffer();
        this.registry = new MetricRegistry();
        this.running = false;
        this.metricsServlet = None$.MODULE$;
        this.prometheusServlet = None$.MODULE$;
        this.metricsConfig.initialize();
    }
}

