/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ArrayColumnAccessor;
import org.apache.spark.sql.execution.columnar.BinaryColumnAccessor;
import org.apache.spark.sql.execution.columnar.BooleanColumnAccessor;
import org.apache.spark.sql.execution.columnar.ByteColumnAccessor;
import org.apache.spark.sql.execution.columnar.ColumnAccessor;
import org.apache.spark.sql.execution.columnar.CompactDecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.DecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.DoubleColumnAccessor;
import org.apache.spark.sql.execution.columnar.FloatColumnAccessor;
import org.apache.spark.sql.execution.columnar.IntColumnAccessor;
import org.apache.spark.sql.execution.columnar.LongColumnAccessor;
import org.apache.spark.sql.execution.columnar.MapColumnAccessor;
import org.apache.spark.sql.execution.columnar.NativeColumnAccessor;
import org.apache.spark.sql.execution.columnar.NullColumnAccessor;
import org.apache.spark.sql.execution.columnar.ShortColumnAccessor;
import org.apache.spark.sql.execution.columnar.StringColumnAccessor;
import org.apache.spark.sql.execution.columnar.StructColumnAccessor;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;

public final class ColumnAccessor$ {
    public static ColumnAccessor$ MODULE$;

    static {
        new ColumnAccessor$();
    }

    public ColumnAccessor apply(DataType dataType, ByteBuffer buffer) {
        DataType dataType2;
        while (true) {
            ByteBuffer buf = buffer.order(ByteOrder.nativeOrder());
            boolean bl = false;
            DecimalType decimalType = null;
            dataType2 = dataType;
            if (NullType$.MODULE$.equals(dataType2)) {
                return new NullColumnAccessor(buf);
            }
            if (BooleanType$.MODULE$.equals(dataType2)) {
                return new BooleanColumnAccessor(buf);
            }
            if (ByteType$.MODULE$.equals(dataType2)) {
                return new ByteColumnAccessor(buf);
            }
            if (ShortType$.MODULE$.equals(dataType2)) {
                return new ShortColumnAccessor(buf);
            }
            if (IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof YearMonthIntervalType)) {
                return new IntColumnAccessor(buf);
            }
            if (LongType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : (TimestampNTZType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DayTimeIntervalType))) {
                return new LongColumnAccessor(buf);
            }
            if (FloatType$.MODULE$.equals(dataType2)) {
                return new FloatColumnAccessor(buf);
            }
            if (DoubleType$.MODULE$.equals(dataType2)) {
                return new DoubleColumnAccessor(buf);
            }
            if (StringType$.MODULE$.equals(dataType2)) {
                return new StringColumnAccessor(buf);
            }
            if (BinaryType$.MODULE$.equals(dataType2)) {
                return new BinaryColumnAccessor(buf);
            }
            if (dataType2 instanceof DecimalType) {
                bl = true;
                decimalType = (DecimalType)dataType2;
                if (decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                    return new CompactDecimalColumnAccessor(buf, decimalType);
                }
            }
            if (bl) {
                return new DecimalColumnAccessor(buf, decimalType);
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                return new StructColumnAccessor(buf, structType);
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                return new ArrayColumnAccessor(buf, arrayType);
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                return new MapColumnAccessor(buf, mapType);
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        throw QueryExecutionErrors$.MODULE$.notSupportTypeError(dataType2);
    }

    public void decompress(ColumnAccessor columnAccessor, WritableColumnVector columnVector, int numRows) {
        ColumnAccessor columnAccessor2 = columnAccessor;
        if (columnAccessor2 instanceof NativeColumnAccessor) {
            NativeColumnAccessor nativeColumnAccessor = (NativeColumnAccessor)columnAccessor2;
            nativeColumnAccessor.decompress(columnVector, numRows);
            return;
        }
        throw QueryExecutionErrors$.MODULE$.notSupportNonPrimitiveTypeError();
    }

    public void decompress(byte[] array, WritableColumnVector columnVector, DataType dataType, int numRows) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        ColumnAccessor columnAccessor = this.apply(dataType, byteBuffer);
        this.decompress(columnAccessor, columnVector, numRows);
    }

    private ColumnAccessor$() {
        MODULE$ = this;
    }
}

