/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.CreateTableWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.WriteConfigMethods;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Bucket;
import org.apache.spark.sql.catalyst.expressions.Days;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Hours;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Months;
import org.apache.spark.sql.catalyst.expressions.Years;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect$;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0013'\u0005=B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"1a\u000b\u0001C\u0001M]Cqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004e\u0001\u0001\u0006I!\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019Q\u0007\u0001)A\u0005O\"91\u000e\u0001b\u0001\n\u0013a\u0007BB;\u0001A\u0003%Q\u000eC\u0004w\u0001\t\u0007I\u0011B<\t\u000f\u0005\u0015\u0001\u0001)A\u0005q\"I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011\u0002\u0005\n\u0003#\u0001\u0001\u0019!C\u0005\u0003'A\u0001\"a\b\u0001A\u0003&\u00111\u0002\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003GA\u0001\"!\u000e\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003GA\u0001\"!\u000f\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003w\u0001\u0001\u0019!C\u0005\u0003{A\u0011\"a\u0015\u0001\u0001\u0004%I!!\u0016\t\u0011\u0005e\u0003\u0001)Q\u0005\u0003\u007fAq!a\u0017\u0001\t\u0003\ni\u0006C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002n!9\u0011\u0011\u0005\u0001\u0005B\u0005e\u0004bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\tY\f\u0001C!\u0003{Cq!a0\u0001\t\u0013\t\t\rC\u0004\u0002J\u0002!\t%!0\t\u000f\u0005-\u0007\u0001\"\u0011\u0002>\"9\u0011Q\u001a\u0001\u0005\u0002\u0005u\u0006bBAs\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0003_\u0004A\u0011AA_\u0011\u001d\t\u0019\u0010\u0001C\u0005\u0003kDq!a?\u0001\t\u0013\tiPA\tECR\fgI]1nK^\u0013\u0018\u000e^3s-JR!a\n\u0015\u0002\u0007M\fHN\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001)\"\u0001M\u001f\u0014\u0007\u0001\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0004qeZT\"\u0001\u0014\n\u0005i2#!E\"sK\u0006$X\rV1cY\u0016<&/\u001b;feB\u0011A(\u0010\u0007\u0001\t\u0015q\u0004A1\u0001@\u0005\u0005!\u0016C\u0001!D!\t\u0011\u0014)\u0003\u0002Cg\t9aj\u001c;iS:<\u0007C\u0001\u001aE\u0013\t)5GA\u0002B]f\fQ\u0001^1cY\u0016\u0004\"\u0001S(\u000f\u0005%k\u0005C\u0001&4\u001b\u0005Y%B\u0001'/\u0003\u0019a$o\\8u}%\u0011ajM\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002Og\u0005\u0011Am\u001d\t\u0004qQ[\u0014BA+'\u0005\u001d!\u0015\r^1tKR\fa\u0001P5oSRtDc\u0001-Z5B\u0019\u0001\bA\u001e\t\u000b\u0019\u001b\u0001\u0019A$\t\u000bI\u001b\u0001\u0019A*\u0002\u0005\u00114W#A/\u0011\u0005y\u000bgB\u0001\u001d`\u0013\t\u0001g%A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'!\u0003#bi\u00064%/Y7f\u0015\t\u0001g%A\u0002eM\u0002\nAb\u001d9be.\u001cVm]:j_:,\u0012a\u001a\t\u0003q!L!!\u001b\u0014\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001bM\u0004\u0018M]6TKN\u001c\u0018n\u001c8!\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u0001n!\rq'o\u0012\b\u0003_Ft!A\u00139\n\u0003QJ!\u0001Y\u001a\n\u0005M$(aA*fc*\u0011\u0001mM\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0013a\u00037pO&\u001c\u0017\r\u001c)mC:,\u0012\u0001\u001f\t\u0004s\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003{z\fQ\u0001\u001d7b]NT!a \u0014\u0002\u0011\r\fG/\u00197zgRL1!a\u0001{\u0005-aunZ5dC2\u0004F.\u00198\u0002\u00191|w-[2bYBc\u0017M\u001c\u0011\u0002\u0011A\u0014xN^5eKJ,\"!a\u0003\u0011\tI\niaR\u0005\u0004\u0003\u001f\u0019$AB(qi&|g.\u0001\u0007qe>4\u0018\u000eZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005m\u0001c\u0001\u001a\u0002\u0018%\u0019\u0011\u0011D\u001a\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003;i\u0011\u0011!a\u0001\u0003\u0017\t1\u0001\u001f\u00132\u0003%\u0001(o\u001c<jI\u0016\u0014\b%A\u0004paRLwN\\:\u0016\u0005\u0005\u0015\u0002CBA\u0014\u0003c9u)\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u001diW\u000f^1cY\u0016T1!a\f4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\tICA\u0004ICNDW*\u00199\u0002\u0011=\u0004H/[8og\u0002\n!\u0002\u001d:pa\u0016\u0014H/[3t\u0003-\u0001(o\u001c9feRLWm\u001d\u0011\u0002\u0019A\f'\u000f^5uS>t\u0017N\\4\u0016\u0005\u0005}\u0002#\u0002\u001a\u0002\u000e\u0005\u0005\u0003\u0003\u00028s\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0006fqB\u0014Xm]:j_:\u001c(bAA'M\u0005I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003#\n9EA\u0005Ue\u0006t7OZ8s[\u0006\u0001\u0002/\u0019:uSRLwN\\5oO~#S-\u001d\u000b\u0005\u0003+\t9\u0006C\u0005\u0002\u001eQ\t\t\u00111\u0001\u0002@\u0005i\u0001/\u0019:uSRLwN\\5oO\u0002\nQ!^:j]\u001e$2aNA0\u0011\u0019\t9A\u0006a\u0001\u000f\u00061q\u000e\u001d;j_:$R\u0001WA3\u0003SBa!a\u001a\u0018\u0001\u00049\u0015aA6fs\"1\u00111N\fA\u0002\u001d\u000bQA^1mk\u0016$2\u0001WA8\u0011\u001d\t\t\u0003\u0007a\u0001\u0003c\u0002b!a\u001d\u0002v\u001d;UBAA\u0017\u0013\u0011\t9(!\f\u0003\u00075\u000b\u0007\u000fF\u0002Y\u0003wBq!!\t\u001a\u0001\u0004\ti\b\u0005\u0004\u0002\u0000\u0005%uiR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006!Q\u000f^5m\u0015\t\t9)\u0001\u0003kCZ\f\u0017\u0002BA<\u0003\u0003\u000bQ\u0002^1cY\u0016\u0004&o\u001c9feRLH#B\u001c\u0002\u0010\u0006M\u0005BBAI5\u0001\u0007q)\u0001\u0005qe>\u0004XM\u001d;z\u0011\u0019\tYG\u0007a\u0001\u000f\u0006i\u0001/\u0019:uSRLwN\\3e\u0005f$RaNAM\u0003GCq!a'\u001c\u0001\u0004\ti*\u0001\u0004d_2,XN\u001c\t\u0004q\u0005}\u0015bAAQM\t11i\u001c7v[:Dq!!*\u001c\u0001\u0004\t9+A\u0004d_2,XN\\:\u0011\u000bI\nI+!(\n\u0007\u0005-6G\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3aGAX!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[g\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u00161\u0017\u0002\bm\u0006\u0014\u0018M]4t\u0003\u0019\u0019'/Z1uKR\u0011\u0011QC\u0001\u000fEVLG\u000e\u001a+bE2,7\u000b]3d)\t\t\u0019\rE\u0002z\u0003\u000bL1!a2{\u0005M)fN]3t_24X\r\u001a+bE2,7\u000b]3d\u0003\u001d\u0011X\r\u001d7bG\u0016\fqb\u0019:fCR,wJ\u001d*fa2\f7-Z\u0001\u0007CB\u0004XM\u001c3)\u000b\u0001\n\t.a9\u0011\u000bI\n\u0019.a6\n\u0007\u0005U7G\u0001\u0004uQJ|wo\u001d\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c@\u0002\u0011\u0005t\u0017\r\\=tSNLA!!9\u0002\\\n!bj\\*vG\"$\u0016M\u00197f\u000bb\u001cW\r\u001d;j_:\u001c#!a6\u0002\u0013=4XM]<sSR,G\u0003BA\u000b\u0003SDq!a;\"\u0001\u0004\ti*A\u0005d_:$\u0017\u000e^5p]\"*\u0011%!5\u0002d\u0006\u0019rN^3soJLG/\u001a)beRLG/[8og\"*!%!5\u0002d\u0006Q!/\u001e8D_6l\u0017M\u001c3\u0015\t\u0005U\u0011q\u001f\u0005\u0007\u0003s\u001c\u0003\u0019\u0001=\u0002\u000f\r|W.\\1oI\u0006y\u0011N\u001c;fe:\fGNU3qY\u0006\u001cW\r\u0006\u0003\u0002\u0016\u0005}\bb\u0002B\u0001I\u0001\u0007!1A\u0001\t_J\u001c%/Z1uKB\u0019!G!\u0002\n\u0007\t\u001d1GA\u0004C_>dW-\u00198)\u0007\u0001\u0011Y\u0001\u0005\u0003\u0003\u000e\tEQB\u0001B\b\u0015\r\t)\fK\u0005\u0005\u0005'\u0011yA\u0001\u0007FqB,'/[7f]R\fG\u000e")
public final class DataFrameWriterV2<T>
implements CreateTableWriter<T> {
    private final Dataset<Row> df;
    private final SparkSession sparkSession;
    private final Seq<String> tableName;
    private final LogicalPlan logicalPlan;
    private Option<String> provider;
    private final HashMap<String, String> options;
    private final HashMap<String, String> properties;
    private Option<Seq<Transform>> partitioning;

    @Override
    public Object option(String key, boolean value) {
        return WriteConfigMethods.option$((WriteConfigMethods)this, key, value);
    }

    @Override
    public Object option(String key, long value) {
        return WriteConfigMethods.option$((WriteConfigMethods)this, key, value);
    }

    @Override
    public Object option(String key, double value) {
        return WriteConfigMethods.option$((WriteConfigMethods)this, key, value);
    }

    public CreateTableWriter<T> partitionedBy(Column column, Column ... columns) {
        return this.partitionedBy(column, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])columns));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private Seq<String> tableName() {
        return this.tableName;
    }

    private LogicalPlan logicalPlan() {
        return this.logicalPlan;
    }

    private Option<String> provider() {
        return this.provider;
    }

    private void provider_$eq(Option<String> x$1) {
        this.provider = x$1;
    }

    private HashMap<String, String> options() {
        return this.options;
    }

    private HashMap<String, String> properties() {
        return this.properties;
    }

    private Option<Seq<Transform>> partitioning() {
        return this.partitioning;
    }

    private void partitioning_$eq(Option<Seq<Transform>> x$1) {
        this.partitioning = x$1;
    }

    @Override
    public CreateTableWriter<T> using(String provider) {
        this.provider_$eq((Option<String>)new Some((Object)provider));
        return this;
    }

    @Override
    public DataFrameWriterV2<T> option(String key, String value) {
        this.options().put((Object)key, (Object)value);
        return this;
    }

    @Override
    public DataFrameWriterV2<T> options(Map<String, String> options) {
        options.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return this.options().put((Object)key, (Object)value);
            }
            throw new MatchError((Object)tuple2);
        });
        return this;
    }

    @Override
    public DataFrameWriterV2<T> options(java.util.Map<String, String> options) {
        this.options((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala());
        return this;
    }

    @Override
    public CreateTableWriter<T> tableProperty(String property, String value) {
        this.properties().put((Object)property, (Object)value);
        return this;
    }

    @Override
    public CreateTableWriter<T> partitionedBy(Column column, Seq<Column> columns) {
        Column column2 = column;
        Seq asTransforms = (Seq)((TraversableLike)((TraversableLike)columns.$plus$colon((Object)column2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.expr(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Hours hours;
            Expression attr;
            Days days;
            Expression attr2;
            Months months;
            Expression attr3;
            Years years;
            Expression attr4;
            Expression expression = x0$1;
            if (expression instanceof Years && (attr4 = (years = (Years)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr4;
                return LogicalExpressions$.MODULE$.years(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Months && (attr3 = (months = (Months)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr3;
                return LogicalExpressions$.MODULE$.months(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Days && (attr2 = (days = (Days)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr2;
                return LogicalExpressions$.MODULE$.days(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Hours && (attr = (hours = (Hours)expression).child()) instanceof Attribute) {
                Attribute attribute = (Attribute)attr;
                return LogicalExpressions$.MODULE$.hours(DataFrameWriterV2.ref$1(attribute.name()));
            }
            if (expression instanceof Bucket) {
                Bucket bucket = (Bucket)expression;
                Literal literal = bucket.numBuckets();
                Expression attr5 = bucket.child();
                if (literal != null) {
                    Object numBuckets = literal.value();
                    DataType dataType = literal.dataType();
                    if (numBuckets instanceof Integer) {
                        int n = BoxesRunTime.unboxToInt((Object)numBuckets);
                        if (IntegerType$.MODULE$.equals(dataType) && attr5 instanceof Attribute) {
                            Attribute attribute = (Attribute)attr5;
                            return LogicalExpressions$.MODULE$.bucket(n, (NamedReference[])((Object[])new NamedReference[]{DataFrameWriterV2.ref$1(attribute.name())}));
                        }
                    }
                }
            }
            if (expression instanceof Attribute) {
                Attribute attribute = (Attribute)expression;
                return LogicalExpressions$.MODULE$.identity(DataFrameWriterV2.ref$1(attribute.name()));
            }
            throw QueryCompilationErrors$.MODULE$.invalidPartitionTransformationError(expression);
        }, Seq$.MODULE$.canBuildFrom());
        this.partitioning_$eq((Option<Seq<Transform>>)new Some((Object)asTransforms));
        return this;
    }

    @Override
    public void create() {
        this.runCommand((LogicalPlan)new CreateTableAsSelect((LogicalPlan)new UnresolvedIdentifier(this.tableName(), UnresolvedIdentifier$.MODULE$.apply$default$2()), (Seq)this.partitioning().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), this.logicalPlan(), (TableSpecBase)this.buildTableSpec(), this.options().toMap(Predef$.MODULE$.$conforms()), false, CreateTableAsSelect$.MODULE$.apply$default$7()));
    }

    private UnresolvedTableSpec buildTableSpec() {
        boolean ignorePathOption = BoxesRunTime.unboxToBoolean((Object)this.sparkSession().sessionState().conf().getConf(SQLConf$.MODULE$.LEGACY_DF_WRITER_V2_IGNORE_PATH_OPTION()));
        return new UnresolvedTableSpec(this.properties().toMap(Predef$.MODULE$.$conforms()), this.provider(), new OptionList((Seq)Nil$.MODULE$), (Option)(ignorePathOption ? None$.MODULE$ : CaseInsensitiveMap$.MODULE$.apply(this.options().toMap(Predef$.MODULE$.$conforms())).get("path")), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    }

    @Override
    public void replace() {
        this.internalReplace(false);
    }

    @Override
    public void createOrReplace() {
        this.internalReplace(true);
    }

    public void append() throws NoSuchTableException {
        AppendData append = AppendData$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()).requireWritePrivileges((Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)Nil$.MODULE$)), this.logicalPlan(), this.options().toMap(Predef$.MODULE$.$conforms()));
        this.runCommand((LogicalPlan)append);
    }

    public void overwrite(Column condition) throws NoSuchTableException {
        OverwriteByExpression overwrite = OverwriteByExpression$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()).requireWritePrivileges((Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)new .colon.colon((Object)TableWritePrivilege.DELETE, (List)Nil$.MODULE$))), this.logicalPlan(), condition.expr(), this.options().toMap(Predef$.MODULE$.$conforms()));
        this.runCommand((LogicalPlan)overwrite);
    }

    public void overwritePartitions() throws NoSuchTableException {
        OverwritePartitionsDynamic dynamicOverwrite = OverwritePartitionsDynamic$.MODULE$.byName((NamedRelation)new UnresolvedRelation(this.tableName(), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()).requireWritePrivileges((Seq)new .colon.colon((Object)TableWritePrivilege.INSERT, (List)new .colon.colon((Object)TableWritePrivilege.DELETE, (List)Nil$.MODULE$))), this.logicalPlan(), this.options().toMap(Predef$.MODULE$.$conforms()));
        this.runCommand((LogicalPlan)dynamicOverwrite);
    }

    private void runCommand(LogicalPlan command) {
        QueryExecution qe = new QueryExecution(this.sparkSession(), command, this.df().queryExecution().tracker(), QueryExecution$.MODULE$.$lessinit$greater$default$4());
        qe.assertCommandExecuted();
    }

    private void internalReplace(boolean orCreate) {
        this.runCommand((LogicalPlan)new ReplaceTableAsSelect((LogicalPlan)new UnresolvedIdentifier(this.tableName(), UnresolvedIdentifier$.MODULE$.apply$default$2()), (Seq)this.partitioning().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), this.logicalPlan(), (TableSpecBase)this.buildTableSpec(), this.options().toMap(Predef$.MODULE$.$conforms()), orCreate, ReplaceTableAsSelect$.MODULE$.apply$default$7()));
    }

    private static final NamedReference ref$1(String name) {
        return LogicalExpressions$.MODULE$.parseReference(name);
    }

    public DataFrameWriterV2(String table, Dataset<T> ds) {
        WriteConfigMethods.$init$(this);
        this.df = ds.toDF();
        this.sparkSession = ds.sparkSession();
        this.tableName = this.sparkSession().sessionState().sqlParser().parseMultipartIdentifier(table);
        this.logicalPlan = this.df().queryExecution().logical();
        this.provider = None$.MODULE$;
        this.options = new HashMap();
        this.properties = new HashMap();
        this.partitioning = None$.MODULE$;
    }
}

