/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.Util;
import org.apache.datasketches.kll.KllDirectCompactDoublesSketch;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesHelper;
import org.apache.datasketches.kll.KllDoublesSketchIterator;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

public abstract class KllDoublesSketch
extends KllSketch {
    KllDoublesSketch(WritableMemory wmem, MemoryRequestServer memReqSvr) {
        super(KllSketch.SketchType.DOUBLES_SKETCH, wmem, memReqSvr);
    }

    public static int getMaxSerializedSizeBytes(int k, long n, boolean updatableMemoryFormat) {
        return KllDoublesSketch.getMaxSerializedSizeBytes(k, n, KllSketch.SketchType.DOUBLES_SKETCH, updatableMemoryFormat);
    }

    public static KllDoublesSketch heapify(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        if (KllPreambleUtil.getMemoryUpdatableFormatFlag(srcMem)) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_BE_UPDATABLE_FORMAT);
        }
        return KllHeapDoublesSketch.heapifyImpl(srcMem);
    }

    public static KllDoublesSketch newDirectInstance(int k, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectDoublesSketch.newDirectInstance(k, 8, dstMem, memReqSvr);
    }

    public static KllDoublesSketch newDirectInstance(WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectDoublesSketch.newDirectInstance(200, 8, dstMem, memReqSvr);
    }

    public static KllDoublesSketch newHeapInstance() {
        return new KllHeapDoublesSketch(200, 8);
    }

    public static KllDoublesSketch newHeapInstance(int k) {
        return new KllHeapDoublesSketch(k, 8);
    }

    public static KllDoublesSketch wrap(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem);
        if (memVal.updatableMemFormat) {
            return new KllDirectDoublesSketch((WritableMemory)srcMem, null, memVal);
        }
        return new KllDirectCompactDoublesSketch(srcMem, memVal);
    }

    public static KllDoublesSketch writableWrap(WritableMemory srcMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)srcMem);
        if (memVal.updatableMemFormat) {
            if (!memVal.readOnly) {
                Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
            }
            return new KllDirectDoublesSketch(srcMem, memReqSvr, memVal);
        }
        return new KllDirectCompactDoublesSketch((Memory)srcMem, memVal);
    }

    public double[] getCDF(double[] splitPoints) {
        return KllDoublesHelper.getDoublesPmfOrCdf(this, splitPoints, true);
    }

    public double getMaxValue() {
        return this.getMaxDoubleValue();
    }

    public double getMinValue() {
        return this.getMinDoubleValue();
    }

    public double[] getPMF(double[] splitPoints) {
        return KllDoublesHelper.getDoublesPmfOrCdf(this, splitPoints, false);
    }

    public double getQuantile(double fraction) {
        return KllDoublesHelper.getDoublesQuantile(this, fraction);
    }

    public double getQuantileLowerBound(double fraction) {
        return this.getQuantile(Math.max(0.0, fraction - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    public double[] getQuantiles(double[] fractions) {
        return KllDoublesHelper.getDoublesQuantiles(this, fractions);
    }

    public double[] getQuantiles(int numEvenlySpaced) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getQuantiles(Util.evenlySpaced(0.0, 1.0, numEvenlySpaced));
    }

    public double getQuantileUpperBound(double fraction) {
        return this.getQuantile(Math.min(1.0, fraction + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    public double getRank(double value) {
        return KllDoublesHelper.getDoubleRank(this, value);
    }

    public KllDoublesSketchIterator iterator() {
        return new KllDoublesSketchIterator(this.getDoubleItemsArray(), this.getLevelsArray(), this.getNumLevels());
    }

    public void update(double value) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllDoublesHelper.updateDouble(this, value);
    }

    @Override
    float[] getFloatItemsArray() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return null;
    }

    @Override
    float getMaxFloatValue() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Float.NaN;
    }

    @Override
    float getMinFloatValue() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Float.NaN;
    }

    @Override
    void setFloatItemsArray(float[] floatItems) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setFloatItemsArrayAt(int index, float value) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setMaxFloatValue(float value) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setMinFloatValue(float value) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }
}

