/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.examples.ml.DecisionTreeExample$;
import org.apache.spark.examples.ml.LogisticRegressionExample;
import org.apache.spark.examples.ml.LogisticRegressionExample$;
import org.apache.spark.examples.ml.LogisticRegressionExample$Params$;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class LogisticRegressionExample$ {
    public static final LogisticRegressionExample$ MODULE$ = new LogisticRegressionExample$();

    public void main(String[] args) {
        LogisticRegressionExample.Params defaultParams = new LogisticRegressionExample.Params(LogisticRegressionExample$Params$.MODULE$.apply$default$1(), LogisticRegressionExample$Params$.MODULE$.apply$default$2(), LogisticRegressionExample$Params$.MODULE$.apply$default$3(), LogisticRegressionExample$Params$.MODULE$.apply$default$4(), LogisticRegressionExample$Params$.MODULE$.apply$default$5(), LogisticRegressionExample$Params$.MODULE$.apply$default$6(), LogisticRegressionExample$Params$.MODULE$.apply$default$7(), LogisticRegressionExample$Params$.MODULE$.apply$default$8(), LogisticRegressionExample$Params$.MODULE$.apply$default$9());
        OptionParser<LogisticRegressionExample.Params> parser = new OptionParser<LogisticRegressionExample.Params>(defaultParams){

            public static final /* synthetic */ LogisticRegressionExample.Params $anonfun$new$1(double x, LogisticRegressionExample.Params c) {
                double x$1 = x;
                String x$2 = c.copy$default$1();
                String x$3 = c.copy$default$2();
                String x$4 = c.copy$default$3();
                double x$5 = c.copy$default$5();
                int x$6 = c.copy$default$6();
                boolean x$7 = c.copy$default$7();
                double x$8 = c.copy$default$8();
                double x$9 = c.copy$default$9();
                return c.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9);
            }

            public static final /* synthetic */ LogisticRegressionExample.Params $anonfun$new$2(double x, LogisticRegressionExample.Params c) {
                double x$10 = x;
                String x$11 = c.copy$default$1();
                String x$12 = c.copy$default$2();
                String x$13 = c.copy$default$3();
                double x$14 = c.copy$default$4();
                int x$15 = c.copy$default$6();
                boolean x$16 = c.copy$default$7();
                double x$17 = c.copy$default$8();
                double x$18 = c.copy$default$9();
                return c.copy(x$11, x$12, x$13, x$14, x$10, x$15, x$16, x$17, x$18);
            }

            public static final /* synthetic */ LogisticRegressionExample.Params $anonfun$new$3(int x, LogisticRegressionExample.Params c) {
                int x$19 = x;
                String x$20 = c.copy$default$1();
                String x$21 = c.copy$default$2();
                String x$22 = c.copy$default$3();
                double x$23 = c.copy$default$4();
                double x$24 = c.copy$default$5();
                boolean x$25 = c.copy$default$7();
                double x$26 = c.copy$default$8();
                double x$27 = c.copy$default$9();
                return c.copy(x$20, x$21, x$22, x$23, x$24, x$19, x$25, x$26, x$27);
            }

            public static final /* synthetic */ LogisticRegressionExample.Params $anonfun$new$4(boolean x, LogisticRegressionExample.Params c) {
                boolean x$28 = x;
                String x$29 = c.copy$default$1();
                String x$30 = c.copy$default$2();
                String x$31 = c.copy$default$3();
                double x$32 = c.copy$default$4();
                double x$33 = c.copy$default$5();
                int x$34 = c.copy$default$6();
                double x$35 = c.copy$default$8();
                double x$36 = c.copy$default$9();
                return c.copy(x$29, x$30, x$31, x$32, x$33, x$34, x$28, x$35, x$36);
            }

            public static final /* synthetic */ LogisticRegressionExample.Params $anonfun$new$5(double x, LogisticRegressionExample.Params c) {
                double x$37 = x;
                String x$38 = c.copy$default$1();
                String x$39 = c.copy$default$2();
                String x$40 = c.copy$default$3();
                double x$41 = c.copy$default$4();
                double x$42 = c.copy$default$5();
                int x$43 = c.copy$default$6();
                boolean x$44 = c.copy$default$7();
                double x$45 = c.copy$default$9();
                return c.copy(x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$37, x$45);
            }

            public static final /* synthetic */ LogisticRegressionExample.Params $anonfun$new$6(double x, LogisticRegressionExample.Params c) {
                double x$46 = x;
                String x$47 = c.copy$default$1();
                String x$48 = c.copy$default$2();
                String x$49 = c.copy$default$3();
                double x$50 = c.copy$default$4();
                double x$51 = c.copy$default$5();
                int x$52 = c.copy$default$6();
                boolean x$53 = c.copy$default$7();
                double x$54 = c.copy$default$8();
                return c.copy(x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$46);
            }
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionExample: an example Logistic Regression with Elastic-Net app."}));
                this.opt("regParam", Read$.MODULE$.doubleRead()).text(new StringBuilder(35).append("regularization parameter, default: ").append(defaultParams$1.regParam()).toString()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("elasticNetParam", Read$.MODULE$.doubleRead()).text(new StringBuilder(0).append("ElasticNet mixing parameter. For alpha = 0, the penalty is an L2 penalty. ").append("For alpha = 1, it is an L1 penalty. For 0 < alpha < 1, the penalty is a combination of ").append(new StringBuilder(20).append("L1 and L2, default: ").append(defaultParams$1.elasticNetParam()).toString()).toString()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("maxIter", Read$.MODULE$.intRead()).text(new StringBuilder(39).append("maximum number of iterations, default: ").append(defaultParams$1.maxIter()).toString()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("fitIntercept", Read$.MODULE$.booleanRead()).text(new StringBuilder(43).append("whether to fit an intercept term, default: ").append(defaultParams$1.fitIntercept()).toString()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToBoolean((Object)x), c));
                this.opt("tol", Read$.MODULE$.doubleRead()).text(new StringBuilder(0).append("the convergence tolerance of iterations, Smaller value will lead ").append(new StringBuilder(62).append("to higher accuracy with the cost of more iterations, default: ").append(defaultParams$1.tol()).toString()).toString()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder(0).append("fraction of data to hold out for testing. If given option testInput, ").append(new StringBuilder(33).append("this option is ignored. default: ").append(defaultParams$1.fracTest()).toString()).toString()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$6(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder(0).append("input path to test dataset. If given, option fracTest is ignored.").append(new StringBuilder(10).append(" default: ").append(defaultParams$1.testInput()).toString()).toString()).action((Function2 & Serializable)(x, c) -> {
                    String x$55 = x;
                    String x$56 = c.copy$default$1();
                    String x$57 = c.copy$default$3();
                    double x$58 = c.copy$default$4();
                    double x$59 = c.copy$default$5();
                    int x$60 = c.copy$default$6();
                    boolean x$61 = c.copy$default$7();
                    double x$62 = c.copy$default$8();
                    double x$63 = c.copy$default$9();
                    return c.copy(x$56, x$55, x$57, x$58, x$59, x$60, x$61, x$62, x$63);
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2 & Serializable)(x, c) -> {
                    String x$64 = x;
                    String x$65 = c.copy$default$1();
                    String x$66 = c.copy$default$2();
                    double x$67 = c.copy$default$4();
                    double x$68 = c.copy$default$5();
                    int x$69 = c.copy$default$6();
                    boolean x$70 = c.copy$default$7();
                    double x$71 = c.copy$default$8();
                    double x$72 = c.copy$default$9();
                    return c.copy(x$65, x$66, x$64, x$67, x$68, x$69, x$70, x$71, x$72);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9()));
                this.checkConfig((Function1 & Serializable)params -> params.fracTest() < 0.0 || params.fracTest() >= 1.0 ? this.failure(new StringBuilder(46).append("fracTest ").append(params.fracTest()).append(" value incorrect; should be in [0,1).").toString()) : this.success());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$10(org.apache.spark.examples.ml.LogisticRegressionExample$$anon$1 org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$6$adapted(java.lang.Object org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$7(java.lang.String org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$8(java.lang.String org.apache.spark.examples.ml.LogisticRegressionExample$Params ), $anonfun$new$9(java.lang.String org.apache.spark.examples.ml.LogisticRegressionExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        LogisticRegressionExample.Params params = (LogisticRegressionExample.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(LogisticRegressionExample.Params params) {
        Dataset dataset;
        Dataset test;
        SparkSession spark;
        block3: {
            Tuple2<Dataset<Row>, Dataset<Row>> tuple2;
            block2: {
                spark = SparkSession$.MODULE$.builder().appName(new StringBuilder(31).append("LogisticRegressionExample with ").append(params).toString()).getOrCreate();
                Predef$.MODULE$.println((Object)new StringBuilder(43).append("LogisticRegressionExample with parameters:\n").append(params).toString());
                tuple2 = DecisionTreeExample$.MODULE$.loadDatasets(params.input(), params.dataFormat(), params.testInput(), "classification", params.fracTest());
                if (tuple2 == null) break block2;
                Dataset training = (Dataset)tuple2._1();
                test = (Dataset)tuple2._2();
                if (training == null) break block2;
                dataset = training;
                if (test != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Dataset dataset2 = test;
        Tuple2 tuple2 = new Tuple2((Object)dataset, (Object)dataset2);
        Tuple2 tuple22 = tuple2;
        Dataset training = (Dataset)tuple22._1();
        Dataset test2 = (Dataset)tuple22._2();
        ArrayBuffer stages = new ArrayBuffer();
        StringIndexer labelIndexer = new StringIndexer().setInputCol("label").setOutputCol("indexedLabel");
        stages.$plus$eq((Object)labelIndexer);
        LogisticRegression lor = ((LogisticRegression)new LogisticRegression().setFeaturesCol("features").setLabelCol("indexedLabel")).setRegParam(params.regParam()).setElasticNetParam(params.elasticNetParam()).setMaxIter(params.maxIter()).setTol(params.tol()).setFitIntercept(params.fitIntercept());
        stages.$plus$eq((Object)lor);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])stages.toArray(ClassTag$.MODULE$.apply(PipelineStage.class)));
        long startTime = System.nanoTime();
        PipelineModel pipelineModel = pipeline.fit(training);
        double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Training time: ").append(elapsedTime).append(" seconds").toString());
        LogisticRegressionModel lorModel = (LogisticRegressionModel)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])pipelineModel.stages()));
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Weights: ").append(lorModel.coefficients()).append(" Intercept: ").append(lorModel.intercept()).toString());
        Predef$.MODULE$.println((Object)"Training data results:");
        DecisionTreeExample$.MODULE$.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)training, "indexedLabel");
        Predef$.MODULE$.println((Object)"Test data results:");
        DecisionTreeExample$.MODULE$.evaluateClassificationModel((Transformer)pipelineModel, (Dataset<Row>)test2, "indexedLabel");
        spark.stop();
    }

    private LogisticRegressionExample$() {
    }
}

