/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.SerializationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.header.Headers;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization.Deserializer;

public class IntegerDeserializer
implements Deserializer<Integer> {
    @Override
    public Integer deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 4) {
            throw new SerializationException("Size of data received by IntegerDeserializer is not 4");
        }
        int value = 0;
        for (byte b : data) {
            value <<= 8;
            value |= b & 0xFF;
        }
        return value;
    }

    @Override
    public Integer deserialize(String topic, Headers headers, ByteBuffer data) {
        if (data == null) {
            return null;
        }
        if (data.remaining() != 4) {
            throw new SerializationException("Size of data received by IntegerDeserializer is not 4");
        }
        return data.getInt(data.position());
    }
}

