/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;

public class ConsumerGroupDescribeRequest
extends AbstractRequest {
    private final ConsumerGroupDescribeRequestData data;

    public ConsumerGroupDescribeRequest(ConsumerGroupDescribeRequestData data, short version) {
        super(ApiKeys.CONSUMER_GROUP_DESCRIBE, version);
        this.data = data;
    }

    @Override
    public ConsumerGroupDescribeResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ConsumerGroupDescribeResponseData data = new ConsumerGroupDescribeResponseData().setThrottleTimeMs(throttleTimeMs);
        this.data.groupIds().forEach(groupId -> data.groups().add(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId((String)groupId).setErrorCode(Errors.forException(e).code())));
        return new ConsumerGroupDescribeResponse(data);
    }

    @Override
    public ConsumerGroupDescribeRequestData data() {
        return this.data;
    }

    public static ConsumerGroupDescribeRequest parse(ByteBuffer buffer, short version) {
        return new ConsumerGroupDescribeRequest(new ConsumerGroupDescribeRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static List<ConsumerGroupDescribeResponseData.DescribedGroup> getErrorDescribedGroupList(List<String> groupIds, Errors error) {
        return groupIds.stream().map(groupId -> new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId((String)groupId).setErrorCode(error.code())).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractRequest.Builder<ConsumerGroupDescribeRequest> {
        private final ConsumerGroupDescribeRequestData data;

        public Builder(ConsumerGroupDescribeRequestData data) {
            this(data, false);
        }

        public Builder(ConsumerGroupDescribeRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.CONSUMER_GROUP_DESCRIBE, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public ConsumerGroupDescribeRequest build(short version) {
            return new ConsumerGroupDescribeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

