/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.RequestState;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.ErrorEvent;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.metrics.HeartbeatMetricsManager;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.RetriableException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.metrics.Metrics;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.ShareGroupHeartbeatRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.ShareGroupHeartbeatResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Time;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Timer;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

public class ShareHeartbeatRequestManager
implements RequestManager {
    private final Logger logger;
    private final int maxPollIntervalMs;
    private final CoordinatorRequestManager coordinatorRequestManager;
    private final HeartbeatRequestState heartbeatRequestState;
    private final HeartbeatState heartbeatState;
    private final ShareMembershipManager shareMembershipManager;
    private final BackgroundEventHandler backgroundEventHandler;
    private final Timer pollTimer;
    private final HeartbeatMetricsManager metricsManager;

    public ShareHeartbeatRequestManager(LogContext logContext, Time time, ConsumerConfig config, CoordinatorRequestManager coordinatorRequestManager, SubscriptionState subscriptions, ShareMembershipManager shareMembershipManager, BackgroundEventHandler backgroundEventHandler, Metrics metrics) {
        this.coordinatorRequestManager = coordinatorRequestManager;
        this.logger = logContext.logger(this.getClass());
        this.shareMembershipManager = shareMembershipManager;
        this.backgroundEventHandler = backgroundEventHandler;
        this.maxPollIntervalMs = config.getInt("max.poll.interval.ms");
        long retryBackoffMs = config.getLong("retry.backoff.ms");
        long retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
        this.heartbeatState = new HeartbeatState(subscriptions, shareMembershipManager);
        this.heartbeatRequestState = new HeartbeatRequestState(logContext, time, 0L, retryBackoffMs, retryBackoffMaxMs, (double)this.maxPollIntervalMs);
        this.pollTimer = time.timer(this.maxPollIntervalMs);
        this.metricsManager = new HeartbeatMetricsManager(metrics, "consumer-share");
    }

    ShareHeartbeatRequestManager(LogContext logContext, Timer timer, ConsumerConfig config, CoordinatorRequestManager coordinatorRequestManager, ShareMembershipManager shareMembershipManager, HeartbeatState heartbeatState, HeartbeatRequestState heartbeatRequestState, BackgroundEventHandler backgroundEventHandler, Metrics metrics) {
        this.logger = logContext.logger(this.getClass());
        this.maxPollIntervalMs = config.getInt("max.poll.interval.ms");
        this.coordinatorRequestManager = coordinatorRequestManager;
        this.heartbeatRequestState = heartbeatRequestState;
        this.heartbeatState = heartbeatState;
        this.shareMembershipManager = shareMembershipManager;
        this.backgroundEventHandler = backgroundEventHandler;
        this.pollTimer = timer;
        this.metricsManager = new HeartbeatMetricsManager(metrics, "consumer-share");
    }

    @Override
    public NetworkClientDelegate.PollResult poll(long currentTimeMs) {
        boolean heartbeatNow;
        if (!this.coordinatorRequestManager.coordinator().isPresent() || this.shareMembershipManager.shouldSkipHeartbeat() || this.pollTimer.isExpired()) {
            this.shareMembershipManager.onHeartbeatRequestSkipped();
            return NetworkClientDelegate.PollResult.EMPTY;
        }
        this.pollTimer.update(currentTimeMs);
        if (this.pollTimer.isExpired() && !this.shareMembershipManager.isLeavingGroup()) {
            this.logger.warn("Share consumer poll timeout has expired. This means the time between subsequent calls to poll() was longer than the configured max.poll.interval.ms, which typically implies that the poll loop is spending too much time processing messages. You can address this either by increasing max.poll.interval.ms or by reducing the maximum size of batches returned in poll() with max.poll.records.");
            this.shareMembershipManager.transitionToSendingLeaveGroup(true);
            NetworkClientDelegate.UnsentRequest request = this.makeHeartbeatRequest(currentTimeMs, true);
            this.heartbeatRequestState.reset();
            this.heartbeatState.reset();
            return new NetworkClientDelegate.PollResult(this.heartbeatRequestState.heartbeatIntervalMs, Collections.singletonList(request));
        }
        boolean bl = heartbeatNow = this.shareMembershipManager.shouldHeartbeatNow() && !this.heartbeatRequestState.requestInFlight();
        if (!this.heartbeatRequestState.canSendRequest(currentTimeMs) && !heartbeatNow) {
            return new NetworkClientDelegate.PollResult(this.heartbeatRequestState.timeToNextHeartbeatMs(currentTimeMs));
        }
        NetworkClientDelegate.UnsentRequest request = this.makeHeartbeatRequest(currentTimeMs, false);
        return new NetworkClientDelegate.PollResult(this.heartbeatRequestState.heartbeatIntervalMs, Collections.singletonList(request));
    }

    public ShareMembershipManager membershipManager() {
        return this.shareMembershipManager;
    }

    @Override
    public long maximumTimeToWait(long currentTimeMs) {
        this.pollTimer.update(currentTimeMs);
        if (this.pollTimer.isExpired() || this.shareMembershipManager.shouldHeartbeatNow() && !this.heartbeatRequestState.requestInFlight()) {
            return 0L;
        }
        return Math.min(this.pollTimer.remainingMs() / 2L, this.heartbeatRequestState.timeToNextHeartbeatMs(currentTimeMs));
    }

    public void resetPollTimer(long pollMs) {
        if (this.pollTimer.isExpired()) {
            this.logger.debug("Poll timer has been reset after it had expired");
            this.shareMembershipManager.maybeRejoinStaleMember();
        }
        this.pollTimer.update(pollMs);
        this.pollTimer.reset(this.maxPollIntervalMs);
    }

    private NetworkClientDelegate.UnsentRequest makeHeartbeatRequest(long currentTimeMs, boolean ignoreResponse) {
        NetworkClientDelegate.UnsentRequest request = this.makeHeartbeatRequest(ignoreResponse);
        this.heartbeatRequestState.onSendAttempt(currentTimeMs);
        this.shareMembershipManager.onHeartbeatRequestSent();
        this.metricsManager.recordHeartbeatSentMs(currentTimeMs);
        this.heartbeatRequestState.resetTimer();
        return request;
    }

    private NetworkClientDelegate.UnsentRequest makeHeartbeatRequest(boolean ignoreResponse) {
        NetworkClientDelegate.UnsentRequest request = new NetworkClientDelegate.UnsentRequest(new ShareGroupHeartbeatRequest.Builder(this.heartbeatState.buildRequestData()), this.coordinatorRequestManager.coordinator());
        if (ignoreResponse) {
            return this.logResponse(request);
        }
        return request.whenComplete((response, exception) -> {
            long completionTimeMs = request.handler().completionTimeMs();
            if (response != null) {
                this.metricsManager.recordRequestLatency(response.requestLatencyMs());
                this.onResponse((ShareGroupHeartbeatResponse)response.responseBody(), completionTimeMs);
            } else {
                this.onFailure((Throwable)exception, completionTimeMs);
            }
        });
    }

    private NetworkClientDelegate.UnsentRequest logResponse(NetworkClientDelegate.UnsentRequest request) {
        return request.whenComplete((response, exception) -> {
            if (response != null) {
                this.metricsManager.recordRequestLatency(response.requestLatencyMs());
                Errors error = Errors.forCode(((ShareGroupHeartbeatResponse)response.responseBody()).data().errorCode());
                if (error == Errors.NONE) {
                    this.logger.debug("ShareGroupHeartbeat responded successfully: {}", response);
                } else {
                    this.logger.error("ShareGroupHeartbeat failed because of {}: {}", (Object)error, response);
                }
            } else {
                this.logger.error("ShareGroupHeartbeat failed because of unexpected exception.", (Throwable)exception);
            }
        });
    }

    private void onFailure(Throwable exception, long responseTimeMs) {
        this.heartbeatRequestState.onFailedAttempt(responseTimeMs);
        this.heartbeatState.reset();
        if (exception instanceof RetriableException) {
            String message = String.format("ShareGroupHeartbeatRequest failed because of retriable exception. Will retry in %s ms: %s", this.heartbeatRequestState.remainingBackoffMs(responseTimeMs), exception.getMessage());
            this.logger.debug(message);
        } else {
            this.logger.error("ShareGroupHeartbeatRequest failed due to fatal error: {}", (Object)exception.getMessage());
            this.handleFatalFailure(exception);
        }
    }

    private void onResponse(ShareGroupHeartbeatResponse response, long currentTimeMs) {
        if (Errors.forCode(response.data().errorCode()) == Errors.NONE) {
            this.heartbeatRequestState.updateHeartbeatIntervalMs(response.data().heartbeatIntervalMs());
            this.heartbeatRequestState.onSuccessfulAttempt(currentTimeMs);
            this.shareMembershipManager.onHeartbeatSuccess(response.data());
            return;
        }
        this.onErrorResponse(response, currentTimeMs);
    }

    private void onErrorResponse(ShareGroupHeartbeatResponse response, long currentTimeMs) {
        Errors error = Errors.forCode(response.data().errorCode());
        String errorMessage = response.data().errorMessage();
        this.heartbeatState.reset();
        this.heartbeatRequestState.onFailedAttempt(currentTimeMs);
        switch (error) {
            case NOT_COORDINATOR: {
                String message = String.format("ShareGroupHeartbeatRequest failed because the group coordinator %s is incorrect. Will attempt to find the coordinator again and retry", this.coordinatorRequestManager.coordinator());
                this.logInfo(message, response, currentTimeMs);
                this.coordinatorRequestManager.markCoordinatorUnknown(errorMessage, currentTimeMs);
                this.heartbeatRequestState.reset();
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: {
                String message = String.format("ShareGroupHeartbeatRequest failed because the group coordinator %s is not available. Will attempt to find the coordinator again and retry", this.coordinatorRequestManager.coordinator());
                this.logInfo(message, response, currentTimeMs);
                this.coordinatorRequestManager.markCoordinatorUnknown(errorMessage, currentTimeMs);
                this.heartbeatRequestState.reset();
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                String message = String.format("ShareGroupHeartbeatRequest failed because the group coordinator %s is still loading.Will retry", this.coordinatorRequestManager.coordinator());
                this.logInfo(message, response, currentTimeMs);
                break;
            }
            case GROUP_AUTHORIZATION_FAILED: {
                GroupAuthorizationException exception = GroupAuthorizationException.forGroupId(this.shareMembershipManager.groupId());
                this.logger.error("ShareGroupHeartbeatRequest failed due to group authorization failure: {}", (Object)exception.getMessage());
                this.handleFatalFailure(error.exception(exception.getMessage()));
                break;
            }
            case INVALID_REQUEST: 
            case GROUP_MAX_SIZE_REACHED: 
            case UNSUPPORTED_VERSION: {
                this.logger.error("ShareGroupHeartbeatRequest failed due to {}: {}", (Object)error, (Object)errorMessage);
                this.handleFatalFailure(error.exception(errorMessage));
                break;
            }
            case UNKNOWN_MEMBER_ID: {
                String message = String.format("ShareGroupHeartbeatRequest failed because member %s is unknown.", this.shareMembershipManager.memberId());
                this.logInfo(message, response, currentTimeMs);
                this.shareMembershipManager.transitionToFenced();
                this.heartbeatRequestState.reset();
                break;
            }
            default: {
                this.logger.error("ShareGroupHeartbeatRequest failed due to unexpected error {}: {}", (Object)error, (Object)errorMessage);
                this.handleFatalFailure(error.exception(errorMessage));
            }
        }
    }

    private void logInfo(String message, ShareGroupHeartbeatResponse response, long currentTimeMs) {
        this.logger.info("{} in {}ms: {}", message, this.heartbeatRequestState.remainingBackoffMs(currentTimeMs), response.data().errorMessage());
    }

    private void handleFatalFailure(Throwable error) {
        this.backgroundEventHandler.add(new ErrorEvent(error));
        this.shareMembershipManager.transitionToFatal();
    }

    static class HeartbeatState {
        private final SubscriptionState subscriptions;
        private final ShareMembershipManager shareMembershipManager;
        private final SentFields sentFields;

        public HeartbeatState(SubscriptionState subscriptions, ShareMembershipManager shareMembershipManager) {
            this.subscriptions = subscriptions;
            this.shareMembershipManager = shareMembershipManager;
            this.sentFields = new SentFields();
        }

        public void reset() {
            this.sentFields.reset();
        }

        public ShareGroupHeartbeatRequestData buildRequestData() {
            ShareGroupHeartbeatRequestData data = new ShareGroupHeartbeatRequestData();
            data.setGroupId(this.shareMembershipManager.groupId());
            data.setMemberId(this.shareMembershipManager.memberId());
            data.setMemberEpoch(this.shareMembershipManager.memberEpoch());
            if (this.sentFields.rackId == null) {
                data.setRackId(this.shareMembershipManager.rackId());
                this.sentFields.rackId = this.shareMembershipManager.rackId();
            }
            boolean sendAllFields = this.shareMembershipManager.state() == MemberState.JOINING;
            TreeSet<String> subscribedTopicNames = new TreeSet<String>(this.subscriptions.subscription());
            if (sendAllFields || !subscribedTopicNames.equals(this.sentFields.subscribedTopicNames)) {
                data.setSubscribedTopicNames(new ArrayList<String>(this.subscriptions.subscription()));
                this.sentFields.subscribedTopicNames = subscribedTopicNames;
            }
            return data;
        }

        static class SentFields {
            private String rackId = null;
            private TreeSet<String> subscribedTopicNames = null;

            SentFields() {
            }

            void reset() {
                this.rackId = null;
                this.subscribedTopicNames = null;
            }
        }
    }

    static class HeartbeatRequestState
    extends RequestState {
        private final Timer heartbeatTimer;
        private long heartbeatIntervalMs;

        public HeartbeatRequestState(LogContext logContext, Time time, long heartbeatIntervalMs, long retryBackoffMs, long retryBackoffMaxMs, double jitter) {
            super(logContext, HeartbeatRequestState.class.getName(), retryBackoffMs, 2, retryBackoffMaxMs, jitter);
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            this.heartbeatTimer = time.timer(heartbeatIntervalMs);
        }

        private void update(long currentTimeMs) {
            this.heartbeatTimer.update(currentTimeMs);
        }

        public void resetTimer() {
            this.heartbeatTimer.reset(this.heartbeatIntervalMs);
        }

        @Override
        public String toStringBase() {
            return super.toStringBase() + ", heartbeatTimer=" + this.heartbeatTimer + ", heartbeatIntervalMs=" + this.heartbeatIntervalMs;
        }

        @Override
        public boolean canSendRequest(long currentTimeMs) {
            this.update(currentTimeMs);
            return this.heartbeatTimer.isExpired() && super.canSendRequest(currentTimeMs);
        }

        public long timeToNextHeartbeatMs(long currentTimeMs) {
            if (this.heartbeatTimer.isExpired()) {
                return this.remainingBackoffMs(currentTimeMs);
            }
            return this.heartbeatTimer.remainingMs();
        }

        @Override
        public void onFailedAttempt(long currentTimeMs) {
            this.heartbeatTimer.reset(0L);
            super.onFailedAttempt(currentTimeMs);
        }

        private void updateHeartbeatIntervalMs(long heartbeatIntervalMs) {
            if (this.heartbeatIntervalMs == heartbeatIntervalMs) {
                return;
            }
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            this.heartbeatTimer.updateAndReset(heartbeatIntervalMs);
        }
    }
}

