/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.armeria;

import com.linecorp.armeria.common.DefaultHttpRequest;
import com.linecorp.armeria.common.HttpHeaders;
import io.netty.util.AsciiString;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class Armeria084ServerInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        DefaultHttpRequest httpRequest = (DefaultHttpRequest)allArguments[1];
        HttpHeaders headers = httpRequest.headers();
        ContextCarrier carrier = new ContextCarrier();
        CarrierItem item = carrier.items();
        while (item.hasNext()) {
            item = item.next();
            item.setHeadValue((String)headers.get((Object)AsciiString.of((CharSequence)item.getHeadKey())));
        }
        AbstractSpan entrySpan = ContextManager.createEntrySpan((String)httpRequest.path(), (ContextCarrier)carrier);
        entrySpan.setComponent((Component)ComponentsDefine.ARMERIA);
        entrySpan.setLayer(SpanLayer.HTTP);
        entrySpan.setPeer(httpRequest.authority());
        Tags.URL.set(entrySpan, httpRequest.path());
        Tags.HTTP.METHOD.set(entrySpan, httpRequest.method().name());
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

